/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy.specialrelationships;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Authorization;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RelationshipChecker {
    private static final Log log = LogFactory.getLog(RelationshipChecker.class);
    protected static final String NS_CORE = "http://vivoweb.org/ontology/core#";
    protected static final String NS_OBO = "http://purl.obolibrary.org/obo/";
    protected static final String URI_RELATES = "http://vivoweb.org/ontology/core#relates";
    protected static final String URI_RELATED_BY = "http://vivoweb.org/ontology/core#relatedBy";
    protected static final String URI_INHERES_IN = "http://purl.obolibrary.org/obo/RO_0000052";
    protected static final String URI_REALIZES = "http://purl.obolibrary.org/obo/BFO_0000055";
    private final OntModel ontModel;

    public RelationshipChecker(OntModel ontModel) {
        this.ontModel = ontModel;
    }

    public boolean anyUrisInCommon(List<String> list1, List<String> list2) {
        ArrayList<String> urisInCommon = new ArrayList<String>(list1);
        urisInCommon.retainAll(list2);
        return !urisInCommon.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResourceOfType(String resourceUri, String typeUri) {
        Selector selector = this.createSelector(resourceUri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", typeUri);
        StmtIterator stmts = null;
        this.ontModel.enterCriticalSection(true);
        try {
            stmts = this.ontModel.listStatements(selector);
            if (stmts.hasNext()) {
                log.debug((Object)("resource '" + resourceUri + "' is of type '" + typeUri + "'"));
                boolean bl = true;
                return bl;
            }
            log.debug((Object)("resource '" + resourceUri + "' is not of type '" + typeUri + "'"));
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmts != null) {
                stmts.close();
            }
            this.ontModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getObjectsOfProperty(String resourceUri, String propertyUri) {
        ArrayList<String> list = new ArrayList<String>();
        Selector selector = this.createSelector(resourceUri, propertyUri, null);
        StmtIterator stmts = null;
        this.ontModel.enterCriticalSection(true);
        try {
            stmts = this.ontModel.listStatements(selector);
            while (stmts.hasNext()) {
                list.add(((Statement)stmts.next()).getObject().toString());
            }
            log.debug((Object)("Objects of property '" + propertyUri + "' on resource '" + resourceUri + "': " + list));
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            if (stmts != null) {
                stmts.close();
            }
            this.ontModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getObjectsOfLinkedProperty(String resourceUri, String linkUri, String propertyUri) {
        ArrayList<String> list = new ArrayList<String>();
        Selector selector = this.createSelector(resourceUri, linkUri, null);
        StmtIterator stmts = null;
        this.ontModel.enterCriticalSection(true);
        try {
            stmts = this.ontModel.listStatements(selector);
            while (stmts.hasNext()) {
                RDFNode contextNode = ((Statement)stmts.next()).getObject();
                if (!contextNode.isResource()) continue;
                log.debug((Object)("found context node for '" + resourceUri + "': " + contextNode));
                list.addAll(this.getObjectsOfProperty(contextNode.asResource().getURI(), propertyUri));
            }
            log.debug((Object)("Objects of linked properties '" + linkUri + "' ==> '" + propertyUri + "' on '" + resourceUri + "': " + list));
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            if (stmts != null) {
                stmts.close();
            }
            this.ontModel.leaveCriticalSection();
        }
    }

    public List<String> getObjectsThroughLinkingNode(String resourceUri, String property1Uri, String linkNodeTypeUri, String property2Uri) {
        ArrayList<String> list = new ArrayList<String>();
        for (String linkNodeUri : this.getObjectsOfProperty(resourceUri, property1Uri)) {
            if (!this.isResourceOfType(linkNodeUri, linkNodeTypeUri)) continue;
            list.addAll(this.getObjectsOfProperty(linkNodeUri, property2Uri));
        }
        return list;
    }

    public Selector createSelector(String subjectUri, String predicateUri, String objectUri) {
        Resource subject = subjectUri == null ? null : this.ontModel.getResource(subjectUri);
        return this.createSelector(subject, predicateUri, objectUri);
    }

    public Selector createSelector(Resource subject, String predicateUri, String objectUri) {
        Property predicate = predicateUri == null ? null : this.ontModel.getProperty(predicateUri);
        Resource object = objectUri == null ? null : this.ontModel.getResource(objectUri);
        return new SimpleSelector(subject, predicate, (RDFNode)object);
    }

    protected PolicyDecision authorizedDecision(String message) {
        return new BasicPolicyDecision(Authorization.AUTHORIZED, this.getClass().getSimpleName() + ": " + message);
    }
}

