/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import com.ibm.icu.util.Calendar;
import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import fedora.client.FedoraClient;
import fedora.common.Constants;
import fedora.server.management.FedoraAPIM;
import fedora.server.types.gen.Datastream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;

public class FedoraDatastreamController
extends VitroHttpServlet
implements Constants {
    private static String FEDORA_PROPERTIES = "/WEB-INF/fedora.properties";
    private static String DEFAULT_DSID = "DS1";
    private String fedoraUrl = null;
    private String adminUser = null;
    private String adminPassword = null;
    private String pidNamespace = null;
    private String configurationStatus = "<p>Fedora configuration not yet loaded</p>";
    private boolean configured = false;
    private boolean connected = false;
    private static final int DEFAULT_MAX_SIZE = 0x3200000;
    private static final String DEFAULT_BASE_DIR = "/usr/local/vitrofiles";
    private static String baseDirectoryForFiles = "/usr/local/vitrofiles";
    private static int maxFileSize = 0x3200000;
    protected String contentTypeProperty = "http://vitro.mannlib.cornell.edu/ns/fedora/0.1#contentType";
    protected String fileSizeProperty = "http://vitro.mannlib.cornell.edu/ns/fedora/0.1#fileSize";
    protected String fileNameProperty = "http://vitro.mannlib.cornell.edu/ns/fedora/0.1#fileName";
    protected String fileLocationProperty = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#fileLocation";
    protected String fileLabelProperty = RDFS.label.getURI();
    protected String checksumNodeProperty = "";
    protected String checksumNodeDateTimeProperty = "";
    protected String checksumNodeValueProperty = "";
    protected String checksumDataProperty = "";
    protected String deleteNs = "";
    protected String individualPrefix = "";
    protected String fedoraNs = "http://vitro.mannlib.cornell.edu/ns/fedora/0.1#";
    private static final String RELOAD_MSG = "<p>The fedora configuartion file will be reloaded if you edit the properties file and check the status.</p>\n";
    private static final Log log = LogFactory.getLog((String)FedoraDatastreamController.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            super.doGet(req, res);
            log.debug((Object)"In doGet");
            VitroRequest vreq = new VitroRequest(req);
            OntModel sessionOntModel = ModelAccess.on(this.getServletContext()).getOntModel();
            Class<FedoraDatastreamController> clazz = FedoraDatastreamController.class;
            synchronized (FedoraDatastreamController.class) {
                FedoraAPIM apim;
                FedoraClient fedora;
                if (this.fedoraUrl == null) {
                    this.setup(sessionOntModel, this.getServletContext());
                    if (this.fedoraUrl == null) {
                        throw new FdcException("Connection to the file repository is not setup correctly.  Could not read fedora.properties file");
                    }
                } else if (!this.canConnectToFedoraServer()) {
                    this.fedoraUrl = null;
                    throw new FdcException("Could not connect to Fedora.");
                }
                // ** MonitorExit[var5_7] (shouldn't be in output)
                try {
                    fedora = new FedoraClient(this.fedoraUrl, this.adminUser, this.adminPassword);
                }
                catch (MalformedURLException e) {
                    throw new FdcException("Malformed URL for fedora Repository location: " + this.fedoraUrl);
                }
                try {
                    apim = fedora.getAPIM();
                }
                catch (Exception e) {
                    throw new FdcException("could not create fedora APIM:" + e.getMessage());
                }
                if (req.getParameter("uri") == null || "".equals(req.getParameter("uri"))) {
                    throw new FdcException("No file uri specified in request");
                }
                boolean isDelete = req.getParameter("delete") != null && "true".equals(req.getParameter("delete"));
                String fileUri = req.getParameter("uri");
                IndividualDao iwDao = vreq.getWebappDaoFactory().getIndividualDao();
                Individual entity = iwDao.getIndividualByURI(fileUri);
                if (entity == null) {
                    throw new FdcException("No entity found in system for file uri " + fileUri);
                }
                if (entity.getDataPropertyMap().get("http://vitro.mannlib.cornell.edu/ns/fedora/0.1#fedoraPid") == null) {
                    throw new FdcException("No fedora:pid found in system for file uri " + fileUri);
                }
                List<DataPropertyStatement> stmts = entity.getDataPropertyMap().get("http://vitro.mannlib.cornell.edu/ns/fedora/0.1#fedoraPid").getDataPropertyStatements();
                if (stmts == null || stmts.size() == 0) {
                    throw new FdcException("No fedora:pid found in system for file uri " + fileUri);
                }
                String pid = null;
                for (DataPropertyStatement stmt : stmts) {
                    if (stmt.getData() == null || stmt.getData().length() <= 0) continue;
                    pid = stmt.getData();
                    break;
                }
                if (pid == null) {
                    throw new FdcException("No fedora:pid found in system for file uri " + fileUri);
                }
                req.setAttribute("pid", pid);
                req.setAttribute("fileUri", (Object)fileUri);
                req.setAttribute("fileName", (Object)entity.getName());
                if (isDelete) {
                    List<ObjectPropertyStatement> fromDsStmts;
                    String datasetUri = null;
                    ObjectProperty fromDataSet = entity.getObjectPropertyMap().get(this.fedoraNs + "fromDataSet");
                    if (fromDataSet != null && (fromDsStmts = fromDataSet.getObjectPropertyStatements()).size() > 0) {
                        datasetUri = fromDsStmts.get(0).getObjectURI();
                    }
                    req.setAttribute("dataseturi", datasetUri);
                    boolean success = this.deleteFile(req, entity, iwDao, sessionOntModel);
                    req.setAttribute("deletesuccess", (Object)(success ? "success" : "error"));
                    req.setAttribute("bodyJsp", (Object)"/edit/fileDeleteConfirm.jsp");
                    RequestDispatcher rd = req.getRequestDispatcher("/templates/page/basicPage.jsp");
                    rd.forward((ServletRequest)req, (ServletResponse)res);
                } else {
                    Datastream ds = apim.getDatastream(pid, DEFAULT_DSID, null);
                    if (ds == null) {
                        throw new FdcException("There was no datastream in the repository for " + pid + " " + DEFAULT_DSID);
                    }
                    req.setAttribute("dsid", (Object)DEFAULT_DSID);
                    req.setAttribute("bodyJsp", (Object)"/fileupload/datastreamModification.jsp");
                    RequestDispatcher rd = req.getRequestDispatcher("/templates/page/basicPage.jsp");
                    rd.forward((ServletRequest)req, (ServletResponse)res);
                }
            }
        }
        catch (FdcException ex) {
            req.setAttribute("errors", (Object)ex.getMessage());
            RequestDispatcher rd = req.getRequestDispatcher("/edit/fileUploadError.jsp");
            rd.forward((ServletRequest)req, (ServletResponse)res);
            return;
        }
    }

    @Override
    public long maximumMultipartFileSize() {
        return maxFileSize;
    }

    @Override
    public boolean stashFileSizeException() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPost(HttpServletRequest rawRequest, HttpServletResponse res) throws ServletException, IOException {
        try {
            VitroRequest req = new VitroRequest(rawRequest);
            if (req.hasFileSizeException()) {
                throw new FdcException("Size limit exceeded: " + req.getFileSizeException().getLocalizedMessage());
            }
            if (!req.isMultipart()) {
                throw new FdcException("Must POST a multipart encoded request");
            }
            OntModel sessionOntModel = ModelAccess.on(this.getServletContext()).getOntModel();
            Class<FedoraDatastreamController> clazz = FedoraDatastreamController.class;
            synchronized (FedoraDatastreamController.class) {
                List<ObjectPropertyStatement> csNodeStatements;
                DataProperty fileNameProperty;
                DataProperty checksumDp;
                DataProperty fileSize;
                FedoraAPIM apim;
                FedoraClient fedora;
                if (this.fedoraUrl == null) {
                    this.setup(sessionOntModel, this.getServletContext());
                    if (this.fedoraUrl == null) {
                        throw new FdcException("Connection to the file repository is not setup correctly.  Could not read fedora.properties file");
                    }
                } else if (!this.canConnectToFedoraServer()) {
                    this.fedoraUrl = null;
                    throw new FdcException("Could not connect to Fedora.");
                }
                // ** MonitorExit[var5_7] (shouldn't be in output)
                try {
                    fedora = new FedoraClient(this.fedoraUrl, this.adminUser, this.adminPassword);
                }
                catch (MalformedURLException e) {
                    throw new FdcException("Malformed URL for fedora Repository location: " + this.fedoraUrl);
                }
                try {
                    apim = fedora.getAPIM();
                }
                catch (Exception e) {
                    throw new FdcException("could not create fedora APIM:" + e.getMessage());
                }
                String pId = req.getParameter("pid");
                String dsId = req.getParameter("dsid");
                String fileUri = req.getParameter("fileUri");
                boolean useNewName = false;
                if ("true".equals(req.getParameter("useNewName"))) {
                    useNewName = true;
                }
                if (pId == null || pId.length() == 0) {
                    throw new FdcException("Your form submission did not contain enough information to complete your request.(Missing pid parameter)");
                }
                if (dsId == null || dsId.length() == 0) {
                    throw new FdcException("Your form submission did not contain enough information to complete your request.(Missing dsid parameter)");
                }
                if (fileUri == null || fileUri.length() == 0) {
                    throw new FdcException("Your form submission did not contain enough information to complete your request.(Missing fileUri parameter)");
                }
                FileItem fileRes = req.getFileItem("fileRes");
                if (fileRes == null) {
                    throw new FdcException("Your form submission did not contain enough information to complete your request.(Missing fileRes)");
                }
                VitroRequest vreq = new VitroRequest(rawRequest);
                IndividualDao iwDao = vreq.getWebappDaoFactory().getIndividualDao();
                Individual fileEntity = iwDao.getIndividualByURI(fileUri);
                Datastream ds = apim.getDatastream(pId, dsId, null);
                if (ds == null) {
                    throw new FdcException("There was no datastream in the repository for " + pId + " " + DEFAULT_DSID);
                }
                String originalName = fileRes.getName();
                String name = originalName.replaceAll("[,+\\\\/$%^&*#@!<>'\"~;]", "_");
                name = name.replace("..", "_");
                name = name.trim().toLowerCase();
                String saveLocation = baseDirectoryForFiles + File.separator + name;
                String savedName = name;
                int next = 0;
                boolean foundUnusedName = false;
                while (!foundUnusedName) {
                    File test = new File(saveLocation);
                    if (test.exists()) {
                        savedName = name + '(' + ++next + ')';
                        saveLocation = baseDirectoryForFiles + File.separator + savedName;
                        continue;
                    }
                    foundUnusedName = true;
                }
                File uploadedFile = new File(saveLocation);
                try {
                    fileRes.write(uploadedFile);
                }
                catch (Exception ex) {
                    log.error((Object)("Unable to save POSTed file. " + ex.getMessage()));
                    throw new FdcException("Unable to save file to the disk. " + ex.getMessage());
                }
                File file = new File(saveLocation);
                String uploadFileUri = fedora.uploadFile(file);
                String md5 = FedoraDatastreamController.md5hashForFile(file);
                md5 = md5.toLowerCase();
                apim.modifyDatastreamByReference(pId, dsId, null, null, fileRes.getContentType(), null, uploadFileUri, "MD5", null, null, false);
                String checksum = apim.compareDatastreamChecksum(pId, dsId, null);
                WebappDaoFactory wdf = vreq.getWebappDaoFactory();
                DataPropertyStatementImpl dps = null;
                DataProperty contentType = wdf.getDataPropertyDao().getDataPropertyByURI(this.contentTypeProperty);
                if (contentType != null) {
                    wdf.getDataPropertyStatementDao().deleteDataPropertyStatementsForIndividualByDataProperty(fileEntity, contentType);
                    dps = new DataPropertyStatementImpl();
                    dps.setIndividualURI(fileEntity.getURI());
                    dps.setDatapropURI(contentType.getURI());
                    dps.setData(fileRes.getContentType());
                    wdf.getDataPropertyStatementDao().insertNewDataPropertyStatement(dps);
                }
                if ((fileSize = wdf.getDataPropertyDao().getDataPropertyByURI(this.fileSizeProperty)) != null) {
                    wdf.getDataPropertyStatementDao().deleteDataPropertyStatementsForIndividualByDataProperty(fileEntity, fileSize);
                    dps = new DataPropertyStatementImpl();
                    dps.setIndividualURI(fileEntity.getURI());
                    dps.setDatapropURI(fileSize.getURI());
                    dps.setData(Long.toString(fileRes.getSize()));
                    wdf.getDataPropertyStatementDao().insertNewDataPropertyStatement(dps);
                }
                if ((checksumDp = wdf.getDataPropertyDao().getDataPropertyByURI(this.checksumDataProperty)) != null) {
                    wdf.getDataPropertyStatementDao().deleteDataPropertyStatementsForIndividualByDataProperty(fileEntity, checksumDp);
                    dps = new DataPropertyStatementImpl();
                    dps.setIndividualURI(fileEntity.getURI());
                    dps.setDatapropURI(checksumDp.getURI());
                    dps.setData(checksum);
                    wdf.getDataPropertyStatementDao().insertNewDataPropertyStatement(dps);
                }
                if ((fileNameProperty = wdf.getDataPropertyDao().getDataPropertyByURI(this.fileNameProperty)) != null) {
                    wdf.getDataPropertyStatementDao().deleteDataPropertyStatementsForIndividualByDataProperty(fileEntity, fileNameProperty);
                    dps = new DataPropertyStatementImpl();
                    dps.setIndividualURI(fileEntity.getURI());
                    dps.setDatapropURI(fileNameProperty.getURI());
                    dps.setData(originalName);
                    wdf.getDataPropertyStatementDao().insertNewDataPropertyStatement(dps);
                }
                if ((csNodeStatements = fileEntity.getObjectPropertyMap().get(this.checksumNodeProperty).getObjectPropertyStatements()).size() == 0) {
                    System.out.println("No object property statements correspond to this property");
                } else {
                    DataProperty checksumNodeValue;
                    ObjectPropertyStatement cnodeStatement = csNodeStatements.get(0);
                    String cnodeUri = cnodeStatement.getObjectURI();
                    Individual checksumNodeObject = iwDao.getIndividualByURI(cnodeUri);
                    DataProperty checksumDateTime = wdf.getDataPropertyDao().getDataPropertyByURI(this.checksumNodeDateTimeProperty);
                    if (checksumDateTime != null) {
                        String newDatetime = sessionOntModel.createTypedLiteral((Object)new DateTime()).getString();
                        wdf.getDataPropertyStatementDao().deleteDataPropertyStatementsForIndividualByDataProperty(checksumNodeObject, checksumDateTime);
                        dps = new DataPropertyStatementImpl();
                        dps.setIndividualURI(checksumNodeObject.getURI());
                        dps.setDatapropURI(checksumDateTime.getURI());
                        dps.setData(newDatetime);
                        wdf.getDataPropertyStatementDao().insertNewDataPropertyStatement(dps);
                    }
                    if ((checksumNodeValue = wdf.getDataPropertyDao().getDataPropertyByURI(this.checksumDataProperty)) != null) {
                        wdf.getDataPropertyStatementDao().deleteDataPropertyStatementsForIndividualByDataProperty(checksumNodeObject, checksumNodeValue);
                        dps = new DataPropertyStatementImpl();
                        dps.setIndividualURI(checksumNodeObject.getURI());
                        dps.setDatapropURI(checksumNodeValue.getURI());
                        dps.setData(checksum);
                        wdf.getDataPropertyStatementDao().insertNewDataPropertyStatement(dps);
                    }
                }
                String originalEntityName = fileEntity.getName();
                if (originalEntityName != originalName) {
                    fileEntity.setName(originalName);
                }
                iwDao.updateIndividual(fileEntity);
                req.setAttribute("fileUri", fileUri);
                req.setAttribute("originalFileName", fileEntity.getName());
                req.setAttribute("checksum", checksum);
                if ("true".equals(useNewName)) {
                    req.setAttribute("useNewName", "true");
                    req.setAttribute("newFileName", originalName);
                } else {
                    req.setAttribute("newFileName", fileEntity.getName());
                }
                req.setAttribute("bodyJsp", "/fileupload/datastreamModificationSuccess.jsp");
                RequestDispatcher rd = req.getRequestDispatcher("/templates/page/basicPage.jsp");
                rd.forward((ServletRequest)req, (ServletResponse)res);
            }
        }
        catch (FdcException ex) {
            rawRequest.setAttribute("errors", (Object)ex.getMessage());
            RequestDispatcher rd = rawRequest.getRequestDispatcher("/edit/fileUploadError.jsp");
            rd.forward((ServletRequest)rawRequest, (ServletResponse)res);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(HttpServletRequest req, Individual entity, IndividualDao iwDao, OntModel sessionOntModel) {
        boolean success = false;
        String fileUri = entity.getURI();
        Calendar c = Calendar.getInstance();
        long timeMs = c.getTimeInMillis();
        SimpleDateFormat dateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        String formattedDeleteDate = dateTime.format(c.getTime());
        String deleteEventName = "deleteEvent" + timeMs;
        String userURI = LoginStatusBean.getBean(req).getUserURI();
        sessionOntModel.enterCriticalSection(true);
        try {
            String datasetUri = (String)req.getAttribute("dataseturi");
            com.hp.hpl.jena.ontology.ObjectProperty hasFileProperty = sessionOntModel.getObjectProperty(this.fedoraNs + "hasFile");
            com.hp.hpl.jena.ontology.ObjectProperty fromDatasetProperty = sessionOntModel.getObjectProperty(this.fedoraNs + "fromDataSet");
            if (hasFileProperty != null) {
                sessionOntModel.remove(sessionOntModel.createStatement(sessionOntModel.getResource(datasetUri), (Property)hasFileProperty, (RDFNode)sessionOntModel.getResource(fileUri)));
            }
            if (fromDatasetProperty != null) {
                sessionOntModel.remove(sessionOntModel.createStatement(sessionOntModel.getResource(fileUri), (Property)fromDatasetProperty, (RDFNode)sessionOntModel.getResource(datasetUri)));
            }
            Resource deleteEventType = sessionOntModel.createResource(this.deleteNs + "DeleteEvent");
            Resource eventIndividual = sessionOntModel.createResource(this.individualPrefix + deleteEventName);
            Statement rType = sessionOntModel.createStatement(eventIndividual, RDF.type, (RDFNode)deleteEventType);
            sessionOntModel.add(rType);
            DatatypeProperty dateTimeProp = sessionOntModel.createDatatypeProperty(this.deleteNs + "deleteDateTime");
            dateTimeProp.setRange(XSD.dateTime);
            com.hp.hpl.jena.ontology.ObjectProperty deletedByProp = sessionOntModel.createObjectProperty(this.deleteNs + "deletedBy");
            com.hp.hpl.jena.ontology.ObjectProperty forDatasetProp = sessionOntModel.createObjectProperty(this.deleteNs + "forDataset");
            com.hp.hpl.jena.ontology.ObjectProperty forFileProp = sessionOntModel.createObjectProperty(this.deleteNs + "forFile");
            eventIndividual.addProperty((Property)dateTimeProp, (RDFNode)sessionOntModel.createTypedLiteral(formattedDeleteDate, (RDFDatatype)XSDDatatype.XSDdateTime));
            eventIndividual.addProperty((Property)deletedByProp, (RDFNode)sessionOntModel.getResource(userURI));
            if (datasetUri != null) {
                eventIndividual.addProperty((Property)forDatasetProp, (RDFNode)sessionOntModel.getResource(datasetUri));
            }
            eventIndividual.addProperty((Property)forFileProp, (RDFNode)sessionOntModel.getResource(fileUri));
            success = true;
        }
        finally {
            sessionOntModel.leaveCriticalSection();
        }
        return success;
    }

    public void init() throws ServletException {
        super.init();
        ConfigurationProperties configProperties = ConfigurationProperties.getBean(this.getServletContext());
        baseDirectoryForFiles = configProperties.getProperty("n3.baseDirectoryForFiles", DEFAULT_BASE_DIR);
        String maxSize = configProperties.getProperty("n3.maxSize", Long.toString(0x3200000L));
        try {
            maxFileSize = Integer.parseInt(maxSize);
        }
        catch (NumberFormatException nfe) {
            log.error((Object)nfe);
            maxFileSize = 0x3200000;
        }
    }

    public void setup(OntModel model, ServletContext context) {
        this.configurationStatus = "";
        StringBuffer status = new StringBuffer("");
        if (this.connected && this.configured) {
            return;
        }
        Properties props = new Properties();
        String path = context.getRealPath(FEDORA_PROPERTIES);
        try {
            FileInputStream in = new FileInputStream(new File(path));
            props.load(in);
            this.fedoraUrl = props.getProperty("fedoraUrl");
            this.adminUser = props.getProperty("adminUser");
            this.adminPassword = props.getProperty("adminPassword");
            this.pidNamespace = props.getProperty("pidNamespace");
            if (this.fedoraUrl == null || this.adminUser == null || this.adminPassword == null) {
                if (this.fedoraUrl == null) {
                    log.error((Object)"'fedoraUrl' not found in properties file");
                    status.append("<p>'fedoraUrl' not found in properties file.</p>\n");
                }
                if (this.adminUser == null) {
                    log.error((Object)"'adminUser' was not found in properties file, the user name of the fedora admin is needed to access the fedora API-M services.");
                    status.append("<p>'adminUser' was not found in properties file, the user name of the fedora admin is needed to access the fedora API-M services.</p>\n");
                }
                if (this.adminPassword == null) {
                    log.error((Object)"'adminPassword' was not found in properties file, the admin password is needed to access the fedora API-M services.");
                    status.append("<p>'adminPassword' was not found in properties file, the admin password is needed to access the fedora API-M services.</p>\n");
                }
                if (this.pidNamespace == null) {
                    log.error((Object)"'pidNamespace' was not found in properties file, the PID namespace indicates which namespace to use when creating new fedor digital objects.");
                    status.append("<p>'pidNamespace' was not found in properties file, the PID namespace indicates which namespace to use when creating new fedor digital objects.</p>\n");
                }
                this.fedoraUrl = null;
                this.adminUser = null;
                this.adminPassword = null;
                this.configured = false;
            } else {
                this.configured = true;
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)("No fedora.properties file found,it should be located at " + path));
            status.append("<h1>Fedora configuration failed.</h1>\n");
            status.append("<p>No fedora.properties file found,it should be located at " + path + "</p>\n");
            this.configured = false;
            return;
        }
        catch (Exception ex) {
            status.append("<p>Fedora configuration failed.</p>\n");
            status.append("<p>Exception while loading" + path + "</p>\n");
            status.append("<p>" + ex.getMessage() + "</p>\n");
            log.error((Object)"could not load fedora properties", (Throwable)ex);
            this.fedoraUrl = null;
            this.adminUser = null;
            this.adminPassword = null;
            this.configured = false;
            return;
        }
        status.append(RELOAD_MSG);
        this.configurationStatus = this.configurationStatus + status.toString();
    }

    private boolean canConnectToFedoraServer() {
        try {
            FedoraClient fc = new FedoraClient(this.fedoraUrl, this.adminUser, this.adminPassword);
            String fedoraVersion = fc.getServerVersion();
            if (fedoraVersion != null && fedoraVersion.length() > 0) {
                this.configurationStatus = this.configurationStatus + "<p>Fedora server is live and is running fedora version " + fedoraVersion + "</p>\n";
                this.connected = true;
                return true;
            }
            this.configurationStatus = this.configurationStatus + "<p>Unable to reach fedora server</p>\n";
            this.connected = false;
            return false;
        }
        catch (Exception e) {
            this.configurationStatus = this.configurationStatus + "<p>There was an error while checking the fedora server version</p>\n<p>" + e.getMessage() + "</p>\n";
            this.connected = false;
            return false;
        }
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public static String md5hashForFile(File file) {
        try {
            int read;
            FileInputStream fin = new FileInputStream(file);
            MessageDigest md5er = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            do {
                if ((read = ((InputStream)fin).read(buffer)) <= 0) continue;
                md5er.update(buffer, 0, read);
            } while (read != -1);
            ((InputStream)fin).close();
            byte[] digest = md5er.digest();
            if (digest == null) {
                return null;
            }
            String strDigest = "0x";
            for (int i = 0; i < digest.length; ++i) {
                strDigest = strDigest + Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1);
            }
            return strDigest;
        }
        catch (Exception e) {
            return null;
        }
    }

    private class FdcException
    extends Exception {
        public FdcException(String message) {
            super(message);
        }
    }
}

