/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.ajax;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDao;
import edu.cornell.mannlib.vitro.webapp.utils.SparqlQueryRunner;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;

public abstract class AbstractAjaxResponder {
    private static final Log log = LogFactory.getLog(AbstractAjaxResponder.class);
    protected static final String EMPTY_RESPONSE = "[]";
    protected final HttpServlet servlet;
    protected final VitroRequest vreq;
    protected final HttpServletResponse resp;
    protected final IndividualDao indDao;
    protected final UserAccountsDao uaDao;

    public AbstractAjaxResponder(HttpServlet servlet, VitroRequest vreq, HttpServletResponse resp) {
        this.servlet = servlet;
        this.vreq = vreq;
        this.resp = resp;
        this.indDao = vreq.getWebappDaoFactory().getIndividualDao();
        this.uaDao = vreq.getWebappDaoFactory().getUserAccountsDao();
    }

    public final void processRequest() {
        try {
            this.resp.getWriter().write(this.prepareResponse());
        }
        catch (Exception e) {
            log.error((Object)"Problem with AJAX response", (Throwable)e);
        }
    }

    protected abstract String prepareResponse() throws IOException, JSONException;

    protected String getStringParameter(String key, String defaultValue) {
        String value = this.vreq.getParameter(key);
        return value == null ? defaultValue : value;
    }

    protected Collection<String> getStringParameters(String key) {
        String[] values = this.vreq.getParameterValues(key);
        if (values == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(values));
    }

    protected String assembleJsonResponse(List<Map<String, String>> maps) {
        JSONArray jsonArray = new JSONArray();
        for (Map<String, String> map : maps) {
            jsonArray.put(map);
        }
        return jsonArray.toString();
    }

    protected static abstract class JsonArrayParser
    extends SparqlQueryRunner.QueryParser<JSONArray> {
        protected JsonArrayParser() {
        }

        @Override
        protected JSONArray defaultValue() {
            return new JSONArray();
        }

        @Override
        protected JSONArray parseResults(String queryStr, ResultSet results) {
            JSONArray jsonArray = new JSONArray();
            while (results.hasNext()) {
                Map<String, String> map = this.parseSolutionRow(results.next());
                if (map == null) continue;
                jsonArray.put(map);
            }
            return jsonArray;
        }

        protected abstract Map<String, String> parseSolutionRow(QuerySolution var1);
    }
}

