/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.authenticate;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogoutRedirector {
    private static final Log log = LogFactory.getLog(LogoutRedirector.class);
    private static final String ATTRIBUTE_RESTRICTED_PAGE_URIS = "uris_of_restricted_pages";

    public static String getRedirectUrl(HttpServletRequest request, HttpServletResponse response, String referrer) throws IOException {
        String referringUri = LogoutRedirector.figureUriFromUrl(request, referrer);
        log.debug((Object)("referringUri: '" + referringUri + "', restrictedUris=" + LogoutRedirector.getRestrictedPageUris(request)));
        if (referringUri == null || LogoutRedirector.getRestrictedPageUris(request).contains(referringUri)) {
            log.debug((Object)"Sending to home page.");
            return request.getContextPath();
        }
        log.debug((Object)"Sending back to referring page.");
        return referrer;
    }

    private static String figureUriFromUrl(HttpServletRequest request, String referrer) {
        String postContext = LogoutRedirector.breakBeforeContextPath(request.getContextPath(), referrer);
        String uri = LogoutRedirector.removeQueryString(postContext);
        log.debug((Object)("referrer='" + referrer + "', uri='" + uri + "'"));
        return uri;
    }

    private static String breakBeforeContextPath(String contextPath, String url) {
        if (url == null) {
            return null;
        }
        int contextHere = url.indexOf(contextPath);
        if (contextHere == -1) {
            return null;
        }
        return url.substring(contextHere);
    }

    private static String removeQueryString(String fragment) {
        if (fragment == null) {
            return null;
        }
        int questionHere = fragment.indexOf(63);
        if (questionHere == -1) {
            return fragment;
        }
        return fragment.substring(0, questionHere);
    }

    public static void recordRestrictedPageUri(HttpServletRequest request) {
        String uri = request.getRequestURI();
        log.debug((Object)("Recording restricted URI: '" + uri + "'"));
        LogoutRedirector.getRestrictedPageUris(request).add(uri);
    }

    private static Set<String> getRestrictedPageUris(HttpServletRequest request) {
        HttpSession session = request.getSession();
        HashSet restrictedPageUris = (HashSet)session.getAttribute(ATTRIBUTE_RESTRICTED_PAGE_URIS);
        if (restrictedPageUris == null) {
            restrictedPageUris = new HashSet();
            session.setAttribute(ATTRIBUTE_RESTRICTED_PAGE_URIS, restrictedPageUris);
        }
        return restrictedPageUris;
    }
}

