/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapper;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapperFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactorySDB;
import edu.cornell.mannlib.vitro.webapp.filestorage.model.ImageInfo;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;

public class IndividualSDB
extends IndividualImpl
implements Individual {
    private static final Log log = LogFactory.getLog((String)IndividualSDB.class.getName());
    private OntResource ind = null;
    private WebappDaoFactorySDB webappDaoFactory = null;
    private Float _searchBoostJena = null;
    private boolean retreivedNullRdfsLabel = false;
    private DatasetWrapperFactory dwf = null;
    private WebappDaoFactorySDB.SDBDatasetMode datasetMode = WebappDaoFactorySDB.SDBDatasetMode.ASSERTIONS_AND_INFERENCES;
    private String individualURI = null;
    private Model model = null;
    private Boolean _hasThumb = null;
    static final boolean SKIP_INITIALIZATION = true;
    private Collator collator = Collator.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndividualSDB(String individualURI, DatasetWrapperFactory datasetWrapperFactory, WebappDaoFactorySDB.SDBDatasetMode datasetMode, WebappDaoFactorySDB wadf, Model initModel) {
        this.individualURI = individualURI;
        this.webappDaoFactory = wadf;
        this.dwf = datasetWrapperFactory;
        try {
            initModel.getLock().enterCriticalSection(true);
            String getStatements = "CONSTRUCT \n{ <" + individualURI + ">  <" + RDFS.label.getURI() + "> ?ooo. \n" + "<" + individualURI + ">  a ?type . \n" + "} \n" + "WHERE { \n" + "{ <" + individualURI + ">  <" + RDFS.label.getURI() + "> ?ooo }  \n" + " UNION { <" + individualURI + "> a ?type } \n" + "} ";
            this.model = QueryExecutionFactory.create((Query)QueryFactory.create((String)getStatements), (Model)initModel).execConstruct();
        }
        finally {
            initModel.getLock().leaveCriticalSection();
        }
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)this.model);
        this.ind = ontModel.createOntResource(individualURI);
        this.setUpURIParts(this.ind);
    }

    public IndividualSDB(String individualURI, DatasetWrapperFactory datasetWrapperFactory, WebappDaoFactorySDB.SDBDatasetMode datasetMode, WebappDaoFactorySDB wadf, boolean skipInitialization) throws IndividualNotFoundException {
        this.individualURI = individualURI;
        this.datasetMode = datasetMode;
        this.dwf = datasetWrapperFactory;
        this.webappDaoFactory = wadf;
        if (skipInitialization) {
            OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
            this.ind = ontModel.createOntResource(individualURI);
        } else {
            try {
                String getStatements = "CONSTRUCT { <" + individualURI + ">  <" + RDFS.label.getURI() + "> ?ooo \n" + "} WHERE {" + "{ <" + individualURI + ">  <" + RDFS.label.getURI() + "> ?ooo } \n" + "}";
                this.model = ModelFactory.createDefaultModel();
                this.webappDaoFactory.getRDFService().sparqlConstructQuery(getStatements, this.model);
            }
            catch (RDFServiceException getStatements) {
                // empty catch block
            }
            OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)this.model);
            if (this.model.isEmpty() && this.noTriplesFor(individualURI)) {
                throw new IndividualNotFoundException();
            }
            this.ind = ontModel.createOntResource(individualURI);
        }
        this.setUpURIParts(this.ind);
    }

    private boolean noTriplesFor(String individualURI) {
        try {
            return !this.webappDaoFactory.getRDFService().sparqlAskQuery("ASK { <" + individualURI + "> ?p ?o }");
        }
        catch (RDFServiceException rDFServiceException) {
            return true;
        }
    }

    public IndividualSDB(String individualURI, DatasetWrapperFactory datasetWrapperFactory, WebappDaoFactorySDB.SDBDatasetMode datasetMode, WebappDaoFactorySDB wadf) throws IndividualNotFoundException {
        this(individualURI, datasetWrapperFactory, datasetMode, wadf, false);
    }

    private void setUpURIParts(OntResource ind) {
        if (ind != null) {
            if (ind.isAnon()) {
                this.setNamespace("http://vitro.mannlib.cornell.edu/ns/bnode#");
                this.setLocalName(ind.getId().toString());
            } else {
                this.URI = ind.getURI();
                this.namespace = ind.getNameSpace();
                this.localName = ind.getLocalName();
            }
        } else if (this.individualURI != null) {
            log.warn((Object)("Null individual returned for URI " + this.individualURI));
        }
    }

    private DatasetWrapper getDatasetWrapper() {
        return this.dwf.getDatasetWrapper();
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        this.ind.getOntModel().enterCriticalSection(true);
        try {
            this.name = this.webappDaoFactory.getJenaBaseDao().getLabelOrId(this.ind);
            if (this.name == null) {
                this.name = "[null]";
            }
            String string = this.name;
            return string;
        }
        finally {
            this.ind.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public String getRdfsLabel() {
        if (this.rdfsLabel != null) {
            return this.rdfsLabel;
        }
        if (this.rdfsLabel == null && this.retreivedNullRdfsLabel) {
            return null;
        }
        this.ind.getOntModel().enterCriticalSection(true);
        try {
            this.rdfsLabel = this.webappDaoFactory.getJenaBaseDao().getLabel(this.ind);
            this.retreivedNullRdfsLabel = this.rdfsLabel == null;
            String string = this.rdfsLabel;
            return string;
        }
        finally {
            this.ind.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public String getVClassURI() {
        if (this.vClassURI != null) {
            return this.vClassURI;
        }
        List<VClass> clist = this.getVClasses(true);
        return clist.size() > 0 ? clist.get(0).getURI() : null;
    }

    @Override
    public VClass getVClass() {
        if (this.vClass != null) {
            return this.vClass;
        }
        List<VClass> clist = this.getVClasses(true);
        return clist.size() > 0 ? clist.get(0) : null;
    }

    @Override
    public List<String> getMostSpecificTypeURIs() {
        final ArrayList<String> typeURIs = new ArrayList<String>();
        if (this.getURI() == null) {
            return typeURIs;
        }
        String queryStr = "SELECT ?type WHERE { <" + this.getURI() + "> <" + "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#mostSpecificType" + "> ?type }";
        try {
            this.webappDaoFactory.getRDFService().sparqlSelectQuery(queryStr, new ResultSetConsumer(){

                @Override
                protected void processQuerySolution(QuerySolution qs) {
                    RDFNode node = qs.get("type");
                    if (node.isURIResource()) {
                        typeURIs.add(node.asResource().getURI());
                    }
                }
            });
            return typeURIs;
        }
        catch (RDFServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Timestamp getModTime() {
        if (this.modTime != null) {
            return this.modTime;
        }
        this.ind.getOntModel().enterCriticalSection(true);
        try {
            Date modDate = this.webappDaoFactory.getJenaBaseDao().getPropertyDateTimeValue(this.ind, (Property)this.webappDaoFactory.getJenaBaseDao().MODTIME);
            if (modDate != null) {
                this.modTime = new Timestamp(modDate.getTime());
            }
            Timestamp timestamp = this.modTime;
            return timestamp;
        }
        finally {
            this.ind.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float getSearchBoost() {
        block9: {
            if (this._searchBoostJena != null) {
                return this._searchBoostJena;
            }
            String getPropertyValue = "SELECT ?value \nWHERE { \n<" + this.individualURI + "> <" + this.webappDaoFactory.getJenaBaseDao().SEARCH_BOOST_ANNOT + "> ?value \n" + "}";
            DatasetWrapper w = this.getDatasetWrapper();
            Dataset dataset = w.getDataset();
            dataset.getLock().enterCriticalSection(true);
            QueryExecution qe = QueryExecutionFactory.create((Query)QueryFactory.create((String)getPropertyValue), (Dataset)dataset);
            try {
                ResultSet rs = qe.execSelect();
                if (rs.hasNext()) {
                    QuerySolution qs = rs.nextSolution();
                    if (qs.get("value") != null) {
                        Literal value = qs.get("value").asLiteral();
                        Float f = this.searchBoost = Float.valueOf(Float.parseFloat(value.getLexicalForm()));
                        return f;
                    }
                    break block9;
                }
                Float f = null;
                return f;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                Float f = null;
                return f;
            }
            finally {
                qe.close();
                dataset.getLock().leaveCriticalSection();
                w.close();
            }
        }
        return null;
    }

    @Override
    public String getMainImageUri() {
        if (this.mainImageUri != "__%NOT_INITIALIZED%__") {
            return this.mainImageUri;
        }
        List<ObjectPropertyStatement> mainImgStmts = this.getObjectPropertyStatements("http://vitro.mannlib.cornell.edu/ns/vitro/public#mainImage");
        if (mainImgStmts != null && mainImgStmts.size() > 0) {
            this.mainImageUri = mainImgStmts.get(0).getObjectURI();
            return this.mainImageUri;
        }
        return null;
    }

    @Override
    public String getImageUrl() {
        if (this.imageInfo == null) {
            this.imageInfo = ImageInfo.instanceFromEntityUri(this.webappDaoFactory, this);
            log.trace((Object)("figured imageInfo for " + this.getURI() + ": '" + this.imageInfo + "'"));
        }
        if (this.imageInfo == null) {
            this.imageInfo = ImageInfo.EMPTY_IMAGE_INFO;
            log.trace((Object)("imageInfo for " + this.getURI() + " is empty."));
        }
        return this.imageInfo.getMainImage().getBytestreamAliasUrl();
    }

    @Override
    public String getThumbUrl() {
        if (this.imageInfo == null) {
            this.imageInfo = ImageInfo.instanceFromEntityUri(this.webappDaoFactory, this);
            log.trace((Object)("figured imageInfo for " + this.getURI() + ": '" + this.imageInfo + "'"));
        }
        if (this.imageInfo == null) {
            this.imageInfo = ImageInfo.EMPTY_IMAGE_INFO;
            log.trace((Object)("imageInfo for " + this.getURI() + " is empty."));
        }
        return this.imageInfo.getThumbnail().getBytestreamAliasUrl();
    }

    @Override
    public boolean hasThumb() {
        if (this._hasThumb != null) {
            return this._hasThumb;
        }
        String ask = "ASK {     <" + this.individualURI + "> <http://vitro.mannlib.cornell.edu/ns/vitro/public#mainImage> ?mainImage . \n" + "    ?mainImage <http://vitro.mannlib.cornell.edu/ns/vitro/public#thumbnailImage> ?thumbImage . }\n";
        try {
            this._hasThumb = this.webappDaoFactory.getRDFService().sparqlAskQuery(ask);
        }
        catch (Exception ex) {
            this._hasThumb = false;
            log.error((Object)ex, (Throwable)ex);
        }
        return this._hasThumb;
    }

    @Override
    public List<ObjectPropertyStatement> getObjectPropertyStatements() {
        if (this.objectPropertyStatements != null) {
            return this.objectPropertyStatements;
        }
        try {
            this.webappDaoFactory.getObjectPropertyStatementDao().fillExistingObjectPropertyStatements(this);
        }
        catch (Exception e) {
            log.error((Object)("Could not fill existing ObjectPropertyStatements for " + this.getURI()), (Throwable)e);
        }
        return this.objectPropertyStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectPropertyStatement> getObjectPropertyStatements(String propertyURI) {
        if (propertyURI == null) {
            return null;
        }
        ArrayList<ObjectPropertyStatement> objectPropertyStatements = new ArrayList<ObjectPropertyStatement>();
        Model tempModel = ModelFactory.createDefaultModel();
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        DatasetWrapper w = this.getDatasetWrapper();
        Dataset dataset = w.getDataset();
        dataset.getLock().enterCriticalSection(true);
        QueryExecution qexec = null;
        try {
            String valuesOfProperty = "CONSTRUCT{ <" + this.individualURI + "> <" + propertyURI + "> ?object }" + "WHERE{ <" + this.individualURI + "> <" + propertyURI + "> ?object } \n";
            qexec = QueryExecutionFactory.create((Query)QueryFactory.create((String)valuesOfProperty), (Dataset)dataset);
            tempModel = qexec.execConstruct();
            ontModel.add(tempModel.listStatements());
            Resource ontRes = ontModel.getResource(this.individualURI);
            StmtIterator sit = ontRes.listProperties(ontRes.getModel().getProperty(propertyURI));
            while (sit.hasNext()) {
                Statement s = sit.nextStatement();
                if (!s.getSubject().canAs(OntResource.class) || !s.getObject().canAs(OntResource.class)) continue;
                IndividualSDB subj = null;
                try {
                    subj = new IndividualSDB(((OntResource)s.getSubject().as(OntResource.class)).getURI(), this.dwf, this.datasetMode, this.webappDaoFactory);
                }
                catch (IndividualNotFoundException individualNotFoundException) {
                    // empty catch block
                }
                IndividualSDB obj = null;
                try {
                    obj = new IndividualSDB(((OntResource)s.getObject().as(OntResource.class)).getURI(), this.dwf, this.datasetMode, this.webappDaoFactory);
                }
                catch (IndividualNotFoundException individualNotFoundException) {
                    // empty catch block
                }
                ObjectProperty op = this.webappDaoFactory.getObjectPropertyDao().getObjectPropertyByURI(s.getPredicate().getURI());
                if (op == null) {
                    op = new ObjectProperty();
                    op.setURI(propertyURI);
                }
                if (subj == null || obj == null) continue;
                ObjectPropertyStatementImpl ops = new ObjectPropertyStatementImpl();
                ops.setSubject(subj);
                ops.setSubjectURI(subj.getURI());
                ops.setObject(obj);
                ops.setObjectURI(obj.getURI());
                ops.setProperty(op);
                ops.setPropertyURI(op.getURI());
                objectPropertyStatements.add(ops);
            }
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
            tempModel.close();
            ontModel.close();
            dataset.getLock().leaveCriticalSection();
            w.close();
        }
        return objectPropertyStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Individual> getRelatedIndividuals(String propertyURI) {
        if (propertyURI == null) {
            return null;
        }
        ArrayList<Individual> relatedIndividuals = new ArrayList<Individual>();
        DatasetWrapper w = this.getDatasetWrapper();
        Dataset dataset = w.getDataset();
        dataset.getLock().enterCriticalSection(true);
        try {
            String valuesOfProperty = "SELECT ?object WHERE{ <" + this.individualURI + "> <" + propertyURI + "> ?object } \n";
            ResultSet values = QueryExecutionFactory.create((Query)QueryFactory.create((String)valuesOfProperty), (Dataset)dataset).execSelect();
            QuerySolution result = null;
            while (values.hasNext()) {
                result = values.next();
                RDFNode value = result.get("object");
                try {
                    if (!value.canAs(OntResource.class)) continue;
                    relatedIndividuals.add(new IndividualSDB(((OntResource)value.as(OntResource.class)).getURI(), this.dwf, this.datasetMode, this.webappDaoFactory));
                }
                catch (IndividualNotFoundException individualNotFoundException) {}
            }
        }
        finally {
            dataset.getLock().leaveCriticalSection();
            w.close();
        }
        return relatedIndividuals;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Individual getRelatedIndividual(String propertyURI) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<ObjectProperty> getObjectPropertyList() {
        if (this.propertyList != null) {
            return this.propertyList;
        }
        try {
            this.webappDaoFactory.getObjectPropertyDao().fillObjectPropertiesForIndividual(this);
        }
        catch (Exception e) {
            log.error((Object)("Could not fillEntityProperties for " + this.getURI()), (Throwable)e);
        }
        return this.propertyList;
    }

    @Override
    public List<ObjectProperty> getPopulatedObjectPropertyList() {
        if (this.populatedObjectPropertyList == null) {
            this.populatedObjectPropertyList = this.webappDaoFactory.getObjectPropertyDao().getObjectPropertyList(this);
        }
        return this.populatedObjectPropertyList;
    }

    @Override
    public Map<String, ObjectProperty> getObjectPropertyMap() {
        if (this.objectPropertyMap != null) {
            return this.objectPropertyMap;
        }
        HashMap<String, ObjectProperty> map = new HashMap<String, ObjectProperty>();
        if (this.propertyList == null) {
            this.getObjectPropertyList();
        }
        for (ObjectProperty op : this.propertyList) {
            if (op.getURI() == null) continue;
            map.put(op.getURI(), op);
        }
        this.objectPropertyMap = map;
        return map;
    }

    @Override
    public List<DataPropertyStatement> getDataPropertyStatements() {
        if (this.dataPropertyStatements != null) {
            return this.dataPropertyStatements;
        }
        try {
            this.webappDaoFactory.getDataPropertyStatementDao().fillExistingDataPropertyStatementsForIndividual(this);
        }
        catch (Exception e) {
            log.error((Object)("Could not fill existing DataPropertyStatements for " + this.getURI()), (Throwable)e);
        }
        return this.dataPropertyStatements;
    }

    public List getDataPropertyList() {
        if (this.datatypePropertyList != null) {
            return this.datatypePropertyList;
        }
        try {
            this.webappDaoFactory.getDataPropertyDao().fillDataPropertiesForIndividual(this);
        }
        catch (Exception e) {
            log.error((Object)("Could not fill data properties for " + this.getURI()), (Throwable)e);
        }
        return this.datatypePropertyList;
    }

    @Override
    public List<DataProperty> getPopulatedDataPropertyList() {
        if (this.populatedDataPropertyList == null) {
            this.populatedDataPropertyList = this.webappDaoFactory.getDataPropertyDao().getDataPropertyList(this);
        }
        return this.populatedDataPropertyList;
    }

    @Override
    public Map<String, DataProperty> getDataPropertyMap() {
        if (this.dataPropertyMap != null) {
            return this.dataPropertyMap;
        }
        HashMap<String, DataProperty> map = new HashMap<String, DataProperty>();
        if (this.datatypePropertyList == null) {
            this.getDataPropertyList();
        }
        for (DataProperty dp : this.datatypePropertyList) {
            if (dp.getURI() == null) continue;
            map.put(dp.getURI(), dp);
        }
        this.dataPropertyMap = map;
        return map;
    }

    @Override
    public List<DataPropertyStatement> getDataPropertyStatements(String propertyUri) {
        List stmts = this.dataPropertyStatements;
        if (stmts == null) {
            return this.sparqlForDataPropertyStatements(propertyUri);
        }
        ArrayList<DataPropertyStatement> stmtsForProp = new ArrayList<DataPropertyStatement>();
        for (DataPropertyStatement stmt : stmts) {
            if (!stmt.getDatapropURI().equals(propertyUri)) continue;
            stmtsForProp.add(stmt);
        }
        return stmtsForProp;
    }

    @Override
    public String getDataValue(String propertyUri) {
        if (propertyUri == null) {
            log.error((Object)"Cannot retrieve value for null property");
            return null;
        }
        if (this.getURI() == null) {
            log.error((Object)("Cannot retrieve value of property " + propertyUri + " for anonymous individual"));
            return null;
        }
        List<DataPropertyStatement> stmts = this.sparqlForDataPropertyStatements(propertyUri);
        if (stmts != null && stmts.size() > 0) {
            return stmts.get(0).getData();
        }
        return null;
    }

    @Override
    public List<String> getDataValues(String propertyUri) {
        ArrayList<String> values = new ArrayList<String>();
        if (propertyUri == null) {
            log.error((Object)"Cannot retrieve value for null property");
            return null;
        }
        if (this.getURI() == null) {
            log.error((Object)("Cannot retrieve value of property " + propertyUri + " for anonymous individual"));
            return null;
        }
        List<DataPropertyStatement> stmts = this.sparqlForDataPropertyStatements(propertyUri);
        if (stmts != null) {
            for (DataPropertyStatement stmt : stmts) {
                values.add(stmt.getData());
            }
        }
        return values;
    }

    private List<DataPropertyStatement> sparqlForDataPropertyStatements(final String propertyUri) {
        final ArrayList<DataPropertyStatement> stmts = new ArrayList<DataPropertyStatement>();
        final IndividualSDB individualSDB = this;
        String queryStr = "SELECT (str(?value) as ?valueString) WHERE { <" + this.getURI() + "> <" + propertyUri + "> ?value }";
        try {
            this.webappDaoFactory.getRDFService().sparqlSelectQuery(queryStr, new ResultSetConsumer(){

                @Override
                protected void processQuerySolution(QuerySolution qs) {
                    RDFNode node = qs.get("valueString");
                    if (!node.isLiteral()) {
                        log.debug((Object)("Ignoring non-literal value for " + node + " for property " + propertyUri));
                    } else {
                        Literal lit = node.asLiteral();
                        DataPropertyStatementImpl stmt = new DataPropertyStatementImpl();
                        stmt.setData(lit.getLexicalForm());
                        stmt.setDatatypeURI(lit.getDatatypeURI());
                        stmt.setLanguage(lit.getLanguage());
                        stmt.setDatapropURI(propertyUri);
                        stmt.setIndividualURI(individualSDB.getURI());
                        stmt.setIndividual(individualSDB);
                        stmts.add(stmt);
                    }
                }
            });
        }
        catch (RDFServiceException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        return stmts;
    }

    @Override
    public List<DataPropertyStatement> getExternalIds() {
        if (this.externalIds != null) {
            return this.externalIds;
        }
        try {
            ArrayList<DataPropertyStatement> dpsList = new ArrayList<DataPropertyStatement>();
            dpsList.addAll(this.webappDaoFactory.getIndividualDao().getExternalIds(this.getURI(), null));
            this.externalIds = dpsList;
        }
        catch (Exception e) {
            log.error((Object)("Could not fill external IDs for " + this.getURI()), (Throwable)e);
        }
        return this.externalIds;
    }

    @Override
    public List<VClass> getVClasses() {
        return this.getVClasses(false);
    }

    @Override
    public List<VClass> getVClasses(boolean assertedOnly) {
        if (assertedOnly) {
            if (this.directVClasses != null) {
                return this.directVClasses;
            }
            this.directVClasses = this.getMyVClasses(true);
            return this.directVClasses;
        }
        if (this.allVClasses != null) {
            return this.allVClasses;
        }
        this.allVClasses = this.getMyVClasses(false);
        return this.allVClasses;
    }

    private List<VClass> getMyVClasses(boolean assertedOnly) {
        Iterator typeIt;
        ArrayList<VClass> vClassList = new ArrayList<VClass>();
        Model tempModel = null;
        if (this.ind.getModel().contains((Resource)null, RDF.type, (RDFNode)null)) {
            tempModel = this.ind.getModel();
        } else {
            tempModel = ModelFactory.createDefaultModel();
            String getTypesQuery = this.buildMyVClassesQuery(assertedOnly);
            RDFService service = this.webappDaoFactory.getRDFService();
            try {
                service.sparqlConstructQuery(getTypesQuery, tempModel);
            }
            catch (RDFServiceException e) {
                throw new RuntimeException(e);
            }
        }
        StmtIterator stmtItr = tempModel.listStatements((Resource)null, RDF.type, (RDFNode)null);
        LinkedList<String> list = new LinkedList<String>();
        while (stmtItr.hasNext()) {
            Statement stmt = stmtItr.nextStatement();
            if (!stmt.getObject().isResource() || stmt.getObject().isAnon()) continue;
            list.add(((Resource)stmt.getObject()).getURI());
        }
        ListIterator itr = null;
        VClassDao checkSubClass = this.webappDaoFactory.getVClassDao();
        boolean directTypes = false;
        String currentType = null;
        ArrayList<String> done = new ArrayList<String>();
        if (assertedOnly) {
            while (!directTypes) {
                itr = list.listIterator();
                do {
                    if (!itr.hasNext()) {
                        directTypes = true;
                        break;
                    }
                    currentType = (String)itr.next();
                } while (done.contains(currentType));
                if (directTypes) break;
                itr = list.listIterator();
                while (itr.hasNext()) {
                    String nextType = (String)itr.next();
                    if (!checkSubClass.isSubClassOf(currentType, nextType) || currentType.equalsIgnoreCase(nextType)) continue;
                    itr.remove();
                }
                done.add(currentType);
            }
        }
        Iterator it = typeIt = list.iterator();
        while (it.hasNext()) {
            VClass vc;
            String typeURI;
            Resource type = ResourceFactory.createResource((String)it.next().toString());
            String string = typeURI = !type.isAnon() ? type.getURI() : "http://vitro.mannlib.cornell.edu/ns/bnode#" + type.getId().toString();
            if (type.getNameSpace() != null && this.webappDaoFactory.getNonuserNamespaces().contains(type.getNameSpace()) || (vc = this.webappDaoFactory.getVClassDao().getVClassByURI(type.getURI())) == null) continue;
            vClassList.add(vc);
        }
        try {
            Collections.sort(vClassList);
        }
        catch (Exception e) {
            log.error((Object)"Unable to sort VClass list", (Throwable)e);
        }
        return vClassList;
    }

    private String buildMyVClassesQuery(boolean assertedOnly) {
        WebappDaoFactorySDB.SDBDatasetMode queryMode = assertedOnly ? WebappDaoFactorySDB.SDBDatasetMode.ASSERTIONS_ONLY : this.datasetMode;
        String filterBlock = WebappDaoFactorySDB.getFilterBlock(new String[]{"?g"}, queryMode);
        if (filterBlock.isEmpty()) {
            return "CONSTRUCT { <" + this.individualURI + "> " + "<" + RDF.type + "> ?types }\n" + "WHERE { <" + this.individualURI + "> <" + RDF.type + "> ?types } \n";
        }
        String unionBlock = queryMode.equals((Object)WebappDaoFactorySDB.SDBDatasetMode.ASSERTIONS_ONLY) ? "" : "UNION { <" + this.individualURI + "> <" + RDF.type + "> ?types }";
        return "CONSTRUCT{ <" + this.individualURI + "> " + "<" + RDF.type + "> ?types }\n" + "WHERE{ { GRAPH ?g" + " { <" + this.individualURI + "> <" + RDF.type + "> ?types } \n" + filterBlock + "} \n" + unionBlock + "} \n";
    }

    @Override
    public boolean isVClass(String uri) {
        if (uri == null || this.getURI() == null) {
            return false;
        }
        String queryString = "ASK { <" + this.getURI() + "> a <" + uri + "> }";
        try {
            return this.webappDaoFactory.getRDFService().sparqlAskQuery(queryString);
        }
        catch (RDFServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void sortEnts2EntsForDisplay() {
        if (this.getObjectPropertyList() == null) {
            return;
        }
        for (ObjectProperty prop : this.getObjectPropertyList()) {
            ObjectProperty.sortObjectPropertyStatementsForDisplay(prop, prop.getObjectPropertyStatements());
        }
    }

    private void sortObjectPropertyStatementsForDisplay(ObjectProperty prop) {
        try {
            boolean tmpAsc;
            log.info((Object)("Doing special sort for " + prop.getDomainPublic()));
            final String sortPropertyURI = prop.getObjectIndividualSortPropertyURI();
            String tmpDir = prop.getDomainEntitySortDirection();
            final boolean dir = tmpAsc = !"desc".equalsIgnoreCase(tmpDir);
            Comparator comp = new Comparator(){
                final boolean cAsc;
                {
                    this.cAsc = dir;
                }

                public final int compare(Object o1, Object o2) {
                    DataProperty dp;
                    ObjectPropertyStatement e2e1 = (ObjectPropertyStatement)o1;
                    ObjectPropertyStatement e2e2 = (ObjectPropertyStatement)o2;
                    Individual e1 = e2e1 != null ? e2e1.getObject() : null;
                    Individual e2 = e2e2 != null ? e2e2.getObject() : null;
                    String val1 = null;
                    String val2 = null;
                    if (e1 != null) {
                        try {
                            dp = e1.getDataPropertyMap().get(sortPropertyURI);
                            if (dp.getDataPropertyStatements() != null && dp.getDataPropertyStatements().size() > 0) {
                                val1 = dp.getDataPropertyStatements().get(0).getData();
                            }
                        }
                        catch (Exception e) {
                            val1 = "";
                        }
                    } else {
                        log.warn((Object)"IndividualSDB.sortObjectPropertiesForDisplay passed object property statement with no range entity.");
                    }
                    if (e2 != null) {
                        try {
                            dp = e2.getDataPropertyMap().get(sortPropertyURI);
                            if (dp.getDataPropertyStatements() != null && dp.getDataPropertyStatements().size() > 0) {
                                val2 = dp.getDataPropertyStatements().get(0).getData();
                            }
                        }
                        catch (Exception e) {
                            val2 = "";
                        }
                    } else {
                        log.warn((Object)"IndividualSDB.sortObjectPropertyStatementsForDisplay() was passed an object property statement with no range entity.");
                    }
                    int rv = 0;
                    try {
                        if (val1 instanceof String) {
                            rv = IndividualSDB.this.collator.compare(val1, val2);
                        } else if (val1 instanceof Date) {
                            DateTime dt1 = new DateTime((Object)val1);
                            DateTime dt2 = new DateTime((Object)val2);
                            rv = dt1.compareTo((Object)dt2);
                        } else {
                            rv = 0;
                        }
                    }
                    catch (NullPointerException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                    if (this.cAsc) {
                        return rv;
                    }
                    return rv * -1;
                }
            };
            try {
                Collections.sort(this.getObjectPropertyStatements(), comp);
            }
            catch (Exception e) {
                log.error((Object)("Exception sorting object property statements for object property " + this.getURI()));
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void resolveAsFauxPropertyStatements(List<ObjectPropertyStatement> list) {
        this.webappDaoFactory.getObjectPropertyStatementDao().resolveAsFauxPropertyStatements(list);
    }

    public class IndividualNotFoundException
    extends Exception {
    }
}

