/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelReader;
import com.hp.hpl.jena.rdf.model.ModelSource;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;

public class VitroModelSource
implements ModelSource {
    private ModelSource innerSource;
    private ServletContext context;

    public VitroModelSource(ModelSource innerSource, ServletContext context) {
        this.innerSource = innerSource;
        this.context = context;
    }

    public Model getModel(String arg0) {
        ModelName pn = VitroModelSource.getModelName(arg0);
        if (pn != null) {
            return this.getNamedModel(pn);
        }
        return this.innerSource.getModel(arg0);
    }

    public Model getModel(String arg0, ModelReader arg1) {
        ModelName pn = VitroModelSource.getModelName(arg0);
        if (pn != null) {
            return this.getNamedModel(pn);
        }
        return this.innerSource.getModel(arg0, arg1);
    }

    public Model createDefaultModel() {
        return this.innerSource.createDefaultModel();
    }

    public Model createFreshModel() {
        return this.innerSource.createFreshModel();
    }

    public Model openModel(String arg0) {
        ModelName pn = VitroModelSource.getModelName(arg0);
        if (pn != null) {
            return this.getNamedModel(pn);
        }
        return this.innerSource.openModel(arg0);
    }

    public Model openModelIfPresent(String arg0) {
        ModelName pn = VitroModelSource.getModelName(arg0);
        if (pn != null) {
            return this.getNamedModel(pn);
        }
        return this.innerSource.openModelIfPresent(arg0);
    }

    private Model getNamedModel(ModelName pmn) {
        switch (pmn) {
            case ABOX: {
                return ModelAccess.on(this.context).getOntModel();
            }
            case TBOX: {
                return (Model)this.context.getAttribute("tboxmodel???");
            }
            case DISPLAY: {
                return ModelAccess.on(this.context).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata");
            }
            case DISPLAY_TBOX: {
                return ModelAccess.on(this.context).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadataTBOX");
            }
            case DISPLAY_DISPLAY: {
                return ModelAccess.on(this.context).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata-displayModel");
            }
            case USER_ACCOUNTS: {
                throw new IllegalArgumentException("getNamedModel() Does not yet handle USER_ACCOUNTS");
            }
        }
        throw new IllegalArgumentException("getNamedModel() should handle all values for enum PrivilegedModelName");
    }

    public static ModelName getModelName(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        try {
            return ModelName.valueOf(string.trim().toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static enum ModelName {
        ABOX,
        TBOX,
        DISPLAY,
        DISPLAY_TBOX,
        DISPLAY_DISPLAY,
        USER_ACCOUNTS;

    }
}

