/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectListGeneratorVTwo {
    static Log log = LogFactory.getLog(SelectListGeneratorVTwo.class);

    public static Map<String, String> getOptions(EditConfigurationVTwo editConfig, String fieldName, WebappDaoFactory wDaoFact) {
        if (editConfig == null) {
            log.error((Object)"fieldToSelectItemList() must be called with a non-null EditConfigurationVTwo ");
            return Collections.emptyMap();
        }
        if (fieldName == null) {
            log.error((Object)"fieldToSelectItemList() must be called with a non-null fieldName");
            return Collections.emptyMap();
        }
        FieldVTwo field = editConfig.getField(fieldName);
        if (field == null) {
            log.error((Object)("no field \"" + fieldName + "\" found from editConfig."));
            return Collections.emptyMap();
        }
        if (field.getFieldOptions() == null) {
            return Collections.emptyMap();
        }
        try {
            return field.getFieldOptions().getOptions(editConfig, fieldName, wDaoFact);
        }
        catch (Exception e) {
            log.error((Object)"Error runing getFieldOptionis()", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static Map<String, String> getSortedMap(Map<String, String> hmap, Comparator<String[]> comparator, VitroRequest vreq) {
        ArrayList<String[]> objectsToSort = new ArrayList<String[]>(hmap.size());
        for (String key : hmap.keySet()) {
            String[] x = new String[]{key, hmap.get(key)};
            objectsToSort.add(x);
        }
        if (comparator == null) {
            comparator = new MapPairsComparator(vreq);
        }
        Collections.sort(objectsToSort, comparator);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(objectsToSort.size());
        for (String[] pair : objectsToSort) {
            map.put(pair[0], pair[1]);
        }
        return map;
    }

    private static class MapPairsComparator
    implements Comparator<String[]> {
        private Collator collator;

        public MapPairsComparator(VitroRequest vreq) {
            this.collator = vreq.getCollator();
        }

        @Override
        public int compare(String[] s1, String[] s2) {
            if (s2 == null) {
                return 1;
            }
            if (s1 == null) {
                return -1;
            }
            if ("".equals(s1[0])) {
                return -1;
            }
            if ("".equals(s2[0])) {
                return 1;
            }
            if (s2[1] == null) {
                return 1;
            }
            if (s1[1] == null) {
                return -1;
            }
            return this.collator.compare(s1[1], s2[1]);
        }
    }
}

