/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils.ProcessDataGetterAbstract;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessFixedHTMLN3
extends ProcessDataGetterAbstract {
    private static String classType = "java:edu.cornell.mannlib.vitro.webapp.utils.dataGetter.FixedHTMLDataGetter";
    private Log log = LogFactory.getLog(ProcessFixedHTMLN3.class);

    @Override
    public List<String> retrieveN3Required(int counter) {
        String dataGetterVar = this.getDataGetterVar(counter);
        String classTypeVar = this.getN3VarName(classTypeVarBase, counter);
        String n3 = dataGetterVar + " a " + classTypeVar + "; \n" + "display:saveToVar " + this.getN3VarName("saveToVar", counter) + "; \n" + "display:htmlValue " + this.getN3VarName("htmlValue", counter) + " .";
        ArrayList<String> requiredList = new ArrayList<String>();
        requiredList.add(this.getPrefixes() + n3);
        return requiredList;
    }

    @Override
    public List<String> retrieveN3Optional(int counter) {
        return null;
    }

    @Override
    public List<String> retrieveLiteralsOnForm(int counter) {
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        literalsOnForm.add(this.getVarName("saveToVar", counter));
        literalsOnForm.add(this.getVarName("htmlValue", counter));
        return literalsOnForm;
    }

    @Override
    public List<String> retrieveUrisOnForm(int counter) {
        ArrayList<String> urisOnForm = new ArrayList<String>();
        urisOnForm.add(this.getVarName(classTypeVarBase, counter));
        return urisOnForm;
    }

    @Override
    public List<FieldVTwo> retrieveFields(int counter) {
        ArrayList<FieldVTwo> fields = new ArrayList<FieldVTwo>();
        fields.add(new FieldVTwo().setName(this.getVarName("saveToVar", counter)));
        fields.add(new FieldVTwo().setName(this.getVarName("htmlValue", counter)));
        fields.add(new FieldVTwo().setName(this.getVarName(classTypeVarBase, counter)));
        return fields;
    }

    @Override
    public List<String> getLiteralVarNamesBase() {
        return Arrays.asList("saveToVar", "htmlValue");
    }

    @Override
    public List<String> getUriVarNamesBase() {
        return Arrays.asList(classTypeVarBase);
    }

    @Override
    public void populateExistingValues(String dataGetterURI, int counter, OntModel queryModel) {
        this.populateExistingDataGetterURI(dataGetterURI, counter);
        this.populateExistingClassType(this.getClassType(), counter);
        String querystr = this.getExistingValuesSparqlQuery(dataGetterURI);
        QueryExecution qe = null;
        try {
            Query query = QueryFactory.create((String)querystr);
            qe = QueryExecutionFactory.create((Query)query, (Model)queryModel);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                Literal saveToVarLiteral = qs.getLiteral("saveToVar");
                Literal htmlValueLiteral = qs.getLiteral("htmlValue");
                this.existingLiteralValues.put(this.getVarName("saveToVar", counter), new ArrayList<Literal>(Arrays.asList(saveToVarLiteral)));
                this.existingLiteralValues.put(this.getVarName("htmlValue", counter), new ArrayList<Literal>(Arrays.asList(htmlValueLiteral)));
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception occurred in retrieving existing values with query " + querystr), (Throwable)ex);
        }
    }

    protected String getExistingValuesSparqlQuery(String dataGetterURI) {
        String query = this.getSparqlPrefix() + " SELECT ?saveToVar ?htmlValue WHERE {" + "<" + dataGetterURI + "> display:saveToVar ?saveToVar . \n" + "<" + dataGetterURI + "> display:htmlValue ?htmlValue . \n" + "}";
        return query;
    }

    @Override
    public JSONObject getExistingValuesJSON(String dataGetterURI, OntModel queryModel, ServletContext context) {
        JSONObject jObject = new JSONObject();
        jObject.element("dataGetterClass", (Object)classType);
        jObject.element(classTypeVarBase, (Object)classType);
        String querystr = this.getExistingValuesSparqlQuery(dataGetterURI);
        QueryExecution qe = null;
        try {
            Query query = QueryFactory.create((String)querystr);
            qe = QueryExecutionFactory.create((Query)query, (Model)queryModel);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                Literal saveToVarLiteral = qs.getLiteral("saveToVar");
                Literal htmlValueLiteral = qs.getLiteral("htmlValue");
                String htmlValueString = htmlValueLiteral.getString();
                htmlValueString = this.replaceQuotes(htmlValueString);
                jObject.element("saveToVar", (Object)saveToVarLiteral.getString());
                jObject.element("htmlValue", (Object)htmlValueString);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception occurred in retrieving existing values with query " + querystr), (Throwable)ex);
        }
        return jObject;
    }

    public String replaceQuotes(String inputStr) {
        return inputStr.replaceAll("'", "&#39;").replaceAll("\"", "&quot;");
    }

    @Override
    public String getClassType() {
        return classType;
    }
}

