/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filters;

import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import freemarker.cache.TemplateLoader;
import freemarker.cache.WebappTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class StartupStatusDisplayFilter
implements Filter {
    private static final String TEMPLATE_PATH = "/templates/freemarker/body/admin/startupStatus-displayRaw.ftl";
    private ServletContext ctx;
    private StartupStatus ss;
    private boolean statusAlreadyDisplayed;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.ctx = filterConfig.getServletContext();
        this.ss = StartupStatus.getBean(this.ctx);
        this.statusAlreadyDisplayed = false;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (this.ss.allClear() || !this.isFatal() && this.statusAlreadyDisplayed) {
            chain.doFilter(req, resp);
            return;
        }
        this.displayStartupStatus(req, resp);
        this.statusAlreadyDisplayed = true;
    }

    private void displayStartupStatus(ServletRequest req, ServletResponse resp) throws IOException, ServletException {
        HttpServletResponse hresp = (HttpServletResponse)resp;
        HttpServletRequest hreq = (HttpServletRequest)req;
        try {
            String query;
            HashMap<String, Object> bodyMap = new HashMap<String, Object>();
            bodyMap.put("status", this.ss);
            bodyMap.put("showLink", !this.isFatal());
            bodyMap.put("contextPath", this.getContextPath());
            bodyMap.put("applicationName", this.getApplicationName());
            String url = "";
            String path = hreq.getRequestURI();
            if (path != null) {
                url = path;
            }
            if (!StringUtils.isEmpty((String)(query = hreq.getQueryString()))) {
                url = url + "?" + query;
            }
            bodyMap.put("url", url);
            hresp.setContentType("text/html;charset=UTF-8");
            hresp.setStatus(500);
            Template tpl = this.loadFreemarkerTemplate();
            tpl.process(bodyMap, (Writer)hresp.getWriter());
        }
        catch (TemplateException e) {
            throw new ServletException("Problem with Freemarker Template", (Throwable)e);
        }
    }

    private String getContextPath() {
        String cp = this.ctx.getContextPath();
        if (cp == null || cp.isEmpty()) {
            return "The application";
        }
        return cp;
    }

    private Object getApplicationName() {
        String name = "";
        try {
            WebappDaoFactory wadf = ModelAccess.on(this.ctx).getWebappDaoFactory();
            ApplicationBean app = wadf.getApplicationDao().getApplicationBean();
            name = app.getApplicationName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return this.getContextPath();
    }

    private Template loadFreemarkerTemplate() throws IOException {
        Configuration cfg = new Configuration();
        cfg.setTemplateLoader((TemplateLoader)new WebappTemplateLoader(this.ctx));
        return cfg.getTemplate(TEMPLATE_PATH);
    }

    private boolean isFatal() {
        return !this.ss.getErrorItems().isEmpty();
    }
}

