/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex;

import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexingChangeListener
extends StatementListener
implements ModelChangedListener,
SearchIndexer.Listener {
    private static final Log log = LogFactory.getLog(IndexingChangeListener.class);
    private final SearchIndexer searchIndexer;
    private final Ticker ticker;
    private volatile boolean rebuildScheduled;
    private final Model defaultModel;
    private final List<Statement> changes;

    public IndexingChangeListener(SearchIndexer searchIndexer) {
        this.searchIndexer = searchIndexer;
        this.ticker = new Ticker();
        this.defaultModel = ModelFactory.createDefaultModel();
        this.changes = new ArrayList<Statement>();
        searchIndexer.addListener(this);
    }

    private synchronized void noteChange(Statement stmt) {
        this.changes.add(stmt);
        this.ticker.start();
    }

    @Override
    public void receiveSearchIndexerEvent(SearchIndexer.Event event) {
        if (event.getType() == SearchIndexer.Event.Type.REBUILD_REQUESTED) {
            this.rebuildScheduled = true;
        } else if (event.getType() == SearchIndexer.Event.Type.START_REBUILD) {
            this.rebuildScheduled = false;
            this.discardChanges();
        }
    }

    private synchronized void respondToTicker() {
        if (!this.changes.isEmpty()) {
            this.searchIndexer.scheduleUpdatesForStatements(this.changes);
            this.changes.clear();
        }
    }

    private synchronized void discardChanges() {
        this.changes.clear();
    }

    public void shutdown() {
        this.ticker.shutdown();
    }

    public void addedStatement(Statement stmt) {
        if (!this.rebuildScheduled) {
            this.noteChange(stmt);
        }
    }

    public void removedStatement(Statement stmt) {
        if (!this.rebuildScheduled) {
            this.noteChange(stmt);
        }
    }

    public void notifyEvent(Model model, Object event) {
        if (event instanceof EditEvent) {
            EditEvent editEvent = (EditEvent)event;
            if (!editEvent.getBegin().booleanValue()) {
                log.debug((Object)"Doing search index build at end of EditEvent");
                this.ticker.start();
            }
        } else {
            log.debug((Object)("ignoring event " + event.getClass().getName() + " " + event));
        }
    }

    private class Ticker {
        private final ScheduledExecutorService queue = Executors.newScheduledThreadPool(1, new VitroBackgroundThread.Factory("IndexingChangeListener_Ticker"));
        private volatile boolean running;
        private volatile boolean hasOneTick;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            IndexingChangeListener indexingChangeListener = IndexingChangeListener.this;
            synchronized (indexingChangeListener) {
                this.queue.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            IndexingChangeListener indexingChangeListener = IndexingChangeListener.this;
            synchronized (indexingChangeListener) {
                if (!this.running) {
                    this.startTicker();
                }
                this.hasOneTick = false;
            }
        }

        private void startTicker() {
            if (this.queue.isShutdown()) {
                log.warn((Object)"Attempt to start ticker after shutdown request.");
            } else {
                this.queue.schedule(new TickerResponse(), 1L, TimeUnit.SECONDS);
                this.running = true;
            }
        }

        private class TickerResponse
        implements Runnable {
            private TickerResponse() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IndexingChangeListener indexingChangeListener = IndexingChangeListener.this;
                synchronized (indexingChangeListener) {
                    Ticker.this.running = false;
                    if (Ticker.this.hasOneTick) {
                        IndexingChangeListener.this.respondToTicker();
                        Ticker.this.hasOneTick = false;
                    } else {
                        Ticker.this.startTicker();
                        Ticker.this.hasOneTick = true;
                    }
                }
            }
        }
    }
}

