/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.servlet.setup;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Model;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.RDFFilesLoader;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ConfigurationModelsSetup
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        StartupStatus ss = StartupStatus.getBean(ctx);
        try {
            this.setupModel(ctx, "http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata", "display");
            this.setupModel(ctx, "http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadataTBOX", "displayTbox");
            this.setupModel(ctx, "http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata-displayModel", "displayDisplay");
            this.setupModel(ctx, "http://vitro.mannlib.cornell.edu/default/vitro-kb-userAccounts", "auth");
            ss.info(this, "Set up the display models and the user accounts model.");
        }
        catch (Exception e) {
            ss.fatal(this, e.getMessage(), e.getCause());
        }
    }

    private void setupModel(ServletContext ctx, String modelUri, String modelPath) {
        try {
            OntModel ontModel = ModelAccess.on(ctx).getOntModel(modelUri);
            this.loadFirstTimeFiles(ctx, modelPath, ontModel);
            this.loadEveryTimeFiles(ctx, modelPath, ontModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create the '" + modelPath + "' model (" + modelUri + ").", e);
        }
    }

    private void loadFirstTimeFiles(ServletContext ctx, String modelPath, OntModel baseModel) {
        RDFFilesLoader.loadFirstTimeFiles(modelPath, (Model)baseModel, baseModel.isEmpty());
    }

    private void loadEveryTimeFiles(ServletContext ctx, String modelPath, OntModel memoryModel) {
        RDFFilesLoader.loadEveryTimeFiles(modelPath, memoryModel);
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

