/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.triplesource.impl.tdb;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.tdb.TDB;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceModelMaker;
import edu.cornell.mannlib.vitro.webapp.modelaccess.adapters.MemoryMappingModelMaker;
import edu.cornell.mannlib.vitro.webapp.modelaccess.adapters.ModelMakerWithPersistentEmptyModels;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.OntModelCache;
import edu.cornell.mannlib.vitro.webapp.modules.Application;
import edu.cornell.mannlib.vitro.webapp.modules.ComponentStartupStatus;
import edu.cornell.mannlib.vitro.webapp.modules.tripleSource.ContentTripleSource;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceFactorySingle;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.tdb.RDFServiceTDB;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.logging.LoggingRDFServiceFactory;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.JenaDataSourceSetupBase;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.io.IOException;

public class ContentTripleSourceTDB
extends ContentTripleSource {
    private String tdbPath;
    private volatile RDFService rdfService;
    private RDFServiceFactory rdfServiceFactory;
    private RDFService unclosableRdfService;
    private Dataset dataset;
    private ModelMaker modelMaker;

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasTdbDirectory")
    public void setTdbPath(String path) {
        if (this.tdbPath != null) {
            throw new IllegalStateException("Configuration includes multiple instances of TdbDirectory: " + this.tdbPath + ", and " + path);
        }
        this.tdbPath = path;
    }

    @Validation
    public void validate() throws Exception {
        if (this.tdbPath == null) {
            throw new IllegalStateException("Configuration did not include a TdbDirectory.");
        }
    }

    @Override
    public void startup(Application application, ComponentStartupStatus ss) {
        this.configureTDB();
        try {
            this.rdfService = new RDFServiceTDB(this.resolveTdbPath(application));
            this.rdfServiceFactory = this.createRDFServiceFactory();
            this.unclosableRdfService = this.rdfServiceFactory.getRDFService();
            this.dataset = new RDFServiceDataset(this.unclosableRdfService);
            this.modelMaker = this.createModelMaker();
            this.checkForFirstTimeStartup();
            ss.info("Initialized the RDF source for TDB");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to set up the RDF source for TDB", e);
        }
    }

    private String resolveTdbPath(Application application) {
        return application.getHomeDirectory().getPath().resolve(this.tdbPath).toString();
    }

    private void configureTDB() {
        TDB.getContext().setTrue(TDB.symUnionDefaultGraph);
    }

    private RDFServiceFactory createRDFServiceFactory() {
        return new LoggingRDFServiceFactory(new RDFServiceFactorySingle(this.rdfService));
    }

    private ModelMaker createModelMaker() {
        return ContentTripleSourceTDB.addContentDecorators(new ModelMakerWithPersistentEmptyModels(new MemoryMappingModelMaker(new RDFServiceModelMaker(this.unclosableRdfService), SMALL_CONTENT_MODELS)));
    }

    private void checkForFirstTimeStartup() {
        if (this.dataset.getNamedModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox").getGraph().isEmpty()) {
            JenaDataSourceSetupBase.thisIsFirstStartup();
        }
    }

    @Override
    public RDFServiceFactory getRDFServiceFactory() {
        return this.rdfServiceFactory;
    }

    @Override
    public RDFService getRDFService() {
        return this.unclosableRdfService;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public ModelMaker getModelMaker() {
        return this.modelMaker;
    }

    @Override
    public OntModelCache getShortTermOntModels(RDFService shortTermRdfService, OntModelCache longTermOntModelCache) {
        return longTermOntModelCache;
    }

    public String toString() {
        return "ContentTripleSourceTDB[" + ToString.hashHex(this) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(Application application) {
        ContentTripleSourceTDB contentTripleSourceTDB = this;
        synchronized (contentTripleSourceTDB) {
            if (this.rdfService != null) {
                this.rdfService.close();
                this.rdfService = null;
            }
        }
    }
}

