/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class SparqlQueryUtils {
    private static final char[] REGEX_SPECIAL_CHARACTERS = "[\\^$.|?*+()]".toCharArray();
    public static final List<Syntax> SUPPORTED_SYNTAXES = Arrays.asList(Syntax.syntaxARQ, Syntax.syntaxSPARQL_11);

    public static String escapeForRegex(String raw) {
        StringBuilder clean = new StringBuilder();
        block0: for (char c : raw.toCharArray()) {
            for (char special : REGEX_SPECIAL_CHARACTERS) {
                if (c != special) continue;
                clean.append('\\').append('\\').append(c);
                continue block0;
            }
            if (c == '\'') {
                clean.append('\\').append(c);
                continue;
            }
            clean.append(c);
        }
        return clean.toString();
    }

    public static Query create(String queryString) {
        boolean parseSuccess = false;
        Iterator<Syntax> syntaxIt = SUPPORTED_SYNTAXES.iterator();
        Query query = null;
        while (!parseSuccess && syntaxIt.hasNext()) {
            Syntax syntax = syntaxIt.next();
            try {
                query = QueryFactory.create((String)queryString, (Syntax)syntax);
                parseSuccess = true;
            }
            catch (QueryParseException e) {
                if (syntaxIt.hasNext()) continue;
                throw e;
            }
        }
        return query;
    }
}

