/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.datasource;

import com.hp.hpl.jena.rdf.model.Model;
import org.linkeddatafragments.datasource.AbstractRequestProcessor;
import org.linkeddatafragments.fragments.ILinkedDataFragment;
import org.linkeddatafragments.fragments.ILinkedDataFragmentRequest;
import org.linkeddatafragments.fragments.tpf.ITriplePatternElement;
import org.linkeddatafragments.fragments.tpf.ITriplePatternFragment;
import org.linkeddatafragments.fragments.tpf.ITriplePatternFragmentRequest;
import org.linkeddatafragments.fragments.tpf.TriplePatternFragmentImpl;

public abstract class AbstractRequestProcessorForTriplePatterns<CTT, NVT, AVT>
extends AbstractRequestProcessor {
    @Override
    protected final Worker<CTT, NVT, AVT> getWorker(ILinkedDataFragmentRequest request) throws IllegalArgumentException {
        if (request instanceof ITriplePatternFragmentRequest) {
            ITriplePatternFragmentRequest tpfRequest = (ITriplePatternFragmentRequest)request;
            return this.getTPFSpecificWorker(tpfRequest);
        }
        throw new IllegalArgumentException(request.getClass().getName());
    }

    protected abstract Worker<CTT, NVT, AVT> getTPFSpecificWorker(ITriplePatternFragmentRequest<CTT, NVT, AVT> var1) throws IllegalArgumentException;

    protected static abstract class Worker<CTT, NVT, AVT>
    extends AbstractRequestProcessor.Worker {
        public Worker(ITriplePatternFragmentRequest<CTT, NVT, AVT> request) {
            super(request);
        }

        @Override
        public ILinkedDataFragment createRequestedFragment() throws IllegalArgumentException {
            long limit = 100L;
            long offset = this.request.isPageRequest() ? 100L * (this.request.getPageNumber() - 1L) : 0L;
            ITriplePatternFragmentRequest tpfRequest = (ITriplePatternFragmentRequest)this.request;
            return this.createFragment(tpfRequest.getSubject(), tpfRequest.getPredicate(), tpfRequest.getObject(), offset, 100L);
        }

        protected abstract ILinkedDataFragment createFragment(ITriplePatternElement<CTT, NVT, AVT> var1, ITriplePatternElement<CTT, NVT, AVT> var2, ITriplePatternElement<CTT, NVT, AVT> var3, long var4, long var6) throws IllegalArgumentException;

        protected ITriplePatternFragment createEmptyTriplePatternFragment() {
            return new TriplePatternFragmentImpl(this.request.getFragmentURL(), this.request.getDatasetURL());
        }

        protected ITriplePatternFragment createTriplePatternFragment(Model triples, long totalSize, boolean isLastPage) {
            return new TriplePatternFragmentImpl(triples, totalSize, this.request.getFragmentURL(), this.request.getDatasetURL(), this.request.getPageNumber(), isLastPage);
        }
    }
}

