/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.datasource.index;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import java.util.HashMap;
import java.util.Map;
import org.linkeddatafragments.datasource.AbstractRequestProcessorForTriplePatterns;
import org.linkeddatafragments.datasource.IDataSource;
import org.linkeddatafragments.fragments.ILinkedDataFragment;
import org.linkeddatafragments.fragments.tpf.ITriplePatternElement;
import org.linkeddatafragments.fragments.tpf.ITriplePatternFragmentRequest;

public class IndexRequestProcessorForTPFs
extends AbstractRequestProcessorForTriplePatterns<RDFNode, String, String> {
    static final String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    static final String RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    static final String DC = "http://purl.org/dc/terms/";
    static final String VOID = "http://rdfs.org/ns/void#";
    private final Model model = ModelFactory.createDefaultModel();

    public IndexRequestProcessorForTPFs(String baseUrl, HashMap<String, IDataSource> datasources) {
        for (Map.Entry<String, IDataSource> entry : datasources.entrySet()) {
            String datasourceName = entry.getKey();
            IDataSource datasource = entry.getValue();
            ResourceImpl datasourceUrl = new ResourceImpl(baseUrl + "/" + datasourceName);
            this.model.add((Resource)datasourceUrl, (Property)new PropertyImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), "http://rdfs.org/ns/void#Dataset");
            this.model.add((Resource)datasourceUrl, (Property)new PropertyImpl("http://www.w3.org/2000/01/rdf-schema#label"), datasource.getTitle());
            this.model.add((Resource)datasourceUrl, (Property)new PropertyImpl("http://purl.org/dc/terms/title"), datasource.getTitle());
            this.model.add((Resource)datasourceUrl, (Property)new PropertyImpl("http://purl.org/dc/terms/description"), datasource.getDescription());
        }
    }

    protected Worker getTPFSpecificWorker(ITriplePatternFragmentRequest<RDFNode, String, String> request) throws IllegalArgumentException {
        return new Worker(request);
    }

    protected class Worker
    extends AbstractRequestProcessorForTriplePatterns.Worker<RDFNode, String, String> {
        public Worker(ITriplePatternFragmentRequest<RDFNode, String, String> req) {
            super(req);
        }

        @Override
        protected ILinkedDataFragment createFragment(ITriplePatternElement<RDFNode, String, String> s, ITriplePatternElement<RDFNode, String, String> p, ITriplePatternElement<RDFNode, String, String> o, long offset, long limit) {
            long index;
            Resource subject = s.isVariable() ? null : s.asConstantTerm().asResource();
            Property predicate = p.isVariable() ? null : ResourceFactory.createProperty((String)p.asConstantTerm().asResource().getURI());
            RDFNode object = o.isVariable() ? null : o.asConstantTerm();
            StmtIterator listStatements = IndexRequestProcessorForTPFs.this.model.listStatements(subject, predicate, object);
            Model result = ModelFactory.createDefaultModel();
            for (index = 0L; listStatements.hasNext() && index < offset; ++index) {
                listStatements.next();
            }
            while (listStatements.hasNext() && index < offset + limit) {
                result.add((Statement)listStatements.next());
            }
            boolean isLastPage = result.size() < offset + limit;
            return this.createTriplePatternFragment(result, result.size(), isLastPage);
        }
    }
}

