/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.fragments.tpf;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.NoSuchElementException;
import org.linkeddatafragments.fragments.LinkedDataFragmentBase;
import org.linkeddatafragments.fragments.tpf.ITriplePatternFragment;
import org.linkeddatafragments.util.CommonResources;

public abstract class TriplePatternFragmentBase
extends LinkedDataFragmentBase
implements ITriplePatternFragment {
    private final long totalSize;
    public static final StmtIterator emptyStmtIterator = new EmptyStmtIterator();

    public TriplePatternFragmentBase(String fragmentURL, String datasetURL) {
        this(0L, fragmentURL, datasetURL, 1L, true);
    }

    public TriplePatternFragmentBase(String fragmentURL, String datasetURL, long pageNumber, boolean isLastPage) {
        this(0L, fragmentURL, datasetURL, pageNumber, isLastPage);
    }

    public TriplePatternFragmentBase(long totalSize, String fragmentURL, String datasetURL, long pageNumber, boolean isLastPage) {
        super(fragmentURL, datasetURL, pageNumber, isLastPage);
        this.totalSize = totalSize < 0L ? 0L : totalSize;
    }

    @Override
    public StmtIterator getTriples() {
        if (this.totalSize == 0L) {
            return emptyStmtIterator;
        }
        return this.getNonEmptyStmtIterator();
    }

    protected abstract StmtIterator getNonEmptyStmtIterator();

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    @Override
    public void addMetadata(Model model) {
        super.addMetadata(model);
        Resource fragmentId = model.createResource(this.fragmentURL);
        Literal totalTyped = model.createTypedLiteral((Object)this.totalSize, (RDFDatatype)XSDDatatype.XSDinteger);
        Literal limitTyped = model.createTypedLiteral((Object)this.getMaxPageSize(), (RDFDatatype)XSDDatatype.XSDinteger);
        fragmentId.addLiteral(CommonResources.VOID_TRIPLES, totalTyped);
        fragmentId.addLiteral(CommonResources.HYDRA_TOTALITEMS, totalTyped);
        fragmentId.addLiteral(CommonResources.HYDRA_ITEMSPERPAGE, limitTyped);
    }

    @Override
    public void addControls(Model model) {
        super.addControls(model);
        Resource datasetId = model.createResource(this.getDatasetURI());
        Resource triplePattern = model.createResource();
        Resource subjectMapping = model.createResource();
        Resource predicateMapping = model.createResource();
        Resource objectMapping = model.createResource();
        datasetId.addProperty(CommonResources.HYDRA_SEARCH, (RDFNode)triplePattern);
        triplePattern.addProperty(CommonResources.HYDRA_TEMPLATE, this.getTemplate());
        triplePattern.addProperty(CommonResources.HYDRA_MAPPING, (RDFNode)subjectMapping);
        triplePattern.addProperty(CommonResources.HYDRA_MAPPING, (RDFNode)predicateMapping);
        triplePattern.addProperty(CommonResources.HYDRA_MAPPING, (RDFNode)objectMapping);
        subjectMapping.addProperty(CommonResources.HYDRA_VARIABLE, "subject");
        subjectMapping.addProperty(CommonResources.HYDRA_PROPERTY, (RDFNode)CommonResources.RDF_SUBJECT);
        predicateMapping.addProperty(CommonResources.HYDRA_VARIABLE, "predicate");
        predicateMapping.addProperty(CommonResources.HYDRA_PROPERTY, (RDFNode)CommonResources.RDF_PREDICATE);
        objectMapping.addProperty(CommonResources.HYDRA_VARIABLE, "object");
        objectMapping.addProperty(CommonResources.HYDRA_PROPERTY, (RDFNode)CommonResources.RDF_OBJECT);
    }

    public String getTemplate() {
        return this.datasetURL + "{?" + "subject" + "," + "predicate" + "," + "object" + "}";
    }

    public static class EmptyStmtIterator
    extends NiceIterator<Statement>
    implements StmtIterator {
        public Statement nextStatement() {
            throw new NoSuchElementException();
        }
    }
}

