/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.servlet;

import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.linkeddatafragments.config.ConfigReader;
import org.linkeddatafragments.datasource.DataSourceFactory;
import org.linkeddatafragments.datasource.DataSourceTypesRegistry;
import org.linkeddatafragments.datasource.IDataSource;
import org.linkeddatafragments.datasource.IDataSourceType;
import org.linkeddatafragments.datasource.index.IndexDataSource;
import org.linkeddatafragments.exceptions.DataSourceNotFoundException;
import org.linkeddatafragments.fragments.FragmentRequestParserBase;
import org.linkeddatafragments.fragments.ILinkedDataFragment;
import org.linkeddatafragments.fragments.ILinkedDataFragmentRequest;
import org.linkeddatafragments.util.MIMEParse;
import org.linkeddatafragments.views.ILinkedDataFragmentWriter;
import org.linkeddatafragments.views.LinkedDataFragmentWriterFactory;

public class LinkedDataFragmentServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String CFGFILE = "configFile";
    private ConfigReader config;
    private final HashMap<String, IDataSource> dataSources = new HashMap();
    private final Collection<String> mimeTypes = new ArrayList<String>();

    private File getConfigFile(ServletConfig config) throws IOException {
        String path = config.getServletContext().getRealPath("/");
        if (path == null) {
            path = System.getProperty("user.dir");
        }
        File cfg = new File(path, "config-example.json");
        if (config.getInitParameter(CFGFILE) != null) {
            cfg = new File(config.getInitParameter(CFGFILE));
        }
        if (!cfg.exists()) {
            throw new IOException("Configuration file " + cfg + " not found.");
        }
        if (!cfg.isFile()) {
            throw new IOException("Configuration file " + cfg + " is not a file.");
        }
        return cfg;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            File configFile = this.getConfigFile(servletConfig);
            this.config = new ConfigReader(new FileReader(configFile));
            for (Map.Entry<String, IDataSourceType> entry : this.config.getDataSourceTypes().entrySet()) {
                DataSourceTypesRegistry.register(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, IDataSourceType> entry : this.config.getDataSources().entrySet()) {
                this.dataSources.put(entry.getKey(), DataSourceFactory.create((JsonObject)entry.getValue()));
            }
            MIMEParse.register("text/html");
            MIMEParse.register("text/turtle");
            MIMEParse.register("application/n-triples");
            MIMEParse.register("application/rdf+xml");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        for (IDataSource dataSource : this.dataSources.values()) {
            try {
                dataSource.close();
            }
            catch (Exception exception) {}
        }
    }

    private IDataSource getDataSource(HttpServletRequest request) throws DataSourceNotFoundException {
        String path;
        String contextPath = request.getContextPath();
        String requestURI = request.getRequestURI();
        String string = path = contextPath == null ? requestURI : requestURI.substring(contextPath.length());
        if (path.equals("/") || path.isEmpty()) {
            String baseURL = FragmentRequestParserBase.extractBaseURL(request, this.config);
            return new IndexDataSource(baseURL, this.dataSources);
        }
        String dataSourceName = path.substring(1);
        IDataSource dataSource = this.dataSources.get(dataSourceName);
        if (dataSource == null) {
            throw new DataSourceNotFoundException(dataSourceName);
        }
        return dataSource;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Closeable fragment = null;
        try {
            String bestMatch = MIMEParse.bestMatch(request.getHeader("Accept"));
            response.setHeader("Server", "Linked Data Fragments Server");
            response.setContentType(bestMatch);
            response.setCharacterEncoding("utf-8");
            ILinkedDataFragmentWriter writer = LinkedDataFragmentWriterFactory.create(this.config.getPrefixes(), this.dataSources, bestMatch);
            try {
                IDataSource dataSource = this.getDataSource(request);
                ILinkedDataFragmentRequest ldfRequest = dataSource.getRequestParser().parseIntoFragmentRequest(request, this.config);
                fragment = dataSource.getRequestProcessor().createRequestedFragment(ldfRequest);
                writer.writeFragment(response.getOutputStream(), dataSource, (ILinkedDataFragment)fragment, ldfRequest);
            }
            catch (DataSourceNotFoundException ex) {
                try {
                    response.setStatus(404);
                    writer.writeNotFound(response.getOutputStream(), request);
                }
                catch (Exception ex1) {
                    throw new ServletException((Throwable)ex1);
                }
            }
            catch (Exception e) {
                response.setStatus(500);
                writer.writeError(response.getOutputStream(), e);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (fragment != null) {
                try {
                    fragment.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

