/*
 * Decompiled with CFR 0.152.
 */
package org.vivoweb.linkeddatafragments.views;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.StringWriterI;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.linkeddatafragments.datasource.IDataSource;
import org.linkeddatafragments.datasource.index.IndexDataSource;
import org.linkeddatafragments.fragments.tpf.ITriplePatternElement;
import org.linkeddatafragments.fragments.tpf.ITriplePatternFragment;
import org.linkeddatafragments.fragments.tpf.ITriplePatternFragmentRequest;
import org.linkeddatafragments.views.ILinkedDataFragmentWriter;
import org.linkeddatafragments.views.TriplePatternFragmentWriterBase;

public class HtmlTriplePatternFragmentWriterImpl
extends TriplePatternFragmentWriterBase
implements ILinkedDataFragmentWriter {
    private final Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
    private final Template indexTemplate;
    private final Template datasourceTemplate;
    private final Template notfoundTemplate;
    private final Template errorTemplate;
    private final String HYDRA = "http://www.w3.org/ns/hydra/core#";
    private static String contextPath;

    public static void setContextPath(String path) {
        contextPath = path;
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
    }

    public HtmlTriplePatternFragmentWriterImpl(Map<String, String> prefixes, HashMap<String, IDataSource> datasources) throws IOException {
        super(prefixes, datasources);
        this.cfg.setClassForTemplateLoading(this.getClass(), "/tpf");
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.indexTemplate = this.cfg.getTemplate("index.ftl.html");
        this.datasourceTemplate = this.cfg.getTemplate("datasource.ftl.html");
        this.notfoundTemplate = this.cfg.getTemplate("notfound.ftl.html");
        this.errorTemplate = this.cfg.getTemplate("error.ftl.html");
    }

    @Override
    public void writeFragment(ServletOutputStream outputStream, IDataSource datasource, ITriplePatternFragment fragment, ITriplePatternFragmentRequest tpfRequest) throws IOException, TemplateException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("homePath", (contextPath != null ? contextPath : "") + "tpf");
        data.put("assetsPath", (contextPath != null ? contextPath : "") + "tpf/assets/");
        data.put("header", datasource.getTitle());
        data.put("date", new Date());
        data.put("datasourceUrl", tpfRequest.getDatasetURL());
        data.put("datasource", datasource);
        StmtIterator controls = fragment.getControls();
        while (controls.hasNext()) {
            Statement control = (Statement)controls.next();
            String predicate = control.getPredicate().getURI();
            RDFNode object = control.getObject();
            if (object.isAnon()) continue;
            String value = object.isURIResource() ? object.asResource().getURI() : object.asLiteral().getLexicalForm();
            data.put(predicate.replaceFirst("http://www.w3.org/ns/hydra/core#", ""), value);
        }
        data.put("totalEstimate", fragment.getTotalSize());
        data.put("itemsPerPage", fragment.getMaxPageSize());
        List triples = fragment.getTriples().toList();
        data.put("triples", triples);
        data.put("datasources", this.getDatasources());
        Long start = (tpfRequest.getPageNumber() - 1L) * fragment.getMaxPageSize() + 1L;
        data.put("start", start);
        data.put("end", start - 1L + ((long)triples.size() < fragment.getMaxPageSize() ? (long)triples.size() : fragment.getMaxPageSize()));
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("subject", !tpfRequest.getSubject().isVariable() ? this.handleCT(tpfRequest.getSubject().asConstantTerm()) : "");
        query.put("predicate", !tpfRequest.getPredicate().isVariable() ? this.handleCT(tpfRequest.getPredicate().asConstantTerm()) : "");
        query.put("object", !tpfRequest.getObject().isVariable() ? this.handleCT(tpfRequest.getObject().asConstantTerm()) : "");
        query.put("pattern", this.makeQueryPattern(tpfRequest));
        data.put("query", query);
        Template temp = datasource instanceof IndexDataSource ? this.indexTemplate : this.datasourceTemplate;
        temp.process(data, (Writer)new OutputStreamWriter((OutputStream)outputStream));
    }

    private String makeQueryPattern(ITriplePatternFragmentRequest tpfRequest) {
        StringBuilder pattern = new StringBuilder();
        ITriplePatternElement subject = tpfRequest.getSubject();
        ITriplePatternElement predicate = tpfRequest.getPredicate();
        ITriplePatternElement object = tpfRequest.getObject();
        pattern.append("{");
        if (!subject.isVariable()) {
            this.appendNode(pattern.append(' '), (RDFNode)subject.asConstantTerm());
        } else {
            pattern.append(" ?s");
        }
        if (!predicate.isVariable()) {
            this.appendNode(pattern.append(' '), (RDFNode)predicate.asConstantTerm());
        } else {
            pattern.append(" ?p");
        }
        if (!object.isVariable()) {
            this.appendNode(pattern.append(' '), (RDFNode)object.asConstantTerm());
        } else {
            pattern.append(" ?o");
        }
        pattern.append(" }");
        return pattern.toString();
    }

    private void appendNode(StringBuilder builder, RDFNode node) {
        if (node.isLiteral()) {
            builder.append(this.literalToString(node.asLiteral()));
        } else if (node.isURIResource()) {
            builder.append('<' + node.asResource().getURI() + '>');
        }
    }

    private String literalToString(Literal l) {
        StringWriterI sw = new StringWriterI();
        NodeFormatterTTL fmt = new NodeFormatterTTL(null, null);
        fmt.formatLiteral((AWriter)sw, l.asNode());
        return sw.toString();
    }

    private Object handleCT(Object obj) {
        if (obj instanceof LiteralImpl) {
            return ((LiteralImpl)obj).asNode().toString();
        }
        return obj;
    }

    @Override
    public void writeNotFound(ServletOutputStream outputStream, HttpServletRequest request) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("homePath", (contextPath != null ? contextPath : "") + "tpf");
        data.put("assetsPath", (contextPath != null ? contextPath : "") + "tpf/assets/");
        data.put("datasources", this.getDatasources());
        data.put("date", new Date());
        data.put("url", request.getRequestURL().toString());
        this.notfoundTemplate.process(data, (Writer)new OutputStreamWriter((OutputStream)outputStream));
    }

    @Override
    public void writeError(ServletOutputStream outputStream, Exception ex) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("homePath", (contextPath != null ? contextPath : "") + "tpf");
        data.put("assetsPath", (contextPath != null ? contextPath : "") + "tpf/assets/");
        data.put("date", new Date());
        data.put("error", ex);
        this.errorTemplate.process(data, (Writer)new OutputStreamWriter((OutputStream)outputStream));
    }
}

