/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.semservices.service.impl;

import edu.cornell.mannlib.semservices.bo.Concept;
import edu.cornell.mannlib.semservices.exceptions.ConceptsNotFoundException;
import edu.cornell.mannlib.semservices.service.ExternalConceptService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GemetService
implements ExternalConceptService {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final String GemetWS_address = "https://www.eionet.europa.eu/gemet/";
    private final String narrowerUri = "http://www.w3.org/2004/02/skos/core%23narrower";
    private final String broaderUri = "http://www.w3.org/2004/02/skos/core%23broader";
    private final String relatedUri = "http://www.w3.org/2004/02/skos/core%23related";
    private final String definitionUri = "http://www.w3.org/2004/02/skos/core%23definition";
    private final String prefLabelUri = "http://www.w3.org/2004/02/skos/core%23prefLabel";
    private final String scopeNoteUri = "http://www.w3.org/2004/02/skos/core%23scopeNote";
    private final String altLabelUri = "http://www.w3.org/2004/02/skos/core%23altLabel";
    private final String exampleUri = "http://www.w3.org/2004/02/skos/core%23example";
    private final String acronymLabelUri = "http://www.w3.org/2004/02/skos/core%23acronymLabel";
    private final String endpoint = "http://cr.eionet.europa.eu/sparql";
    private final String schemeURI = "http://www.eionet.europa.eu/gemet/gemetThesaurus";

    public List<Concept> getConcepts(String term) throws Exception {
        ArrayList<Concept> conceptList = new ArrayList();
        try {
            String results = this.getConceptsMatchingKeyword(term);
            conceptList = this.processOutput(results);
        }
        catch (Exception ex) {
            return new ArrayList<Concept>();
        }
        return conceptList;
    }

    public List<Concept> processResults(String term) throws Exception {
        ArrayList<Concept> conceptList = new ArrayList();
        String results = this.getConceptsMatchingKeyword(term);
        conceptList = this.processOutput(results);
        return conceptList;
    }

    public List<Concept> getConceptsByURIWithSparql(String uri) throws Exception {
        ArrayList<Concept> conceptList = new ArrayList<Concept>();
        return conceptList;
    }

    private List<Concept> processOutput(String results) throws Exception {
        ArrayList<Concept> conceptList = new ArrayList<Concept>();
        try {
            JSONArray jsonArray = (JSONArray)JSONSerializer.toJSON((Object)results);
            if (jsonArray.size() == 0) {
                throw new ConceptsNotFoundException();
            }
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject definitionObj;
                JSONObject preferredLabelObj;
                Concept concept = new Concept();
                concept.setDefinedBy("http://www.eionet.europa.eu/gemet/gemetThesaurus");
                concept.setBestMatch("true");
                JSONObject json = jsonArray.getJSONObject(i);
                String uri = this.getJsonValue(json, "uri");
                concept.setUri(uri);
                concept.setConceptId(this.stripConceptId(uri));
                concept.setSchemeURI("http://www.eionet.europa.eu/gemet/gemetThesaurus");
                concept.setType("");
                if (json.has("preferredLabel") && (preferredLabelObj = json.getJSONObject("preferredLabel")).has("string")) {
                    concept.setLabel(this.getJsonValue(preferredLabelObj, "string"));
                }
                if (json.has("definition") && (definitionObj = json.getJSONObject("definition")).has("string")) {
                    concept.setDefinition(this.getJsonValue(definitionObj, "string"));
                }
                String narrower = this.getRelatedConcepts(uri, "narrower");
                List<String> narrowerURIList = this.getRelatedUris(narrower);
                concept.setNarrowerURIList(narrowerURIList);
                String broader = this.getRelatedConcepts(uri, "broader");
                List<String> broaderURIList = this.getRelatedUris(broader);
                concept.setBroaderURIList(broaderURIList);
                conceptList.add(concept);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Could not get concepts", (Throwable)ex);
            throw ex;
        }
        return conceptList;
    }

    protected String getJsonValue(JSONObject obj, String key) {
        if (obj.has(key)) {
            return obj.getString(key);
        }
        return new String("");
    }

    protected String getAvailableLangs(String concept_uri) throws Exception {
        String result = new String();
        String serviceUrl = "https://www.eionet.europa.eu/gemet/getAvailableLanguages?concept_uri=" + concept_uri;
        try {
            result = this.getGemetResults(serviceUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return result;
    }

    protected String getConcept(String concept_uri) throws Exception {
        String result = new String();
        String serviceUrl = "https://www.eionet.europa.eu/gemet/getConcept?concept_uri=" + concept_uri + "&language=en";
        try {
            result = this.getGemetResults(serviceUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return result;
    }

    protected String getAllTranslationsForConcept(String concept_uri, String property) throws Exception {
        String result = new String();
        String property_uri = new String();
        if (property.equals("definition")) {
            property_uri = "http://www.w3.org/2004/02/skos/core%23definition";
        } else if (property.equals("preferredLabel")) {
            property_uri = "http://www.w3.org/2004/02/skos/core%23prefLabel";
        } else if (property.equals("scopeNote")) {
            property_uri = "http://www.w3.org/2004/02/skos/core%23scopeNote";
        } else if (property.equals("nonPreferredLabels")) {
            property_uri = "http://www.w3.org/2004/02/skos/core%23altLabel";
        } else if (property.equals("example")) {
            property_uri = "http://www.w3.org/2004/02/skos/core%23example";
        } else if (property.equals("acronymLabel")) {
            property_uri = "http://www.w3.org/2004/02/skos/core%23acronymLabel";
        }
        String serviceUrl = "https://www.eionet.europa.eu/gemet/getAllTranslationsForConcept?concept_uri=" + concept_uri + "&property_uri=" + property_uri + "&language=en";
        try {
            result = this.getGemetResults(serviceUrl);
            List<String> list = this.getPropertyFromJson(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return result;
    }

    protected String getRelatedConcepts(String concept_uri, String relation) throws Exception {
        String result = new String();
        String relation_uri = new String();
        if (relation.equals("broader")) {
            relation_uri = "http://www.w3.org/2004/02/skos/core%23broader";
        } else if (relation.equals("narrower")) {
            relation_uri = "http://www.w3.org/2004/02/skos/core%23narrower";
        } else if (relation.equals("related")) {
            relation_uri = "http://www.w3.org/2004/02/skos/core%23related";
        }
        String serviceUrl = "https://www.eionet.europa.eu/gemet/getRelatedConcepts?concept_uri=" + concept_uri + "&relation_uri=" + relation_uri + "&language=en";
        try {
            result = this.getGemetResults(serviceUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return result;
    }

    protected String getConceptsMatchingKeyword(String keyword) throws Exception {
        String result = new String();
        String encodedKeyword = URLEncoder.encode(keyword, "UTF-8");
        String serviceUrl = "https://www.eionet.europa.eu/gemet/getConceptsMatchingKeyword?keyword=" + encodedKeyword + "&search_mode=0" + "&thesaurus_uri=http://www.eionet.europa.eu/gemet/concept/" + "&language=en";
        result = this.getGemetResults(serviceUrl);
        return result;
    }

    protected String getGemetResults(String url) throws Exception {
        String results = new String();
        try {
            String inputLine;
            StringWriter sw = new StringWriter();
            URL serviceUrl = new URL(url);
            BufferedReader in = new BufferedReader(new InputStreamReader(serviceUrl.openStream()));
            while ((inputLine = in.readLine()) != null) {
                sw.write(inputLine);
            }
            in.close();
            results = sw.toString();
        }
        catch (Exception ex) {
            this.logger.error((Object)"error occurred in servlet", (Throwable)ex);
            ex.printStackTrace();
            throw ex;
        }
        return results;
    }

    protected List<String> getRelatedUris(String json) {
        ArrayList<String> uriList = new ArrayList<String>();
        String uri = new String();
        JSONArray jsonArray = (JSONArray)JSONSerializer.toJSON((Object)json);
        if (jsonArray.size() == 0) {
            return new ArrayList<String>();
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObj = jsonArray.getJSONObject(i);
            uri = this.getJsonValue(jsonObj, "uri");
            uriList.add(uri);
        }
        return uriList;
    }

    protected List<String> getPropertyFromJson(String json) {
        ArrayList<String> props = new ArrayList<String>();
        JSONArray jsonArray = (JSONArray)JSONSerializer.toJSON((Object)json);
        if (jsonArray.size() == 0) {
            return new ArrayList<String>();
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObj = jsonArray.getJSONObject(i);
            System.out.println(jsonObj.toString());
        }
        return props;
    }

    protected String stripConceptId(String uri) {
        String conceptId = new String();
        int lastslash = uri.lastIndexOf(47);
        conceptId = uri.substring(lastslash + 1, uri.length());
        return conceptId;
    }
}

