/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.semservices.service.impl;

import edu.cornell.mannlib.semservices.bo.Concept;
import edu.cornell.mannlib.semservices.service.ExternalConceptService;
import edu.cornell.mannlib.semservices.util.SKOSUtils;
import edu.cornell.mannlib.semservices.util.XMLUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LCSHService
implements ExternalConceptService {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final String skosSuffix = ".skos.rdf";
    private final String hostUri = "http://id.loc.gov";
    private final String schemeUri = "http://id.loc.gov/authorities/subjects";
    private final String baseUri = "http://id.loc.gov/search/";

    public List<Concept> getConcepts(String term) throws Exception {
        List<Concept> conceptList = new ArrayList<Concept>();
        String results = null;
        String dataUrl = "http://id.loc.gov/search/?q=" + URLEncoder.encode(term, "UTF-8") + "&q=cs%3Ahttp%3A%2F%2Fid.loc.gov%2Fauthorities%2Fsubjects" + "&format=atom";
        this.log.debug((Object)("dataURL " + dataUrl));
        try {
            String inputLine;
            StringWriter sw = new StringWriter();
            URL rss = new URL(dataUrl);
            BufferedReader in = new BufferedReader(new InputStreamReader(rss.openStream()));
            while ((inputLine = in.readLine()) != null) {
                sw.write(inputLine);
            }
            in.close();
            results = sw.toString();
            this.log.debug((Object)results);
        }
        catch (Exception ex) {
            this.log.error((Object)"error occurred in servlet", (Throwable)ex);
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)results)) {
            return conceptList;
        }
        conceptList = this.processOutput(results);
        return conceptList;
    }

    private List<Concept> processOutput(String results) throws Exception {
        ArrayList<Concept> conceptList = new ArrayList<Concept>();
        List<String> uris = this.getConceptURIFromXML(results);
        String bestMatch = "true";
        int i = 0;
        for (String uri : uris) {
            if (i > 0) {
                bestMatch = "false";
            }
            this.log.debug((Object)("-" + uri + "-"));
            String conceptURLString = this.getSKOSURL(uri);
            String baseConceptURI = uri;
            URL conceptURL = null;
            try {
                conceptURL = new URL(conceptURLString);
            }
            catch (Exception e) {
                this.log.error((Object)("Error in trying to retrieve concept " + conceptURLString), (Throwable)e);
                return conceptList;
            }
            this.log.debug((Object)("loading concept uri " + conceptURLString));
            Concept c = this.createConcept(bestMatch, conceptURLString, baseConceptURI);
            if (c != null) {
                conceptList.add(c);
            }
            ++i;
        }
        return conceptList;
    }

    public Concept createConcept(String bestMatch, String conceptURLString, String skosConceptURI) {
        Concept concept = new Concept();
        this.log.debug((Object)("SKOSConceptURI is " + skosConceptURI));
        concept.setUri(skosConceptURI);
        concept.setConceptId(this.stripConceptId(skosConceptURI));
        concept.setBestMatch(bestMatch);
        concept.setDefinedBy("http://id.loc.gov/authorities/subjects");
        concept.setSchemeURI("http://id.loc.gov/authorities/subjects");
        concept.setType("");
        try {
            concept = SKOSUtils.createConceptUsingXMLFromURL((Concept)concept, (String)conceptURLString, null, (boolean)true);
        }
        catch (Exception ex) {
            this.log.debug((Object)("Error occurred for annotation retrieval for skos concept " + skosConceptURI), (Throwable)ex);
            return null;
        }
        return concept;
    }

    private String getSKOSURL(String uri) {
        String skosURI = uri + ".skos.rdf";
        return skosURI;
    }

    public List<String> getConceptURISFromJSON(String results) {
        ArrayList<String> uris = new ArrayList<String>();
        try {
            JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)results);
            this.log.debug((Object)json.toString());
        }
        catch (Exception ex) {
            this.log.error((Object)"Could not get concepts", (Throwable)ex);
            throw ex;
        }
        return uris;
    }

    protected List<String> getConceptURIFromXML(String rdf) {
        ArrayList<String> uris = new ArrayList<String>();
        String conceptUri = new String();
        try {
            Document doc = XMLUtils.parse((String)rdf);
            NodeList nodes = doc.getElementsByTagName("entry");
            int len = nodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = nodes.item(i);
                NodeList childNodes = node.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    NamedNodeMap attrs;
                    Attr hrefAttr;
                    Node childNode = childNodes.item(j);
                    if (!childNode.getNodeName().equals("link") || (hrefAttr = (Attr)(attrs = childNode.getAttributes()).getNamedItem("href")) == null || (Attr)attrs.getNamedItem("type") != null) continue;
                    conceptUri = hrefAttr.getTextContent();
                }
                this.log.debug((Object)("concept uri is " + conceptUri));
                uris.add(conceptUri);
            }
        }
        catch (IOException e) {
            this.log.error((Object)("error occurred in parsing " + rdf), (Throwable)e);
        }
        catch (SAXException e) {
            this.log.error((Object)("error occurred in parsing " + rdf), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            this.log.error((Object)("error occurred in parsing " + rdf), (Throwable)e);
        }
        return uris;
    }

    public List<Concept> processResults(String term) throws Exception {
        return this.getConcepts(term);
    }

    protected String stripConceptId(String uri) {
        String conceptId = new String();
        int lastslash = uri.lastIndexOf(47);
        conceptId = uri.substring(lastslash + 1, uri.length());
        return conceptId;
    }

    protected String extractConceptId(String str) {
        try {
            return str.substring(1, str.length() - 1);
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception occurred in extracting concept id for " + str), (Throwable)ex);
            return "";
        }
    }

    public List<Concept> getConceptsByURIWithSparql(String uri) throws Exception {
        return null;
    }
}

