/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.semservices.service.impl;

import edu.cornell.mannlib.semservices.bo.Concept;
import edu.cornell.mannlib.semservices.exceptions.ConceptsNotFoundException;
import edu.cornell.mannlib.semservices.service.ExternalConceptService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UMLSService
implements ExternalConceptService {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String submissionUrl = "http://link.informatics.stonybrook.edu/MeaningLookup/MlServiceServlet?";
    private static final String baseUri = "http://link.informatics.stonybrook.edu/umls/CUI/";
    private static final String endpoint = "http://link.informatics.stonybrook.edu/sparql/";
    private static final String schemeURI = "http://link.informatics.stonybrook.edu/umls";

    public List<Concept> getConcepts(String term) throws Exception {
        ArrayList<Concept> conceptList = new ArrayList();
        String results = null;
        String dataUrl = "http://link.informatics.stonybrook.edu/MeaningLookup/MlServiceServlet?textToProcess=" + URLEncoder.encode(term, "UTF-8") + "&format=json";
        try {
            String inputLine;
            StringWriter sw = new StringWriter();
            URL rss = new URL(dataUrl);
            BufferedReader in = new BufferedReader(new InputStreamReader(rss.openStream()));
            while ((inputLine = in.readLine()) != null) {
                sw.write(inputLine);
            }
            in.close();
            results = sw.toString();
            conceptList = this.processOutput(results);
            return conceptList;
        }
        catch (Exception ex) {
            this.logger.error((Object)"error occurred in servlet", (Throwable)ex);
            return null;
        }
    }

    public List<Concept> processResults(String term) throws Exception {
        String results = null;
        String dataUrl = "http://link.informatics.stonybrook.edu/MeaningLookup/MlServiceServlet?textToProcess=" + URLEncoder.encode(term, "UTF-8") + "&format=json";
        try {
            String inputLine;
            StringWriter sw = new StringWriter();
            URL rss = new URL(dataUrl);
            BufferedReader in = new BufferedReader(new InputStreamReader(rss.openStream()));
            while ((inputLine = in.readLine()) != null) {
                sw.write(inputLine);
            }
            in.close();
            results = sw.toString();
            List<Concept> conceptList = this.processOutput(results);
            return conceptList;
        }
        catch (Exception ex) {
            this.logger.error((Object)"error occurred in servlet", (Throwable)ex);
            return null;
        }
    }

    public List<Concept> getConceptsByURIWithSparql(String uri) throws Exception {
        ArrayList<Concept> conceptList = new ArrayList<Concept>();
        return conceptList;
    }

    private List<Concept> processOutput(String results) throws Exception {
        ArrayList<Concept> conceptList = new ArrayList<Concept>();
        ArrayList<String> bestMatchIdList = new ArrayList<String>();
        String bestMatchId = new String();
        boolean bestMatchFound = false;
        boolean allFound = false;
        try {
            String cui;
            Concept concept;
            JSONObject o;
            int i;
            int len;
            JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)results);
            if (json.has("Best Match")) {
                bestMatchFound = true;
                JSONArray bestMatchArray = json.getJSONArray("Best Match");
                len = bestMatchArray.size();
                if (len > 1) {
                    this.logger.debug((Object)("Found this many best matches: " + len));
                }
                for (i = 0; i < len; ++i) {
                    o = bestMatchArray.getJSONObject(i);
                    concept = new Concept();
                    concept.setDefinedBy(schemeURI);
                    concept.setBestMatch("true");
                    cui = this.getJsonValue(o, "CUI");
                    bestMatchIdList.add(cui);
                    concept.setConceptId(cui);
                    concept.setLabel(this.getJsonValue(o, "label"));
                    concept.setType(this.getJsonValue(o, "type"));
                    concept.setDefinition(this.getJsonValue(o, "definition"));
                    concept.setUri(baseUri + cui);
                    concept.setSchemeURI(schemeURI);
                    conceptList.add(concept);
                }
            }
            if (json.has("All")) {
                allFound = true;
                JSONArray allArray = json.getJSONArray("All");
                len = allArray.size();
                for (i = 0; i < len; ++i) {
                    o = allArray.getJSONObject(i);
                    concept = new Concept();
                    concept.setDefinedBy(schemeURI);
                    cui = this.getJsonValue(o, "CUI");
                    concept.setConceptId(cui);
                    concept.setLabel(this.getJsonValue(o, "label"));
                    concept.setType(this.getJsonValue(o, "type"));
                    concept.setDefinition(this.getJsonValue(o, "definition"));
                    concept.setUri(baseUri + cui);
                    concept.setSchemeURI(schemeURI);
                    if (bestMatchIdList.contains(cui)) continue;
                    concept.setBestMatch("false");
                    conceptList.add(concept);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error((Object)"Could not get concepts", (Throwable)ex);
            throw ex;
        }
        if (!bestMatchFound && !allFound) {
            throw new ConceptsNotFoundException();
        }
        return conceptList;
    }

    protected String getJsonValue(JSONObject obj, String key) {
        if (obj.has(key)) {
            return obj.getString(key);
        }
        return new String("");
    }

    protected String stripConceptId(String uri) {
        String conceptId = new String();
        int lastslash = uri.lastIndexOf(47);
        conceptId = uri.substring(lastslash + 1, uri.length());
        return conceptId;
    }
}

