/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.ajax;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.AbstractAjaxResponder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.json.JSONException;

public class GeoFocusMapLocations
extends AbstractAjaxResponder {
    private static final Log log = LogFactory.getLog((String)GeoFocusMapLocations.class.getName());
    private List<Map<String, String>> geoLocations;
    private static String GEO_FOCUS_QUERY = "PREFIX geo: <http://aims.fao.org/aos/geopolitical.owl#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>  \nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX core: <http://vivoweb.org/ontology/core#>  \nPREFIX foaf: <http://xmlns.com/foaf/0.1/>  \nPREFIX vivoc: <http://vivo.library.cornell.edu/ns/0.1#>  \nPREFIX afn:  <http://jena.apache.org/ARQ/function#> SELECT DISTINCT ?label ?location (afn:localname(?location) AS ?localName) (COUNT(DISTINCT ?person) AS ?count)  \nWHERE { { \n    ?location rdf:type core:GeographicRegion .  \n    ?location rdfs:label ?label .   \n    ?location core:geographicFocusOf ?person .  \n    ?person rdf:type foaf:Person . \n    FILTER (NOT EXISTS {?location a core:StateOrProvince}) \n} UNION {   \n    ?location rdf:type core:GeographicRegion .  \n    ?location <http://purl.obolibrary.org/obo/BFO_0000051> ?sublocation  . \n    ?location rdfs:label ?label .  \n    ?sublocation core:geographicFocusOf ?person .  \n    ?person rdf:type foaf:Person  \n} UNION {   \n    ?location rdf:type core:GeographicRegion .  \n    ?location geo:hasMember ?sublocation  . \n    ?location rdfs:label ?label .  \n    ?sublocation core:geographicFocusOf ?person .  \n    ?person rdf:type foaf:Person   \n} }  \nGROUP BY ?label ?location  \n";

    public GeoFocusMapLocations(HttpServlet parent, VitroRequest vreq, HttpServletResponse resp) {
        super(parent, vreq, resp);
    }

    public String prepareResponse() throws IOException, JSONException {
        try {
            this.geoLocations = this.getGeoLocations(this.vreq);
            String response = "[";
            String geometry = "{\"geometry\": {\"type\": \"Point\",\"coordinates\": \"\"},";
            String typeProps = "\"type\": \"Feature\",\"properties\": {\"mapType\": \"\",";
            String previousLabel = "";
            for (Map<String, String> map : this.geoLocations) {
                String label = map.get("label");
                String html = map.get("count");
                String uri = map.get("location");
                String local = map.get("localName");
                if (uri != null) {
                    uri = UrlBuilder.urlEncode((String)uri);
                }
                Integer count = Integer.parseInt(map.get("count"));
                String radius = String.valueOf(this.calculateRadius(count));
                String name = "";
                if (label == null || label.equals(previousLabel)) continue;
                name = label.contains("Ivoire") ? "Ivory Coast" : (label.contains("United States of America") ? "United States of America" : (label.contains("United Kingdom") ? "United Kingdom" : label));
                String tempStr = geometry;
                tempStr = tempStr + typeProps + "\"popupContent\": \"" + name + "\",\"html\":" + html + ",\"radius\":" + radius + ",\"uri\": \"" + uri + "\",\"local\": \"" + local + "\"}},";
                response = response + tempStr;
                previousLabel = label;
            }
            if (response.lastIndexOf(",") > 0) {
                response = response.substring(0, response.lastIndexOf(","));
            }
            response = response + " ]";
            if (log.isDebugEnabled()) {
                log.debug((Object)response);
            }
            return response;
        }
        catch (Exception e) {
            log.error((Object)"Failed geographic focus locations", (Throwable)e);
            return "[]";
        }
    }

    private List<Map<String, String>> getGeoLocations(VitroRequest vreq) {
        String queryStr = GEO_FOCUS_QUERY;
        log.debug((Object)("queryStr = " + queryStr));
        ArrayList<Map<String, String>> locations = new ArrayList<Map<String, String>>();
        try {
            ResultSet results = QueryUtils.getQueryResults((String)queryStr, (VitroRequest)vreq);
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                locations.add(QueryUtils.querySolutionToStringValueMap((QuerySolution)soln));
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return locations;
    }

    private Integer calculateRadius(Integer count) {
        int radius = 8;
        if (count != null) {
            radius = count < 4 ? 8 : (count < 7 ? 10 : (count < 10 ? 12 : (count < 16 ? 14 : (count < 21 ? 16 : (count < 26 ? 18 : 20)))));
        }
        return radius;
    }
}

