/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;

public class ManagePeopleForOrganizationController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog((String)ManagePeopleForOrganizationController.class.getName());
    private static final String TEMPLATE_NAME = "managePeopleForOrganization.ftl";
    private static String PEOPLE_QUERY = "PREFIX core: <http://vivoweb.org/ontology/core#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nPREFIX afn: <http://jena.apache.org/ARQ/function#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nSELECT DISTINCT ?subclass ?position ?positionLabel (str(?label) as ?name) ?person ?hideThis WHERE { \n    ?subject core:relatedBy ?position . \n    ?position a core:Position . \n    ?position rdfs:label ?positionLabel . \n    OPTIONAL { \n        ?subject core:relatedBy ?position . \n        ?position a core:Position . \n        ?position core:relates  ?person .         ?person a foaf:Person . \n        ?person rdfs:label ?label } \n    OPTIONAL { \n        ?subject core:relatedBy ?position . \n        ?position a core:Position . \n        ?position vitro:mostSpecificType ?subclass . \n        OPTIONAL { ?subclass vitro:displayRankAnnot ?displayRank } \n    } \n     OPTIONAL { ?position core:hideFromDisplay ?hideThis } \n     FILTER ( !BOUND(?displayRank) || ?displayRank < 500 )} ORDER BY ?subclass ?name";

    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.DO_FRONT_END_EDITING.ACTION;
    }

    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        String subjectUri = vreq.getParameter("subjectUri");
        body.put("subjectUri", subjectUri);
        HashMap<String, List<Map<String, String>>> people = this.getPeople(subjectUri, vreq);
        if (log.isDebugEnabled()) {
            log.debug((Object)("people = " + people));
        }
        body.put("people", people);
        List<String> allSubclasses = this.getAllSubclasses(people);
        body.put("allSubclasses", allSubclasses);
        Individual subject = vreq.getWebappDaoFactory().getIndividualDao().getIndividualByURI(subjectUri);
        if (subject != null && subject.getName() != null) {
            body.put("subjectName", subject.getName());
        } else {
            body.put("subjectName", null);
        }
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    HashMap<String, List<Map<String, String>>> getPeople(String subjectUri, VitroRequest vreq) {
        VClassDao vcDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getVClassDao();
        String queryStr = QueryUtils.subUriForQueryVar((String)PEOPLE_QUERY, (String)"subject", (String)subjectUri);
        log.debug((Object)("queryStr = " + queryStr));
        HashMap<String, List<Map<String, String>>> subclassToPeople = new HashMap<String, List<Map<String, String>>>();
        try {
            ResultSet results = QueryUtils.getQueryResults((String)queryStr, (VitroRequest)vreq);
            while (results.hasNext()) {
                String subclass;
                QuerySolution soln = results.nextSolution();
                RDFNode subclassUri = soln.get("subclass");
                if (subclassUri == null) continue;
                String subclassUriStr = soln.get("subclass").toString();
                VClass vClass = vcDao.getVClassByURI(subclassUriStr);
                String string = subclass = vClass.getName() == null ? subclassUriStr : vClass.getName();
                if (!subclassToPeople.containsKey(subclass)) {
                    subclassToPeople.put(subclass, new ArrayList());
                }
                List<Map<String, String>> peopleList = subclassToPeople.get(subclass);
                peopleList.add(QueryUtils.querySolutionToStringValueMap((QuerySolution)soln));
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return subclassToPeople;
    }

    private List<String> getAllSubclasses(HashMap<String, List<Map<String, String>>> people) {
        ArrayList<String> allSubclasses = new ArrayList<String>(people.keySet());
        Collections.sort(allSubclasses);
        return allSubclasses;
    }
}

