/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.harvester;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.harvester.FileHarvestController;
import edu.cornell.mannlib.vitro.webapp.controller.harvester.FileHarvestJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CsvFileHarvestJob
implements FileHarvestJob {
    private static final Log log = LogFactory.getLog(CsvFileHarvestJob.class);
    private VitroRequest vreq;
    private File templateFile;
    private File scriptFile;
    private final String namespace;
    private final String friendlyName;
    private final String linkHeader;
    private final String noNewDataMessage;
    private final String[] rdfTypesForLinks;
    private final String sessionId;

    public static CsvFileHarvestJob createJob(JobType jobType, VitroRequest vreq, String namespace) {
        return jobType.constructCsvFileHarvestJob(vreq, namespace);
    }

    private CsvFileHarvestJob(VitroRequest vreq, String templateFileName, String scriptFileName, String xsltFileName, String namespace, String friendlyName, String linkHeader, String noNewDataMessage, String[] rdfTypesForLinks) {
        this.vreq = vreq;
        this.templateFile = new File(this.getTemplateFileDirectory() + templateFileName);
        this.scriptFile = new File(this.getScriptFileDirectory() + scriptFileName);
        this.namespace = namespace;
        this.friendlyName = friendlyName;
        this.linkHeader = linkHeader;
        this.noNewDataMessage = noNewDataMessage;
        this.rdfTypesForLinks = Arrays.copyOf(rdfTypesForLinks, rdfTypesForLinks.length);
        this.sessionId = this.vreq.getSession().getId();
    }

    private String getTemplateFileDirectory() {
        String harvesterPath = FileHarvestController.getHarvesterPath((HttpServletRequest)this.vreq);
        String pathToTemplateFiles = harvesterPath + "vivo/templates/";
        return pathToTemplateFiles;
    }

    private String getScriptFileDirectory() {
        String harvesterPath = FileHarvestController.getHarvesterPath((HttpServletRequest)this.vreq);
        String pathToScriptFiles = harvesterPath + "vivo/scripts/";
        return pathToScriptFiles;
    }

    private boolean[] getLinesEndingInComma(File file) throws IOException {
        ArrayList<Boolean> linesEndingInCommaList = new ArrayList<Boolean>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null) {
            boolean lineEndsInComma = line.endsWith(",");
            linesEndingInCommaList.add(lineEndsInComma);
            line = reader.readLine();
        }
        reader.close();
        boolean[] linesEndingInComma = new boolean[linesEndingInCommaList.size()];
        for (int i = 0; i < linesEndingInComma.length; ++i) {
            linesEndingInComma[i] = (Boolean)linesEndingInCommaList.get(i);
        }
        return linesEndingInComma;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String validateUpload(File file) {
        try {
            String message = "No data in file";
            try (CSVParser cReader = new CSVParser((Reader)new FileReader(file), CSVFormat.DEFAULT);){
                int rowNum = 0;
                int numberFields = 0;
                String errorMsg = "File header does not match template";
                for (CSVRecord cRecord : cReader) {
                    ++rowNum;
                    if (cRecord.size() > 0 && cRecord.size() != numberFields) {
                        if (errorMsg == null) {
                            String string = "Mismatch in number of entries in row " + rowNum + ": expected " + numberFields + ", found " + cRecord.size();
                            return string;
                        }
                        errorMsg = errorMsg + "template items: ";
                        int i = 0;
                        while (true) {
                            if (i >= cRecord.size()) {
                                String string = errorMsg;
                                return string;
                            }
                            errorMsg = errorMsg + cRecord.get(i) + ", ";
                            ++i;
                        }
                    }
                    message = null;
                    errorMsg = null;
                }
                String string = message;
                return string;
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            return e.getMessage();
        }
    }

    @Override
    public String getScript() {
        File scriptTemplate = this.scriptFile;
        String scriptTemplateContents = this.readFromFile(scriptTemplate);
        String replacements = this.performScriptTemplateReplacements(scriptTemplateContents);
        return replacements;
    }

    private String performScriptTemplateReplacements(String scriptTemplateContents) {
        String replacements = scriptTemplateContents;
        String workingDirectory = FileHarvestController.getHarvesterPath((HttpServletRequest)this.vreq);
        String fileDirectory = FileHarvestController.getUploadPath(this.vreq);
        String harvestedDataPath = this.getHarvestedDataPath();
        String globalHarvestedDataRelativePath = "vivo/harvested-data/";
        if (harvestedDataPath.endsWith("/")) {
            harvestedDataPath = harvestedDataPath.substring(0, harvestedDataPath.length() - 1);
        }
        replacements = replacements.replace("${WORKING_DIRECTORY}", workingDirectory);
        replacements = replacements.replace("${UPLOADS_FOLDER}", fileDirectory);
        replacements = replacements.replace("${HARVESTED_DATA_PATH}", harvestedDataPath);
        replacements = replacements.replace("${GLOBAL_HARVESTED_DATA_RELATIVE_PATH}", globalHarvestedDataRelativePath);
        return replacements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFromFile(File file) {
        String contents = null;
        BufferedReader reader = null;
        try {
            int fileSize = (int)file.length();
            char[] buffer = new char[fileSize];
            reader = new BufferedReader(new FileReader(file), fileSize);
            reader.read(buffer);
            contents = new String(buffer);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return contents;
    }

    private String getHarvestedDataPath() {
        return FileHarvestController.getHarvesterPath((HttpServletRequest)this.vreq) + "vivo/harvested-data/" + "csv/" + this.sessionId + "/";
    }

    @Override
    public String getAdditionsFilePath() {
        return this.getHarvestedDataPath() + "additions.rdf.xml";
    }

    @Override
    public String getPageHeader() {
        return "Harvest " + this.friendlyName + " data from CSV file(s)";
    }

    @Override
    public String getLinkHeader() {
        return this.linkHeader;
    }

    @Override
    public String getTemplateFilePath() {
        return this.templateFile.getPath();
    }

    @Override
    public String[] getRdfTypesForLinks() {
        return Arrays.copyOf(this.rdfTypesForLinks, this.rdfTypesForLinks.length);
    }

    @Override
    public String getTemplateDownloadHelp() {
        return "Click here to download a template file to assist you with harvesting the data.";
    }

    @Override
    public String getTemplateFillInHelp() {
        String newline = "\n";
        String help = "";
        help = help + "<p>A CSV, or <strong>C</strong>omma-<strong>S</strong>eparated <strong>V</strong>alues file, is a method of storing tabular data in plain text.  The first line of a CSV file contains header information, while each subsequent line contains a data record.</p>" + newline;
        help = help + "<p>The template we provide contains only the header, which you will then fill in accordingly.  For example, if the template contains the text \"firstName,lastName\", then you might add two more lines, \"John,Doe\" and \"Jane,Public\".</p>" + newline;
        help = help + "<p>People in the harvest are grouped by the \"PersonID\" field and matched with existing data using the \"Email\" and/or \"FullName\" fields.</p>" + newline;
        help = help + "<p>In the grant harvest grants, people, and departments are grouped by \"GrantID\",\"PIID\" and \"CoPIID\", \"AdminDepartmentID\" fields respectively and matched with existing data using the name fields.</p>" + newline;
        return help;
    }

    @Override
    public String getNoNewDataMessage() {
        return this.noNewDataMessage;
    }

    public static enum JobType {
        GRANT("csvGrant", "granttemplate.csv", "CSVtoRDFgrant.sh", "csv-grant-to-vivo.xsl", "Grant", "Imported Grants", "No new grants were imported.", new String[]{"http://vivoweb.org/ontology/core#Grant"}),
        PERSON("csvPerson", "persontemplate.csv", "CSVtoRDFperson.sh", "csv-people-to-vivo.xsl", "Person", "Imported Persons", "No new persons were imported.", new String[]{"http://xmlns.com/foaf/0.1/Person"});

        public final String httpParameterName;
        private final String templateFileName;
        private final String scriptFileName;
        private final String xsltFileName;
        private final String friendlyName;
        private final String linkHeader;
        private final String noNewDataMessage;
        private final String[] rdfTypesForLinks;

        public static boolean containsTypeWithHttpParameterName(String httpParameterName) {
            return JobType.getByHttpParameterName(httpParameterName) != null;
        }

        public static JobType getByHttpParameterName(String httpParameterName) {
            JobType returnValue = null;
            if (httpParameterName != null) {
                JobType[] values;
                for (JobType jobType : values = JobType.values()) {
                    if (!jobType.httpParameterName.equalsIgnoreCase(httpParameterName)) continue;
                    returnValue = jobType;
                    break;
                }
            }
            return returnValue;
        }

        private JobType(String httpParameterName, String templateFileName, String scriptFileName, String xsltFileName, String friendlyName, String linkHeader, String noNewDataMessage, String[] rdfTypesForLinks) {
            this.httpParameterName = httpParameterName;
            this.templateFileName = templateFileName;
            this.scriptFileName = scriptFileName;
            this.xsltFileName = xsltFileName;
            this.friendlyName = friendlyName;
            this.linkHeader = linkHeader;
            this.noNewDataMessage = noNewDataMessage;
            this.rdfTypesForLinks = Arrays.copyOf(rdfTypesForLinks, rdfTypesForLinks.length);
        }

        private CsvFileHarvestJob constructCsvFileHarvestJob(VitroRequest vreq, String namespace) {
            return new CsvFileHarvestJob(vreq, this.templateFileName, this.scriptFileName, this.xsltFileName, namespace, this.friendlyName, this.linkHeader, this.noNewDataMessage, this.rdfTypesForLinks);
        }
    }
}

