/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.visualization;

import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.TemplateProcessingHelper;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.visualization.VisualizationsDependencyInjector;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.VisualizationRequestHandler;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Syntax;

public class AjaxVisualizationController
extends FreemarkerHttpServlet {
    public static final String URL_ENCODING_SCHEME = "UTF-8";
    private static final Log log = LogFactory.getLog((String)AjaxVisualizationController.class.getName());
    protected static final Syntax SYNTAX = Syntax.syntaxARQ;
    public static ServletContext servletContext;

    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        AuthorizationRequest requiredPrivileges;
        VisualizationRequestHandler visRequestHandler = this.getVisualizationRequestHandler(vreq);
        if (visRequestHandler != null && (requiredPrivileges = visRequestHandler.getRequiredPrivileges()) != null) {
            return requiredPrivileges;
        }
        return super.requiredActions(vreq);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VitroRequest vreq = new VitroRequest(request);
        Object ajaxResponse = this.processAjaxRequest(vreq);
        if (ajaxResponse instanceof TemplateResponseValues) {
            TemplateResponseValues trv = (TemplateResponseValues)ajaxResponse;
            try {
                this.writeTemplate(trv.getTemplateName(), trv.getMap(), (HttpServletRequest)vreq, response);
            }
            catch (TemplateProcessingHelper.TemplateProcessingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            response.getWriter().write(ajaxResponse.toString());
        }
    }

    private Object processAjaxRequest(VitroRequest vreq) {
        VisualizationRequestHandler visRequestHandler = this.getVisualizationRequestHandler(vreq);
        if (visRequestHandler != null) {
            return this.renderVisualization(vreq, visRequestHandler);
        }
        return UtilityFunctions.handleMalformedParameters("Visualization Query Error", "Inappropriate query parameters were submitted.", vreq);
    }

    private Object renderVisualization(VitroRequest vitroRequest, VisualizationRequestHandler visRequestHandler) {
        OntModel model = vitroRequest.getJenaOntModel();
        if (model == null) {
            String errorMessage = "This service is not supporeted by the current webapp configuration. A jena model is required in the servlet context.";
            log.error((Object)errorMessage);
            return UtilityFunctions.handleMalformedParameters("Visualization Query Error", errorMessage, vitroRequest);
        }
        Dataset dataset = this.setupJENADataSource(vitroRequest);
        if (dataset != null && visRequestHandler != null) {
            try {
                return visRequestHandler.generateAjaxVisualization(vitroRequest, log, dataset);
            }
            catch (MalformedQueryParametersException e) {
                return UtilityFunctions.handleMalformedParameters("Ajax Visualization Query Error - Individual Publication Count", e.getMessage(), vitroRequest);
            }
        }
        String errorMessage = "Data Model Empty &/or Inappropriate query parameters were submitted. ";
        log.error((Object)errorMessage);
        return UtilityFunctions.handleMalformedParameters("Visualization Query Error", errorMessage, vitroRequest);
    }

    private VisualizationRequestHandler getVisualizationRequestHandler(VitroRequest vitroRequest) {
        String visType = vitroRequest.getParameter("vis");
        VisualizationRequestHandler visRequestHandler = null;
        try {
            visRequestHandler = VisualizationsDependencyInjector.getVisualizationIDsToClassMap(this.getServletContext()).get(visType);
        }
        catch (NullPointerException nullKeyException) {
            return null;
        }
        return visRequestHandler;
    }

    private Dataset setupJENADataSource(VitroRequest vreq) {
        return vreq.getDataset();
    }
}

