/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.vocabulary.XSD;

public class AddUserDefinedConceptGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    private Log log = LogFactory.getLog(AddUserDefinedConceptGenerator.class);
    private boolean isObjectPropForm = false;
    private String subjectUri = null;
    private String predicateUri = null;
    private String objectUri = null;
    private String datapropKeyStr = null;
    private int dataHash = 0;
    private DataPropertyStatement dps = null;
    private String dataLiteral = null;
    private String template = "addUserDefinedConcept.ftl";
    private static HashMap<String, String> defaultsForXSDtypes;
    private static String SKOSConceptType;

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
        this.initBasics(editConfiguration, vreq);
        this.initPropertyParameters(vreq, session, editConfiguration);
        this.initObjectPropForm(editConfiguration, vreq);
        editConfiguration.setTemplate(this.template);
        this.setVarNames(editConfiguration);
        editConfiguration.setN3Required(this.generateN3Required(vreq));
        editConfiguration.setN3Optional(this.generateN3Optional());
        editConfiguration.setNewResources(this.generateNewResources(vreq));
        this.setUrisAndLiteralsInScope(editConfiguration, vreq);
        this.setUrisAndLiteralsOnForm(editConfiguration, vreq);
        editConfiguration.setFilesOnForm(new ArrayList());
        this.setSparqlQueries(editConfiguration, vreq);
        this.setFields(editConfiguration, vreq, EditConfigurationUtils.getPredicateUri((VitroRequest)vreq));
        this.setTemplate(editConfiguration, vreq);
        editConfiguration.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        this.addPreprocessors(editConfiguration, vreq.getWebappDaoFactory());
        this.addFormSpecificData(editConfiguration, vreq);
        editConfiguration.setUrlPatternToReturnTo(this.getUrlPatternToReturnTo(vreq));
        this.prepare(vreq, editConfiguration);
        return editConfiguration;
    }

    private String getUrlPatternToReturnTo(VitroRequest vreq) {
        String subjectUri = EditConfigurationUtils.getSubjectUri((VitroRequest)vreq);
        String predicateUri = EditConfigurationUtils.getPredicateUri((VitroRequest)vreq);
        String generatorName = "edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.AddAssociatedConceptGenerator";
        String editUrl = EditConfigurationUtils.getEditUrlWithoutContext((VitroRequest)vreq);
        return editUrl + "?subjectUri=" + UrlBuilder.urlEncode((String)subjectUri) + "&predicateUri=" + UrlBuilder.urlEncode((String)predicateUri) + "&editForm=" + UrlBuilder.urlEncode((String)generatorName);
    }

    private void setVarNames(EditConfigurationVTwo editConfiguration) {
        editConfiguration.setVarNameForSubject("subject");
        editConfiguration.setVarNameForPredicate("predicate");
        editConfiguration.setVarNameForObject("conceptNode");
    }

    protected void setTemplate(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.setTemplate(this.template);
    }

    private String getPrefixesString() {
        return "@prefix core: <http://vivoweb.org/ontology/core#> .";
    }

    private List<String> generateN3Required(VitroRequest vreq) {
        List n3Required = AddUserDefinedConceptGenerator.list((Object[])new Object[]{this.getPrefixesString() + "\n" + "?subject ?predicate ?conceptNode .\n"});
        List<String> inversePredicate = this.getInversePredicate(vreq);
        if (inversePredicate.size() > 0) {
            n3Required.add("?conceptNode <" + inversePredicate.get(0) + "> ?subject .");
        }
        return n3Required;
    }

    private List<String> generateN3Optional() {
        return AddUserDefinedConceptGenerator.list((Object[])new Object[]{"?conceptNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <" + SKOSConceptType + "> .\n" + "?conceptNode <" + "http://www.w3.org/2000/01/rdf-schema#label" + "> ?conceptLabel ."});
    }

    private Map<String, String> generateNewResources(VitroRequest vreq) {
        HashMap<String, String> newResources = new HashMap<String, String>();
        newResources.put("conceptNode", null);
        return newResources;
    }

    private void setUrisAndLiteralsInScope(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
        urisInScope.put(editConfiguration.getVarNameForSubject(), Arrays.asList(editConfiguration.getSubjectUri()));
        urisInScope.put(editConfiguration.getVarNameForPredicate(), Arrays.asList(editConfiguration.getPredicateUri()));
        urisInScope.put("inverseRolePredicate", this.getInversePredicate(vreq));
        editConfiguration.setUrisInScope(urisInScope);
        editConfiguration.setLiteralsInScope(new HashMap());
    }

    private List<String> getInversePredicate(VitroRequest vreq) {
        ArrayList<String> inversePredicateArray = new ArrayList<String>();
        ObjectProperty op = EditConfigurationUtils.getObjectProperty((VitroRequest)vreq);
        if (op != null && op.getURIInverse() != null) {
            inversePredicateArray.add(op.getURIInverse());
        }
        return inversePredicateArray;
    }

    private void setUrisAndLiteralsOnForm(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        ArrayList<String> urisOnForm = new ArrayList<String>();
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        urisOnForm.add("conceptNode");
        editConfiguration.setUrisOnform(urisOnForm);
        literalsOnForm.add("conceptLabel");
        editConfiguration.setLiteralsOnForm(literalsOnForm);
    }

    private void setSparqlQueries(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.setSparqlForAdditionalLiteralsInScope(new HashMap());
        HashMap urisInScope = new HashMap();
        editConfiguration.setSparqlForAdditionalUrisInScope(new HashMap());
        editConfiguration.setSparqlForExistingLiterals(new HashMap());
        editConfiguration.setSparqlForExistingUris(new HashMap());
    }

    private void setFields(EditConfigurationVTwo editConfiguration, VitroRequest vreq, String predicateUri) {
        this.setConceptNodeField(editConfiguration, vreq);
        this.setConceptLabelField(editConfiguration, vreq);
    }

    private void setConceptNodeField(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.addField(new FieldVTwo().setName("conceptNode"));
    }

    private void setConceptLabelField(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.addField(new FieldVTwo().setName("conceptLabel").setValidators(AddUserDefinedConceptGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})).setRangeDatatypeUri(XSD.xstring.toString()));
    }

    private void addPreprocessors(EditConfigurationVTwo editConfiguration, WebappDaoFactory wadf) {
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, String> formSpecificData = new HashMap<String, String>();
        formSpecificData.put("sparqlForAcFilter", this.getSparqlForAcFilter(vreq));
        formSpecificData.put("conceptType", SKOSConceptType);
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    public String getSparqlForAcFilter(VitroRequest vreq) {
        String subject = EditConfigurationUtils.getSubjectUri((VitroRequest)vreq);
        String predicate = EditConfigurationUtils.getPredicateUri((VitroRequest)vreq);
        String query = "PREFIX core:<http://vivoweb.org/ontology/core#> SELECT ?conceptNode WHERE { <" + subject + "> <" + predicate + "> ?conceptNode ." + "?conceptNode <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" + "> <" + SKOSConceptType + "> . }";
        return query;
    }

    public String getCurrentPredicate(VitroRequest vreq) {
        return vreq.getParameter("conceptPredicate");
    }

    static {
        SKOSConceptType = "http://www.w3.org/2004/02/skos/core#Concept";
    }
}

