/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.persongrantcount;

import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.visualization.constants.QueryConstants;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Activity;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.QueryRunner;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;

public class PersonGrantCountQueryRunner
implements QueryRunner<Set<Activity>> {
    protected static final Syntax SYNTAX = Syntax.syntaxARQ;
    private String personURI;
    private RDFService rdfService;
    private Log log;

    public PersonGrantCountQueryRunner(String personURI, RDFService rdfService, Log log) {
        this.personURI = personURI;
        this.rdfService = rdfService;
        this.log = log;
    }

    private String getSparqlConstruct(String queryURI) {
        String sparqlQuery = QueryConstants.getSparqlPrefixQuery() + "CONSTRUCT \n" + "{\n" + "    <" + queryURI + "> core:investigatorOn ?grant .\n" + "    ?grant core:roleDate  ?roleDate .\n" + "    ?grant core:grantDate ?grantDate .\n" + "}\n" + "WHERE" + "{\n" + "    {\n" + "    <" + queryURI + "> rdf:type foaf:Person ;\n" + "                       <http://purl.obolibrary.org/obo/RO_0000053> ?role .  \n" + "    ?role core:relatedBy ?grant . \n" + "\t   ?grant rdf:type core:Grant ; \n" + "              rdfs:label ?grantLabel .\n" + "    } UNION {\n" + "    <" + queryURI + "> rdf:type foaf:Person ;\n" + "                       <http://purl.obolibrary.org/obo/RO_0000053> ?role .  \n" + "    ?role core:relatedBy ?grant . \n" + "\t   ?grant rdf:type core:Grant .\n" + "    ?role core:dateTimeInterval ?dateTimeInterval . \n" + "    ?dateTimeInterval core:start ?dateTimeValue . \n" + "    ?dateTimeValue core:dateTime ?roleDate .\n" + "    } UNION {\n" + "    <" + queryURI + "> rdf:type foaf:Person ;\n" + "                       <http://purl.obolibrary.org/obo/RO_0000053> ?role .  \n" + "    ?role core:relatedBy ?grant . \n" + "\t   ?grant rdf:type core:Grant .\n" + "    ?grant core:dateTimeInterval ?dateTimeInterval . \n" + "    ?dateTimeInterval core:start ?dateTimeValue . \n" + "    ?dateTimeValue core:dateTime ?grantDate .\n" + "    }\n" + "}\n";
        this.log.debug((Object)sparqlQuery);
        return sparqlQuery;
    }

    private String getSparqlQuery(String queryURI) {
        String sparqlQuery = QueryConstants.getSparqlPrefixQuery() + "SELECT DISTINCT ?grant (SAMPLE(?sampleRoleDate) AS ?roleDate) (SAMPLE(?sampleGrantDate) AS ?grantDate)\n" + "WHERE { \n" + "    <" + queryURI + "> core:investigatorOn ?grant . \n" + "\t   OPTIONAL { ?grant core:roleDate ?sampleRoleDate . } .\n" + "\t   OPTIONAL { ?grant core:grantDate ?sampleGrantDate . } .\n" + "} GROUP BY ?grant\n";
        this.log.debug((Object)sparqlQuery);
        return sparqlQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Activity> getQueryResult() throws MalformedQueryParametersException {
        if (StringUtils.isNotBlank((CharSequence)this.personURI)) {
            IRIFactory iRIFactory = IRIFactory.jenaImplementation();
            IRI iri = iRIFactory.create(this.personURI);
            if (iri.hasViolation(false)) {
                String errorMsg = ((Violation)iri.violations(false).next()).getShortMessage();
                this.log.error((Object)("Pub Count vis Query " + errorMsg));
                throw new MalformedQueryParametersException("URI provided for an individual is malformed.");
            }
        } else {
            throw new MalformedQueryParametersException("URL parameter is either null or empty.");
        }
        PersonGrantConsumer consumer = new PersonGrantConsumer();
        try {
            Model model = ModelFactory.createDefaultModel();
            this.rdfService.sparqlConstructQuery(this.getSparqlConstruct(this.personURI), model);
            Query q = QueryFactory.create((String)this.getSparqlQuery(this.personURI));
            try (QueryExecution qe = QueryExecutionFactory.create((Query)q, (Model)model);){
                consumer.processResultSet(qe.execSelect());
            }
        }
        catch (RDFServiceException r) {
            throw new RuntimeException(r);
        }
        return consumer.getAuthorGrants();
    }

    private static class PersonGrantConsumer
    extends ResultSetConsumer {
        Set<Activity> authorGrants = new HashSet<Activity>();

        private PersonGrantConsumer() {
        }

        protected void processQuerySolution(QuerySolution qs) {
            Activity biboDocument = new Activity(qs.get("grant").asResource().getURI());
            RDFNode roleDateNode = qs.get("roleDate");
            if (roleDateNode != null) {
                biboDocument.setActivityDate(roleDateNode.asLiteral().getString());
            } else {
                RDFNode grantDateNode = qs.get("grantDate");
                if (grantDateNode != null) {
                    biboDocument.setActivityDate(grantDateNode.asLiteral().getString());
                }
            }
            this.authorGrants.add(biboDocument);
        }

        public Set<Activity> getAuthorGrants() {
            return this.authorGrants;
        }
    }
}

