/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.temporalgraph;

import com.google.gson.Gson;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.visualization.constants.VisConstants;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.model.OrganizationPeopleMap;
import edu.cornell.mannlib.vitro.webapp.visualization.temporalgraph.OrganizationUtilityFunctions;
import edu.cornell.mannlib.vitro.webapp.visualization.utilities.CounterUtils;
import edu.cornell.mannlib.vitro.webapp.visualization.utilities.OrgUtils;
import edu.cornell.mannlib.vitro.webapp.visualization.utilities.VisualizationCaches;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.json.JsonObject;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.json.SubjectEntityJSON;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.VisualizationRequestHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.jena.query.Dataset;

public class TemporalPublicationVisualizationRequestHandler
implements VisualizationRequestHandler {
    @Override
    public ResponseValues generateStandardVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        String entityURI = vitroRequest.getParameter("uri");
        return this.generateStandardVisualizationForPublicationTemporalVis(vitroRequest, log, dataset, entityURI);
    }

    @Override
    public ResponseValues generateVisualizationForShortURLRequests(Map<String, String> parameters, VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        return this.generateStandardVisualizationForPublicationTemporalVis(vitroRequest, log, dataset, parameters.get("uri"));
    }

    private ResponseValues generateStandardVisualizationForPublicationTemporalVis(VitroRequest vitroRequest, Log log, Dataset dataset, String entityURI) throws MalformedQueryParametersException {
        if (StringUtils.isBlank((CharSequence)entityURI)) {
            entityURI = OrganizationUtilityFunctions.getStaffProvidedOrComputedHighestLevelOrganization(log, dataset, vitroRequest);
        }
        return this.prepareStandaloneMarkupResponse(vitroRequest, entityURI);
    }

    private Map<String, String> getSubjectEntityAndGenerateDataResponse(VitroRequest vitroRequest, Log log, Dataset dataset, String subjectEntityURI, VisConstants.DataVisMode visMode) throws MalformedQueryParametersException {
        RDFService rdfService = vitroRequest.getRDFService();
        Map<String, String> orgLabelMap = VisualizationCaches.organizationLabels.get(rdfService);
        Map<String, String> personLabelMap = VisualizationCaches.personLabels.get(rdfService);
        if (orgLabelMap.get(subjectEntityURI) == null) {
            if (VisConstants.DataVisMode.JSON.equals((Object)visMode)) {
                return this.prepareStandaloneDataErrorResponse();
            }
            return this.prepareDataErrorResponse();
        }
        Map<String, Set<String>> subOrgMap = VisualizationCaches.organizationSubOrgs.get(rdfService);
        Map<String, String> orgMostSpecificLabelMap = VisualizationCaches.organizationToMostSpecificLabel.get(rdfService);
        Map<String, String> personMostSpecificLabelMap = VisualizationCaches.personToMostSpecificLabel.get(rdfService);
        OrganizationPeopleMap organisationToPeopleMap = VisualizationCaches.organisationToPeopleMap.get(rdfService);
        Map<String, Set<String>> personToPublicationMap = VisualizationCaches.personToPublication.get((RDFService)rdfService).personToPublication;
        Map<String, String> publicationToYearMap = VisualizationCaches.publicationToYear.get(rdfService);
        HashSet<String> orgPublications = new HashSet<String>();
        HashSet<String> orgPublicationsPeople = new HashSet<String>();
        HashMap<String, Set<String>> subOrgPublicationsMap = new HashMap<String, Set<String>>();
        OrgUtils.getObjectMappingsForOrgAndSubOrgs(subjectEntityURI, orgPublications, orgPublicationsPeople, subOrgPublicationsMap, subOrgMap, organisationToPeopleMap.organizationToPeople, personToPublicationMap);
        if (orgPublications.isEmpty()) {
            if (VisConstants.DataVisMode.JSON.equals((Object)visMode)) {
                return this.prepareStandaloneDataErrorResponse();
            }
            return this.prepareDataErrorResponse();
        }
        HashMap<String, String> fileData = new HashMap<String, String>();
        if (VisConstants.DataVisMode.JSON.equals((Object)visMode)) {
            String type;
            List<List<Integer>> yearPubCounts;
            JsonObject entityJson;
            Gson json = new Gson();
            HashSet<Object> subEntitiesJson = new HashSet<Object>();
            for (String subOrg : subOrgPublicationsMap.keySet()) {
                entityJson = new JsonObject(orgLabelMap.get(subOrg));
                if (subOrgPublicationsMap.containsKey(subOrg)) {
                    yearPubCounts = CounterUtils.getObjectCountByYear((Set)subOrgPublicationsMap.get(subOrg), publicationToYearMap);
                    entityJson.setYearToActivityCount(yearPubCounts);
                } else {
                    entityJson.setYearToActivityCount(new ArrayList<List<Integer>>());
                }
                type = orgMostSpecificLabelMap.get(subOrg);
                entityJson.setOrganizationTypes(Arrays.asList(type == null ? "Organization" : type));
                entityJson.setEntityURI(subOrg);
                entityJson.setVisMode("ORGANIZATION");
                subEntitiesJson.add(entityJson);
            }
            for (String person : orgPublicationsPeople) {
                entityJson = new JsonObject(personLabelMap.get(person));
                if (personToPublicationMap.containsKey(person)) {
                    yearPubCounts = CounterUtils.getObjectCountByYear(personToPublicationMap.get(person), publicationToYearMap);
                    entityJson.setYearToActivityCount(yearPubCounts);
                } else {
                    entityJson.setYearToActivityCount(new ArrayList<List<Integer>>());
                }
                type = personMostSpecificLabelMap.get(person);
                entityJson.setOrganizationTypes(Arrays.asList(type == null ? "Person" : type));
                entityJson.setEntityURI(person);
                entityJson.setVisMode("PERSON");
                subEntitiesJson.add(entityJson);
            }
            SubjectEntityJSON subjectEntityJSON = new SubjectEntityJSON(orgLabelMap.get(subjectEntityURI), subjectEntityURI, OrgUtils.getParentURIsToLabel(subjectEntityURI, subOrgMap, orgLabelMap));
            subEntitiesJson.add(subjectEntityJSON);
            fileData.put("fileContentType", "application/octet-stream");
            fileData.put("fileContent", json.toJson(subEntitiesJson));
        } else {
            String entityLabel = orgLabelMap.get(subjectEntityURI);
            if (StringUtils.isBlank((CharSequence)entityLabel)) {
                entityLabel = "no-organization";
            }
            StringBuilder csvFileContent = new StringBuilder();
            csvFileContent.append("Entity Name, Publication Count, Entity Type\n");
            for (String subOrg : subOrgPublicationsMap.keySet()) {
                csvFileContent.append(StringEscapeUtils.escapeCsv((String)orgLabelMap.get(subOrg)));
                csvFileContent.append(", ");
                csvFileContent.append(((Set)subOrgPublicationsMap.get(subOrg)).size());
                csvFileContent.append(", ");
                csvFileContent.append("Organization");
                csvFileContent.append("\n");
            }
            for (String person : orgPublicationsPeople) {
                csvFileContent.append(StringEscapeUtils.escapeCsv((String)personLabelMap.get(person)));
                csvFileContent.append(", ");
                if (personToPublicationMap.containsKey(person)) {
                    csvFileContent.append(personToPublicationMap.get(person).size());
                    csvFileContent.append(", ");
                } else {
                    csvFileContent.append("0, ");
                }
                csvFileContent.append("Person");
                csvFileContent.append("\n");
            }
            String outputFileName = UtilityFunctions.slugify(entityLabel) + "_publications-per-year" + ".csv";
            fileData.put("fileName", outputFileName);
            fileData.put("fileContentType", "application/octet-stream");
            fileData.put("fileContent", csvFileContent.toString());
        }
        return fileData;
    }

    private Map<String, String> prepareDataErrorResponse() {
        String outputFileName = "no-organization_publications-per-year.csv";
        HashMap<String, String> fileData = new HashMap<String, String>();
        fileData.put("fileName", outputFileName);
        fileData.put("fileContentType", "application/octet-stream");
        fileData.put("fileContent", "");
        return fileData;
    }

    private Map<String, String> prepareStandaloneDataErrorResponse() {
        HashMap<String, String> fileData = new HashMap<String, String>();
        fileData.put("fileContentType", "application/octet-stream");
        fileData.put("fileContent", "{\"error\" : \"No Publications for this Organization found in VIVO.\"}");
        return fileData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> generateDataVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        String entityURI = vitroRequest.getParameter("uri");
        VisConstants.DataVisMode currentDataMode = VisConstants.DataVisMode.CSV;
        if ("json".equalsIgnoreCase(vitroRequest.getParameter("vis_mode"))) {
            currentDataMode = VisConstants.DataVisMode.JSON;
            if (StringUtils.isBlank((CharSequence)entityURI)) {
                entityURI = OrganizationUtilityFunctions.getStaffProvidedOrComputedHighestLevelOrganization(log, dataset, vitroRequest);
            }
        }
        try {
            Map<String, String> map = this.getSubjectEntityAndGenerateDataResponse(vitroRequest, log, dataset, entityURI, currentDataMode);
            return map;
        }
        finally {
            VisualizationCaches.buildMissing();
        }
    }

    @Override
    public Object generateAjaxVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        throw new UnsupportedOperationException("Entity Pub Count does not provide Ajax Response.");
    }

    private TemplateResponseValues prepareStandaloneMarkupResponse(VitroRequest vreq, String entityURI) {
        String standaloneTemplate = "entityComparisonOnPublicationsStandalone.ftl";
        String organizationLabel = OrganizationUtilityFunctions.getEntityLabelFromDAO(vreq, entityURI);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", organizationLabel + " - Temporal Graph Visualization");
        body.put("organizationURI", entityURI);
        body.put("organizationLocalName", UtilityFunctions.getIndividualLocalName(entityURI, vreq));
        body.put("vivoDefaultNamespace", vreq.getWebappDaoFactory().getDefaultNamespace());
        body.put("organizationLabel", organizationLabel);
        if (VisualizationCaches.personToPublication.isCached()) {
            body.put("builtFromCacheTime", VisualizationCaches.personToPublication.cachedWhen());
        }
        return new TemplateResponseValues(standaloneTemplate, body);
    }

    @Override
    public AuthorizationRequest getRequiredPrivileges() {
        return null;
    }
}

