/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.orcid.controller;

import edu.cornell.mannlib.orcidclient.OrcidClientException;
import edu.cornell.mannlib.orcidclient.actions.ApiAction;
import edu.cornell.mannlib.orcidclient.actions.ReadPublicBioAction;
import edu.cornell.mannlib.orcidclient.auth.AuthorizationStatus;
import edu.cornell.mannlib.orcidclient.orcidmessage.OrcidMessage;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidAbstractHandler;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidConfirmationState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrcidReadProfileHandler
extends OrcidAbstractHandler {
    private static final Log log = LogFactory.getLog(OrcidReadProfileHandler.class);
    private AuthorizationStatus status;
    private OrcidMessage profile;

    protected OrcidReadProfileHandler(VitroRequest vreq) {
        super(vreq);
    }

    public ResponseValues exec() throws OrcidClientException {
        this.status = this.auth.getAuthorizationStatus(ApiAction.AUTHENTICATE);
        if (this.status.isSuccess()) {
            this.readProfile();
            this.state.progress(OrcidConfirmationState.Progress.GOT_PROFILE, this.profile);
            this.recordConfirmation();
            if (this.state.getVivoId() != null) {
                this.state.progress(OrcidConfirmationState.Progress.ID_ALREADY_PRESENT, new OrcidMessage[0]);
            }
            return this.showConfirmationPage();
        }
        if (this.status.isDenied()) {
            return this.showConfirmationPage(OrcidConfirmationState.Progress.DENIED_AUTHENTICATE, new OrcidMessage[0]);
        }
        return this.showConfirmationPage(OrcidConfirmationState.Progress.FAILED_AUTHENTICATE, new OrcidMessage[0]);
    }

    private void readProfile() throws OrcidClientException {
        this.profile = new ReadPublicBioAction().execute(this.status.getAccessToken().getOrcid());
        log.debug((Object)"Read profile");
    }
}

