/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.semservices.service.impl;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.semservices.bo.Concept;
import edu.cornell.mannlib.semservices.service.ExternalConceptService;
import edu.cornell.mannlib.semservices.util.SKOSUtils;
import edu.cornell.mannlib.semservices.util.XMLUtils;
import edu.cornell.mannlib.vitro.webapp.utils.json.JacksonUtils;
import edu.cornell.mannlib.vitro.webapp.web.URLEncoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AgrovocService
implements ExternalConceptService {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final String schemeUri = "http://aims.fao.org/aos/agrovoc/agrovocScheme";
    private final String ontologyName = "agrovoc";
    private final String format = "SKOS";
    private final String lang = "en";
    private final String searchMode = "starts with";
    protected final String dbpedia_endpoint = " http://dbpedia.org/sparql";
    protected final String conceptSkosMosBase = "http://aims.fao.org/skosmos/rest/v1/";
    protected final String conceptsSkosMosSearch = "http://aims.fao.org/skosmos/rest/v1/search?";
    protected final String conceptSkosMosURL = "http://aims.fao.org/skosmos/rest/v1//agrovoc/data?";

    public List<Concept> getConcepts(String term) throws Exception {
        ArrayList<Concept> conceptList = new ArrayList<Concept>();
        String result = this.getSKOSMosSearchResults(term, this.lang);
        List<String> conceptUris = this.getConceptURIsListFromSkosMosResult(result);
        if (conceptUris.size() == 0) {
            return conceptList;
        }
        int conceptCounter = 0;
        HashSet<String> encounteredURI = new HashSet<String>();
        for (String conceptUri : conceptUris) {
            Concept c;
            ++conceptCounter;
            if (StringUtils.isEmpty((CharSequence)conceptUri) || encounteredURI.contains(conceptUri)) continue;
            encounteredURI.add(conceptUri);
            URI uri = null;
            try {
                uri = new URI(conceptUri);
            }
            catch (URISyntaxException e) {
                this.logger.error((Object)"Error occurred with creating the URI ", (Throwable)e);
                continue;
            }
            String bestMatch = "false";
            if (conceptCounter == 1) {
                bestMatch = "true";
            }
            if ((c = this.createConcept(bestMatch, conceptUri)) == null) continue;
            List closeMatches = c.getCloseMatchURIList();
            for (String closeMatch : closeMatches) {
                if (!closeMatch.startsWith("http://dbpedia.org")) continue;
                try {
                    String description = this.getDbpediaDescription(closeMatch);
                    c.setDefinition(description);
                }
                catch (Exception ex) {
                    this.logger.error((Object)"An error occurred in the process of retrieving dbpedia description", (Throwable)ex);
                }
            }
            conceptList.add(c);
        }
        return conceptList;
    }

    public List<Concept> processResults(String term) throws Exception {
        return this.getConcepts(term);
    }

    public Concept createConcept(String bestMatch, String skosConceptURI) {
        Concept concept = new Concept();
        concept.setUri(skosConceptURI);
        concept.setConceptId(this.stripConceptId(skosConceptURI));
        concept.setBestMatch(bestMatch);
        concept.setDefinedBy("http://aims.fao.org/aos/agrovoc/agrovocScheme");
        concept.setSchemeURI(this.schemeUri);
        concept.setType("");
        String encodedURI = URLEncoder.encode((String)skosConceptURI);
        String encodedFormat = URLEncoder.encode((String)"application/rdf+xml");
        String url = "http://aims.fao.org/skosmos/rest/v1//agrovoc/data?uri=" + encodedURI + "&format=" + encodedFormat;
        try {
            concept = SKOSUtils.createConceptUsingXMLFromURL((Concept)concept, (String)url, (String)"en", (boolean)false);
        }
        catch (Exception ex) {
            this.logger.debug((Object)("Error occurred for creating concept " + skosConceptURI), (Throwable)ex);
            return null;
        }
        return concept;
    }

    public List<Concept> getConceptsByURIWithSparql(String uri) throws Exception {
        ArrayList<Concept> conceptList = new ArrayList<Concept>();
        return conceptList;
    }

    protected String getAgrovocTermCode(String rdf) throws Exception {
        String termcode = new String();
        try {
            Document doc = XMLUtils.parse((String)rdf);
            NodeList nodes = doc.getElementsByTagName("hasCodeAgrovoc");
            if (nodes.item(0) != null) {
                Node node = nodes.item(0);
                termcode = node.getTextContent();
            }
        }
        catch (SAXException e) {
            throw e;
        }
        catch (ParserConfigurationException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        return termcode;
    }

    protected String getConceptURIFromRDF(String rdf) {
        String conceptUri = new String();
        try {
            Document doc = XMLUtils.parse((String)rdf);
            NodeList nodes = doc.getElementsByTagName("skos:Concept");
            Node node = nodes.item(0);
            NamedNodeMap attrs = node.getAttributes();
            Attr idAttr = (Attr)attrs.getNamedItem("rdf:about");
            conceptUri = idAttr.getTextContent();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("rdf: " + rdf);
        }
        catch (SAXException e) {
            e.printStackTrace();
            System.err.println("rdf: " + rdf);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            System.err.println("rdf: " + rdf);
        }
        return conceptUri;
    }

    protected List<String> getConceptURIsListFromRDF(String rdf) {
        ArrayList<String> conceptUris = new ArrayList<String>();
        try {
            Document doc = XMLUtils.parse((String)rdf);
            NodeList nodes = doc.getElementsByTagName("skos:Concept");
            int numberNodes = nodes.getLength();
            for (int n = 0; n < numberNodes; ++n) {
                Node node = nodes.item(n);
                NamedNodeMap attrs = node.getAttributes();
                Attr idAttr = (Attr)attrs.getNamedItem("rdf:about");
                String conceptUri = idAttr.getTextContent();
                conceptUris.add(conceptUri);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("rdf: " + rdf);
        }
        catch (SAXException e) {
            e.printStackTrace();
            System.err.println("rdf: " + rdf);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            System.err.println("rdf: " + rdf);
        }
        return conceptUris;
    }

    protected String getDbpediaDescription(String uri) throws Exception {
        String descriptionSource = " (Source: DBpedia)";
        String description = new String();
        String qs = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nPREFIX dbpedia-owl: <http://dbpedia.org/ontology/>\nSELECT DISTINCT ?description WHERE { \n<" + uri + "> rdfs:comment ?description . \n" + "FILTER (LANG(?description)='en' ) \n" + "}";
        ArrayList resultList = new ArrayList();
        QueryExecution qexec = null;
        Query query = QueryFactory.create((String)qs);
        qexec = QueryExecutionFactory.sparqlService((String)this.dbpedia_endpoint, (Query)query);
        qexec.setTimeout(5000L, TimeUnit.MILLISECONDS);
        resultList = new ArrayList();
        ResultSet resultSet = qexec.execSelect();
        int resultSetSize = 0;
        while (resultSet.hasNext()) {
            ++resultSetSize;
            QuerySolution solution = resultSet.nextSolution();
            Iterator iterator = solution.varNames();
            HashMap<String, String> hm = new HashMap<String, String>();
            while (iterator.hasNext()) {
                String nodeval;
                String name = (String)iterator.next();
                RDFNode rdfnode = solution.get(name);
                if (rdfnode.isLiteral()) {
                    Literal literal = rdfnode.asLiteral();
                    nodeval = literal.getString();
                    hm.put(name, nodeval);
                    continue;
                }
                if (!rdfnode.isResource()) continue;
                Resource resource = rdfnode.asResource();
                nodeval = resource.toString();
                hm.put(name, nodeval);
            }
            resultList.add(hm);
        }
        description = "";
        for (HashMap hashMap : resultList) {
            if (!hashMap.containsKey("description")) continue;
            description = (String)hashMap.get("description");
        }
        return description + descriptionSource;
    }

    protected String stripConceptId(String uri) {
        String conceptId = new String();
        int lastslash = uri.lastIndexOf(47);
        conceptId = uri.substring(lastslash + 1, uri.length());
        return conceptId;
    }

    protected String extractConceptId(String str) {
        try {
            return str.substring(1, str.length() - 1);
        }
        catch (Exception ex) {
            return "";
        }
    }

    private String getSKOSMosSearchResults(String term, String lang) {
        String urlEncodedTerm = URLEncoder.encode((String)term);
        String searchUrlString = this.conceptsSkosMosSearch + "query=" + urlEncodedTerm + "*" + "&lang=" + lang;
        URL searchURL = null;
        try {
            searchURL = new URL(searchUrlString);
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception occurred in instantiating URL for " + searchUrlString), (Throwable)e);
            return null;
        }
        String results = null;
        try {
            String inputLine;
            StringWriter sw = new StringWriter();
            BufferedReader in = new BufferedReader(new InputStreamReader(searchURL.openStream()));
            while ((inputLine = in.readLine()) != null) {
                sw.write(inputLine);
            }
            in.close();
            results = sw.toString();
            this.logger.debug((Object)results);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Error occurred in getting concept from the URL " + searchUrlString), (Throwable)ex);
            return null;
        }
        return results;
    }

    private List<String> getConceptURIsListFromSkosMosResult(String results) {
        ArrayList<String> conceptURIs = new ArrayList<String>();
        ObjectNode json = (ObjectNode)JacksonUtils.parseJson((String)results);
        if (json.has("results")) {
            ArrayNode jsonArray = (ArrayNode)json.get("results");
            int numberResults = jsonArray.size();
            for (int i = 0; i < numberResults; ++i) {
                ObjectNode jsonObject = (ObjectNode)jsonArray.get(i);
                if (!jsonObject.has("uri")) continue;
                conceptURIs.add(jsonObject.get("uri").asText());
            }
        }
        return conceptURIs;
    }
}

