/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.ajax;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.AbstractAjaxResponder;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestAnalysisContext;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestAnalysisContextImpl;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestAnalyzer;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestInfo;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.json.JSONException;

public class QrCodeDetails
extends AbstractAjaxResponder {
    private static final Log log = LogFactory.getLog((String)QrCodeDetails.class.getName());
    private List<Map<String, String>> vcardData;
    private static String VCARD_DATA_QUERY = "PREFIX obo: <http://purl.obolibrary.org/obo/> \nPREFIX vcard: <http://www.w3.org/2006/vcard/ns#>  \nSELECT DISTINCT ?firstName ?lastName ?email ?phone ?title  \nWHERE {  \n    ?subject obo:ARG_2000028 ?vIndividual .  \n    ?vIndividual vcard:hasName ?vName .   \n    ?vName vcard:givenName ?firstName .  \n    ?vName vcard:familyName ?lastName .  \n    OPTIONAL { ?vIndividual vcard:hasEmail ?vEmail . \n               ?vEmail vcard:email ?email . \n    } \n    OPTIONAL { ?vIndividual vcard:hasTelephone ?vPhone .   \n               ?vPhone vcard:telephone ?phone .  \n    } \n    OPTIONAL { ?vIndividual vcard:hasTitle ?vTitle . \n               ?vTitle vcard:title ?title . \n    } \n} ";

    public QrCodeDetails(HttpServlet parent, VitroRequest vreq, HttpServletResponse resp) {
        super(parent, vreq, resp);
    }

    public String prepareResponse() throws IOException, JSONException {
        try {
            Individual individual = this.getIndividualFromRequest(this.vreq);
            String firstName = "";
            String lastName = "";
            String preferredTitle = "";
            String phoneNumber = "";
            String email = "";
            String response = "[";
            this.vcardData = this.getVcardData(individual, this.vreq);
            for (Map<String, String> map : this.vcardData) {
                firstName = map.get("firstName");
                lastName = map.get("lastName");
                preferredTitle = map.get("title");
                phoneNumber = map.get("phone");
                email = map.get("email");
            }
            response = firstName != null && firstName.length() > 0 ? response + "{\"firstName\": \"" + firstName + "\"}," : response + "{\"firstName\": \"\"},";
            response = lastName != null && lastName.length() > 0 ? response + "{\"lastName\": \"" + lastName + "\"}," : response + "{\"lastName\": \"\"},";
            response = preferredTitle != null && preferredTitle.length() > 0 ? response + "{\"preferredTitle\": \"" + preferredTitle + "\"}," : response + "{\"preferredTitle\": \"\"},";
            response = phoneNumber != null && phoneNumber.length() > 0 ? response + "{\"phoneNumber\": \"\"}," : response + "{\"phoneNumber\": \"\"},";
            response = email != null && email.length() > 0 ? response + "{\"email\": \"" + email + "\"}," : response + "{\"email\": \"\"},";
            response = response + " ]";
            response = response.replace(", ]", " ]");
            log.debug((Object)response);
            return response;
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve vCard information", (Throwable)e);
            return "[]";
        }
    }

    private List<Map<String, String>> getVcardData(Individual individual, VitroRequest vreq) {
        String queryStr = QueryUtils.subUriForQueryVar((String)VCARD_DATA_QUERY, (String)"subject", (String)individual.getURI());
        log.debug((Object)("queryStr = " + queryStr));
        ArrayList<Map<String, String>> vcardData = new ArrayList<Map<String, String>>();
        try {
            ResultSet results = QueryUtils.getQueryResults((String)queryStr, (VitroRequest)vreq);
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                vcardData.add(QueryUtils.querySolutionToStringValueMap((QuerySolution)soln));
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return vcardData;
    }

    private Individual getIndividualFromRequest(VitroRequest vreq) {
        IndividualRequestInfo requestInfo = new IndividualRequestAnalyzer(vreq, (IndividualRequestAnalysisContext)new IndividualRequestAnalysisContextImpl(vreq)).analyze();
        return requestInfo.getIndividual();
    }
}

