/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.edit.utils.LocalNamespaceClassUtils;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class InstitutionalInternalClassController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(InstitutionalInternalClassController.class);
    private static final String EDIT_FORM = "/processInstitutionalInternalClass";
    public static final AuthorizationRequest REQUIRED_ACTIONS = SimplePermission.MANAGE_MENUS.ACTION;
    private static final String DISPLAY_FORM = "/institutionalInternalClassForm.ftl";
    private static HashMap<String, String> localNamespaces = new HashMap();
    private static HashMap<String, String> localNamespaceClasses = new HashMap();
    private static final String CREATE_CLASS_PARAM = "createClass";
    private static final String REDIRECT_PAGE = "/siteAdmin";

    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return REQUIRED_ACTIONS;
    }

    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.retrieveLocalClasses(vreq, data);
        if (this.isSubmission(vreq)) {
            this.processSubmission(vreq, data);
        } else if (this.isCreateNewClass(vreq)) {
            this.processCreateNewClass(vreq, data);
        } else if (this.isSelectExistingClass(vreq)) {
            this.processSelectExistingClass(vreq, data);
        } else if (this.isCreateOntologies(vreq)) {
            this.processCreateOntologies(vreq, data);
        } else {
            log.error((Object)"Don't recognize the type of request.");
        }
        data.put("formUrl", vreq.getContextPath() + EDIT_FORM);
        data.put("cancelUrl", vreq.getContextPath() + REDIRECT_PAGE);
        if (this.isSubmission(vreq)) {
            return this.redirectToSiteAdmin();
        }
        return new TemplateResponseValues(DISPLAY_FORM, data);
    }

    private boolean isSubmission(VitroRequest vreq) {
        String submit = vreq.getParameter("submitForm");
        return submit != null && !submit.isEmpty();
    }

    private void processCreateOntologies(VitroRequest vreq, Map<String, Object> data) {
        data.put("submitAction", "");
    }

    private boolean isCreateOntologies(VitroRequest vreq) {
        return localNamespaces.size() == 0;
    }

    private void processCreateNewClass(VitroRequest vreq, Map<String, Object> data) {
        data.put("submitAction", "Create Class");
        data.put("createNewClass", true);
    }

    private boolean isCreateNewClass(VitroRequest vreq) {
        String command = vreq.getParameter("cmd");
        if (command != null && command.equals(CREATE_CLASS_PARAM)) {
            return true;
        }
        return localNamespaces.size() > 0 && localNamespaceClasses.size() == 0;
    }

    private void processSelectExistingClass(VitroRequest vreq, Map<String, Object> data) {
        data.put("useExistingLocalClass", true);
        data.put("submitAction", "Save");
    }

    private boolean isSelectExistingClass(VitroRequest vreq) {
        return localNamespaces.size() > 0 && localNamespaceClasses.size() > 0;
    }

    private void retrieveLocalClasses(VitroRequest vreq, Map<String, Object> data) {
        localNamespaces = LocalNamespaceClassUtils.getLocalOntologyNamespaces((VitroRequest)vreq);
        localNamespaceClasses = LocalNamespaceClassUtils.getLocalNamespacesClasses((VitroRequest)vreq, localNamespaces);
        data.put("existingLocalClasses", localNamespaceClasses);
        data.put("existingLocalNamespaces", localNamespaces);
        String noLocalOntologiesMessage = "There are currently no local ontologies.  You must create a new ontology";
        data.put("noLocalOntologiesMessage", noLocalOntologiesMessage);
        if (localNamespaces.size() == 0) {
            data.put("ontologiesExist", false);
        } else {
            data.put("ontologiesExist", true);
            if (localNamespaces.size() > 1) {
                data.put("multipleLocalNamespaces", true);
            } else {
                data.put("multipleLocalNamespaces", false);
                data.put("existingLocalNamespace", localNamespaces.keySet().iterator().next());
            }
            data.put("existingInternalClass", this.retrieveCurrentInternalClass());
        }
        String defaultNamespace = vreq.getWebappDaoFactory().getDefaultNamespace();
        data.put("defaultNamespace", defaultNamespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSubmission(VitroRequest vreq, Map<String, Object> data) {
        String classUri = null;
        if (this.isNewClassSubmission(vreq)) {
            VClass v = this.generateNewVClass(vreq.getParameter("localClassName"), vreq.getParameter("existingLocalNamespaces"));
            classUri = v.getURI();
            try {
                vreq.getWebappDaoFactory().getVClassDao().insertNewVClass(v);
            }
            catch (Exception ex) {
                log.error((Object)("Insertion of new class " + vreq.getParameter("name") + " resulted in error "), (Throwable)ex);
            }
        } else {
            classUri = this.getExistingClassUri(vreq);
        }
        if (classUri != null && !classUri.isEmpty()) {
            OntModel writeModel = ModelAccess.on((ServletContext)this.getServletContext()).getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox");
            writeModel.enterCriticalSection(false);
            writeModel.notifyEvent((Object)new EditEvent(null, true));
            try {
                log.debug((Object)("Should be removing these statements " + writeModel.listStatements(null, ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#isMenuPageIntersectionClass"), (RDFNode)null).toList().toString()));
                writeModel.removeAll(null, ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#isMenuPageIntersectionClass"), (RDFNode)null);
                log.debug((Object)("Are there any statements left for internal class annotation:  " + writeModel.listStatements(null, ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#isMenuPageIntersectionClass"), (RDFNode)null).toList().toString()));
                writeModel.add(writeModel.createStatement(ResourceFactory.createResource((String)classUri), ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#isMenuPageIntersectionClass"), (RDFNode)writeModel.createLiteral("true")));
            }
            catch (Exception ex) {
                log.error((Object)("Error occurred in adding statement for " + classUri + " becoming internal class"), (Throwable)ex);
            }
            finally {
                writeModel.notifyEvent((Object)new EditEvent(null, true));
                writeModel.leaveCriticalSection();
            }
        }
    }

    private VClass generateNewVClass(String newClassName, String namespace) {
        VClass newClass = new VClass();
        newClass.setName(newClassName);
        newClass.setNamespace(namespace);
        String uri = namespace + newClassName.replaceAll(" ", "");
        newClass.setURI(uri);
        return newClass;
    }

    private boolean isNewClassSubmission(VitroRequest vreq) {
        String localName = vreq.getParameter("localClassName");
        return localName != null && !localName.isEmpty();
    }

    private String getExistingClassUri(VitroRequest vreq) {
        return vreq.getParameter("existingLocalClasses");
    }

    private RedirectResponseValues redirectToSiteAdmin() {
        return new RedirectResponseValues(REDIRECT_PAGE, 303);
    }

    private String retrieveCurrentInternalClass() {
        String internalClassUri = "";
        OntModel mainModel = ModelAccess.on((ServletContext)this.getServletContext()).getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox");
        StmtIterator internalIt = mainModel.listStatements(null, ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#isMenuPageIntersectionClass"), (RDFNode)null);
        while (internalIt.hasNext()) {
            Statement s = internalIt.nextStatement();
            internalClassUri = s.getSubject().getURI();
            log.debug((Object)("Found internal class uri " + internalClassUri));
        }
        return internalClassUri;
    }
}

