/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.visualization;

import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.visualization.VisualizationsDependencyInjector;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.VisualizationRequestHandler;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Syntax;

public class DataVisualizationController
extends VitroHttpServlet {
    public static final String URL_ENCODING_SCHEME = "UTF-8";
    private static final Log log = LogFactory.getLog((String)DataVisualizationController.class.getName());
    protected static final Syntax SYNTAX = Syntax.syntaxARQ;
    public static final String FILE_CONTENT_TYPE_KEY = "fileContentType";
    public static final String FILE_CONTENT_KEY = "fileContent";
    public static final String FILE_NAME_KEY = "fileName";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VitroRequest vreq = new VitroRequest(request);
        VisualizationRequestHandler visRequestHandler = this.getVisualizationRequestHandler(vreq);
        if (visRequestHandler != null) {
            if (visRequestHandler.getRequiredPrivileges() != null && !this.isAuthorizedToDisplayPage(request, response, visRequestHandler.getRequiredPrivileges())) {
                return;
            }
            try {
                Map<String, String> dataResponse = this.renderVisualization(vreq, visRequestHandler);
                response.setContentType(dataResponse.get(FILE_CONTENT_TYPE_KEY));
                if (dataResponse.containsKey(FILE_NAME_KEY)) {
                    response.setHeader("Content-Disposition", "attachment;filename=" + dataResponse.get(FILE_NAME_KEY));
                }
                response.getWriter().write(dataResponse.get(FILE_CONTENT_KEY));
                return;
            }
            catch (MalformedQueryParametersException e) {
                UtilityFunctions.handleMalformedParameters(e.getMessage(), response, log);
                return;
            }
        }
        UtilityFunctions.handleMalformedParameters("Inappropriate query parameters were submitted.", response, log);
    }

    private Map<String, String> renderVisualization(VitroRequest vitroRequest, VisualizationRequestHandler visRequestHandler) throws MalformedQueryParametersException {
        OntModel model = vitroRequest.getJenaOntModel();
        if (model == null) {
            String errorMessage = "This service is not supporeted by the current webapp configuration. A jena model is required in the servlet context.";
            log.error((Object)errorMessage);
            throw new MalformedQueryParametersException(errorMessage);
        }
        Dataset dataset = this.setupJENADataSource(vitroRequest);
        if (dataset != null && visRequestHandler != null) {
            return visRequestHandler.generateDataVisualization(vitroRequest, log, dataset);
        }
        String errorMessage = "Data Model Empty &/or Inappropriate query parameters were submitted. ";
        throw new MalformedQueryParametersException(errorMessage);
    }

    private VisualizationRequestHandler getVisualizationRequestHandler(VitroRequest vitroRequest) {
        String visType = vitroRequest.getParameter("vis");
        VisualizationRequestHandler visRequestHandler = null;
        try {
            visRequestHandler = VisualizationsDependencyInjector.getVisualizationIDsToClassMap(this.getServletContext()).get(visType);
        }
        catch (NullPointerException nullKeyException) {
            return null;
        }
        return visRequestHandler;
    }

    private Dataset setupJENADataSource(VitroRequest vreq) {
        log.debug((Object)"rdfResultFormat was: RDF/XML-ABBREV");
        return vreq.getDataset();
    }
}

