/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VitroVocabulary;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.AutocompleteRequiredInputValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeIntervalValidationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeWithPrecisionVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditElementVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.FrontEndEditingUtils;
import edu.cornell.mannlib.vitro.webapp.utils.generators.EditModeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;
import org.vivoweb.webapp.util.ModelUtils;

public class AddGrantRoleToPersonGenerator
implements EditConfigurationGenerator {
    private Log log = LogFactory.getLog(AddGrantRoleToPersonGenerator.class);
    private String subjectUri = null;
    private String predicateUri = null;
    private String objectUri = null;
    private String template = "addGrantRoleToPerson.ftl";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
        this.initProcessParameters(vreq, session, editConfiguration);
        editConfiguration.setN3Required(this.generateN3Required(vreq));
        editConfiguration.setN3Optional(this.generateN3Optional(vreq));
        editConfiguration.setNewResources(this.generateNewResources(vreq));
        this.setUrisAndLiteralsInScope(editConfiguration, vreq);
        this.setUrisAndLiteralsOnForm(editConfiguration, vreq);
        editConfiguration.setFilesOnForm(new ArrayList());
        this.setSparqlQueries(editConfiguration, vreq);
        this.setFields(editConfiguration, vreq, EditConfigurationUtils.getPredicateUri((VitroRequest)vreq));
        this.prepareForUpdate(vreq, session, editConfiguration);
        this.setTemplate(editConfiguration, vreq);
        this.setEditKey(editConfiguration, vreq);
        editConfiguration.addValidator((N3ValidatorVTwo)new DateTimeIntervalValidationVTwo("startField", "endField"));
        editConfiguration.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        editConfiguration.addValidator((N3ValidatorVTwo)new AutocompleteRequiredInputValidator("existingGrant", "grantLabel"));
        this.addFormSpecificData(editConfiguration, vreq);
        return editConfiguration;
    }

    private void setEditKey(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        String editKey = EditConfigurationUtils.getEditKey((VitroRequest)vreq);
        editConfiguration.setEditKey(editKey);
    }

    protected void setTemplate(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.setTemplate(this.template);
    }

    private void initProcessParameters(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        String formUrl = EditConfigurationUtils.getFormUrlWithoutContext((VitroRequest)vreq);
        this.subjectUri = EditConfigurationUtils.getSubjectUri((VitroRequest)vreq);
        this.predicateUri = EditConfigurationUtils.getPredicateUri((VitroRequest)vreq);
        editConfiguration.setFormUrl(formUrl);
        editConfiguration.setUrlPatternToReturnTo("/individual");
        editConfiguration.setVarNameForSubject("person");
        editConfiguration.setSubjectUri(this.subjectUri);
        editConfiguration.setEntityToReturnTo(this.subjectUri);
        editConfiguration.setVarNameForPredicate("rolePredicate");
        editConfiguration.setPredicateUri(this.predicateUri);
        this.objectUri = EditConfigurationUtils.getObjectUri((VitroRequest)vreq);
        this.processObjectPropForm(vreq, editConfiguration);
    }

    private void processObjectPropForm(VitroRequest vreq, EditConfigurationVTwo editConfiguration) {
        editConfiguration.setVarNameForObject("role");
        editConfiguration.setObject(this.objectUri);
    }

    private String getPrefixesString() {
        return "@prefix core: <http://vivoweb.org/ontology/core#> .";
    }

    private List<String> generateN3Required(VitroRequest vreq) {
        ArrayList<String> n3ForEdit = new ArrayList<String>();
        String editString = this.getN3ForGrantRole(vreq);
        n3ForEdit.add(editString);
        return n3ForEdit;
    }

    private List<String> generateN3Optional(VitroRequest vreq) {
        ArrayList<String> n3Optional = new ArrayList<String>();
        n3Optional.add(this.getN3ForNewGrant(vreq));
        n3Optional.add(this.getN3ForExistingGrant(vreq));
        n3Optional.add("?role ?inverseRolePredicate ?person .");
        n3Optional.addAll(this.getN3ForStart());
        n3Optional.addAll(this.getN3ForEnd());
        return n3Optional;
    }

    public String getN3ForGrantRole(VitroRequest vreq) {
        String editString = this.getPrefixesString();
        editString = editString + "?person ?rolePredicate ?role .";
        editString = editString + "?role a <" + this.getRoleType(vreq) + "> .";
        return editString;
    }

    public String getN3ForNewGrant(VitroRequest vreq) {
        String editString = this.getPrefixesString();
        editString = editString + "?role <" + this.getRoleToGrantPredicate(vreq) + "> ?grant .";
        editString = editString + "?grant a core:Grant . ";
        editString = editString + "?person core:relatedBy ?grant . ";
        editString = editString + "?grant core:relates ?person . ";
        editString = editString + "?grant <" + this.getGrantToRolePredicate(vreq) + "> ?role .";
        editString = editString + "?grant <" + RDFS.label.getURI() + "> ?grantLabel .";
        return editString;
    }

    public String getN3ForExistingGrant(VitroRequest vreq) {
        String editString = this.getPrefixesString();
        editString = editString + "?person core:relatedBy ?existingGrant . ";
        editString = editString + "?existingGrant core:relates ?person . ";
        editString = editString + "?role <" + this.getRoleToGrantPredicate(vreq) + "> ?existingGrant . ";
        editString = editString + "?existingGrant <" + this.getGrantToRolePredicate(vreq) + "> ?role .";
        return editString;
    }

    private List<String> getN3ForStart() {
        ArrayList<String> n3ForStart = new ArrayList<String>();
        n3ForStart.add("?role  <" + this.getRoleToIntervalURI() + "> ?intervalNode ." + "?intervalNode  <" + RDF.type.getURI() + "> <" + this.getIntervalTypeURI() + "> ." + "?intervalNode <" + this.getIntervalToStartURI() + "> ?startNode ." + "?startNode  <" + RDF.type.getURI() + "> <" + this.getDateTimeValueTypeURI() + "> ." + "?startNode  <" + this.getDateTimeValueURI() + "> ?startField-value ." + "?startNode  <" + this.getDateTimePrecisionURI() + "> ?startField-precision .");
        return n3ForStart;
    }

    private List<String> getN3ForEnd() {
        ArrayList<String> n3ForEnd = new ArrayList<String>();
        n3ForEnd.add("?role      <" + this.getRoleToIntervalURI() + "> ?intervalNode .  " + "?intervalNode  <" + RDF.type.getURI() + "> <" + this.getIntervalTypeURI() + "> ." + "?intervalNode <" + this.getIntervalToEndURI() + "> ?endNode ." + "?endNode  <" + RDF.type.getURI() + "> <" + this.getDateTimeValueTypeURI() + "> ." + "?endNode  <" + this.getDateTimeValueURI() + "> ?endField-value ." + "?endNode  <" + this.getDateTimePrecisionURI() + "> ?endField-precision .");
        return n3ForEnd;
    }

    private Map<String, String> generateNewResources(VitroRequest vreq) {
        HashMap<String, String> newResources = new HashMap<String, String>();
        String defaultNamespace = vreq.getWebappDaoFactory().getDefaultNamespace();
        newResources.put("role", defaultNamespace + "individual");
        newResources.put("grant", defaultNamespace + "individual");
        newResources.put("intervalNode", defaultNamespace + "individual");
        newResources.put("startNode", defaultNamespace + "individual");
        newResources.put("endNode", defaultNamespace + "individual");
        return newResources;
    }

    private void setUrisAndLiteralsInScope(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
        urisInScope.put(editConfiguration.getVarNameForSubject(), Arrays.asList(editConfiguration.getSubjectUri()));
        urisInScope.put(editConfiguration.getVarNameForPredicate(), Arrays.asList(editConfiguration.getPredicateUri()));
        urisInScope.put("roleType", Arrays.asList(this.getRoleType(vreq)));
        urisInScope.put("inverseRolePredicate", this.getInversePredicate(vreq));
        editConfiguration.setUrisInScope(urisInScope);
        editConfiguration.setLiteralsInScope(new HashMap());
    }

    private List<String> getInversePredicate(VitroRequest vreq) {
        ArrayList<String> inversePredicateArray = new ArrayList<String>();
        ObjectProperty op = EditConfigurationUtils.getObjectProperty((VitroRequest)vreq);
        if (op != null && op.getURIInverse() != null) {
            inversePredicateArray.add(op.getURIInverse());
        }
        return inversePredicateArray;
    }

    private void setUrisAndLiteralsOnForm(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        ArrayList<String> urisOnForm = new ArrayList<String>();
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        urisOnForm.add("grant");
        urisOnForm.add("existingGrant");
        editConfiguration.setUrisOnform(urisOnForm);
        literalsOnForm.add("grantLabel");
        literalsOnForm.add("grantLabelDisplay");
        editConfiguration.setLiteralsOnForm(literalsOnForm);
    }

    private void setSparqlQueries(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.setSparqlForAdditionalLiteralsInScope(new HashMap());
        HashMap urisInScope = new HashMap();
        editConfiguration.setSparqlForAdditionalUrisInScope(urisInScope);
        editConfiguration.setSparqlForExistingLiterals(this.generateSparqlForExistingLiterals(vreq));
        editConfiguration.setSparqlForExistingUris(this.generateSparqlForExistingUris(vreq));
    }

    private HashMap<String, String> generateSparqlForExistingUris(VitroRequest vreq) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("existingGrant", this.getExistingGrantQuery(vreq));
        map.put("intervalNode", this.getIntervalNodeQuery(vreq));
        map.put("startNode", this.getStartNodeQuery(vreq));
        map.put("endNode", this.getEndNodeQuery(vreq));
        map.put("startField-precision", this.getStartPrecisionQuery(vreq));
        map.put("endField-precision", this.getEndPrecisionQuery(vreq));
        return map;
    }

    private String getEndPrecisionQuery(VitroRequest vreq) {
        String query = "SELECT ?existingEndPrecision WHERE {?role <" + this.getRoleToIntervalURI() + "> ?intervalNode ." + "?intervalNode <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" + "> <" + this.getIntervalTypeURI() + "> ." + "?intervalNode <" + this.getIntervalToEndURI() + "> ?endNode ." + "?endNode <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" + "> <" + this.getDateTimeValueTypeURI() + "> .  " + "?endNode <" + this.getDateTimePrecisionURI() + "> ?existingEndPrecision . }";
        return query;
    }

    private String getStartPrecisionQuery(VitroRequest vreq) {
        String query = "SELECT ?existingStartPrecision WHERE {?role <" + this.getRoleToIntervalURI() + "> ?intervalNode ." + "?intervalNode <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" + "> <" + this.getIntervalTypeURI() + "> ." + "?intervalNode <" + this.getIntervalToStartURI() + "> ?startNode ." + "?startNode <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" + "> <" + this.getDateTimeValueTypeURI() + "> .  " + "?startNode <" + this.getDateTimePrecisionURI() + "> ?existingStartPrecision . }";
        return query;
    }

    private String getEndNodeQuery(VitroRequest vreq) {
        String query = "SELECT ?existingEndNode WHERE {?role <" + this.getRoleToIntervalURI() + "> ?intervalNode ." + "?intervalNode <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" + "> <" + this.getIntervalTypeURI() + "> ." + " ?intervalNode <" + this.getIntervalToEndURI() + "> ?existingEndNode . " + "?existingEndNode <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" + "> <" + this.getDateTimeValueTypeURI() + "> .}";
        return query;
    }

    private String getStartNodeQuery(VitroRequest vreq) {
        String query = "SELECT ?existingStartNode WHERE {?role <" + this.getRoleToIntervalURI() + "> ?intervalNode ." + "?intervalNode <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" + "> <" + this.getIntervalTypeURI() + "> ." + "?intervalNode <" + this.getIntervalToStartURI() + "> ?existingStartNode . " + "?existingStartNode <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" + "> <" + this.getDateTimeValueTypeURI() + "> .}";
        return query;
    }

    private String getIntervalNodeQuery(VitroRequest vreq) {
        String query = "SELECT ?existingIntervalNode WHERE { ?role <" + this.getRoleToIntervalURI() + "> ?existingIntervalNode . " + " ?existingIntervalNode <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" + "> <" + this.getIntervalTypeURI() + "> . }";
        return query;
    }

    private HashMap<String, String> generateSparqlForExistingLiterals(VitroRequest vreq) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("grantLabel", this.getGrantLabelQuery(vreq));
        map.put("startField-value", this.getExistingStartDateQuery(vreq));
        map.put("endField-value", this.getExistingEndDateQuery(vreq));
        return map;
    }

    private String getGrantLabelQuery(VitroRequest vreq) {
        String query = "PREFIX core: <" + this.getVivoCoreNamespace() + ">" + "PREFIX rdfs: <" + RDFS.getURI() + "> \n";
        String roleToGrantPredicate = this.getRoleToGrantPredicate(vreq);
        query = query + "SELECT ?existingGrantLabel WHERE { \n?role  <" + roleToGrantPredicate + "> ?existingGrant . \n" + "?existingGrant rdfs:label ?existingGrantLabel . }";
        return query;
    }

    private String getExistingGrantQuery(VitroRequest vreq) {
        String query = "PREFIX core: <" + this.getVivoCoreNamespace() + ">" + "PREFIX rdfs: <" + RDFS.getURI() + "> \n";
        String roleToGrantPredicate = this.getRoleToGrantPredicate(vreq);
        query = query + "SELECT ?existingGrant WHERE { \n?role  <" + roleToGrantPredicate + "> ?existingGrant .  }";
        return query;
    }

    private String getExistingEndDateQuery(VitroRequest vreq) {
        String query = " SELECT ?existingEndDate WHERE {\n?role <" + this.getRoleToIntervalURI() + "> ?intervalNode .\n" + "?intervalNode <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" + "> <" + this.getIntervalTypeURI() + "> .\n" + "?intervalNode <" + this.getIntervalToEndURI() + "> ?endNode .\n" + "?endNode <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" + "> <" + this.getDateTimeValueTypeURI() + "> .\n" + "?endNode <" + this.getDateTimeValueURI() + "> ?existingEndDate . }";
        return query;
    }

    private String getExistingStartDateQuery(VitroRequest vreq) {
        String query = "SELECT ?existingDateStart WHERE {\n?role <" + this.getRoleToIntervalURI() + "> ?intervalNode .\n" + "?intervalNode <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" + "> <" + this.getIntervalTypeURI() + "> .\n" + "?intervalNode <" + this.getIntervalToStartURI() + "> ?startNode .\n" + "?startNode <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" + "> <" + this.getDateTimeValueTypeURI() + "> .\n" + "?startNode <" + this.getDateTimeValueURI() + "> ?existingDateStart . }";
        return query;
    }

    private void setFields(EditConfigurationVTwo editConfiguration, VitroRequest vreq, String predicateUri) {
        HashMap<String, FieldVTwo> fields = new HashMap<String, FieldVTwo>();
        this.getGrantField(editConfiguration, vreq, fields);
        this.getGrantLabelField(editConfiguration, vreq, fields);
        this.getGrantLabelDisplayField(editConfiguration, vreq, fields);
        this.getExistingGrantField(editConfiguration, vreq, fields);
        this.getStartField(editConfiguration, vreq, fields);
        this.getEndField(editConfiguration, vreq, fields);
        editConfiguration.setFields(fields);
    }

    private void getGrantField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) {
        String fieldName = "grant";
        FieldVTwo field = new FieldVTwo();
        field.setName(fieldName);
        ArrayList validators = new ArrayList();
        field.setValidators(validators);
        fields.put(field.getName(), field);
    }

    private void getGrantLabelField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) {
        String fieldName = "grantLabel";
        String stringDatatypeUri = XSD.xstring.toString();
        FieldVTwo field = new FieldVTwo();
        field.setName(fieldName);
        ArrayList<String> validators = new ArrayList<String>();
        validators.add("datatype:" + stringDatatypeUri);
        field.setValidators(validators);
        fields.put(field.getName(), field);
    }

    private void getGrantLabelDisplayField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) {
        FieldVTwo field = new FieldVTwo();
        String fieldName = "grantLabelDisplay";
        field.setName(fieldName);
        String stringDatatypeUri = XSD.xstring.toString();
        field.setRangeDatatypeUri(null);
        fields.put(field.getName(), field);
    }

    private void getExistingGrantField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) {
        String fieldName = "existingGrant";
        FieldVTwo field = new FieldVTwo();
        field.setName(fieldName);
        fields.put(field.getName(), field);
    }

    private void getStartField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) {
        String fieldName = "startField";
        FieldVTwo field = new FieldVTwo();
        field.setName(fieldName);
        field.setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(field, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri()));
        fields.put(field.getName(), field);
    }

    private void getEndField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) {
        String fieldName = "endField";
        FieldVTwo field = new FieldVTwo();
        field.setName(fieldName);
        ArrayList validators = new ArrayList();
        field.setValidators(validators);
        field.setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(field, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri()));
        fields.put(field.getName(), field);
    }

    private void prepareForUpdate(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        OntModel model = ModelAccess.on((ServletContext)session.getServletContext()).getOntModel();
        String objectUri = EditConfigurationUtils.getObjectUri((VitroRequest)vreq);
        if (objectUri != null) {
            editConfiguration.prepareForObjPropUpdate((Model)model);
        } else {
            editConfiguration.prepareForNonUpdate((Model)model);
        }
    }

    public FrontEndEditingUtils.EditMode getEditMode(VitroRequest vreq) {
        List<String> roleToGrantPredicates = this.getPossibleRoleToGrantPredicates();
        return EditModeUtils.getEditMode((VitroRequest)vreq, roleToGrantPredicates);
    }

    private boolean isAddMode(VitroRequest vreq) {
        return EditModeUtils.isAddMode((FrontEndEditingUtils.EditMode)this.getEditMode(vreq));
    }

    private boolean isEditMode(VitroRequest vreq) {
        return EditModeUtils.isEditMode((FrontEndEditingUtils.EditMode)this.getEditMode(vreq));
    }

    private boolean isRepairMode(VitroRequest vreq) {
        return EditModeUtils.isRepairMode((FrontEndEditingUtils.EditMode)this.getEditMode(vreq));
    }

    public String getRoleType(VitroRequest vreq) {
        String rangeUri = EditConfigurationUtils.getRangeUri((VitroRequest)vreq);
        if (rangeUri.equals(this.getPrincipalInvestigatorURI())) {
            return this.getVivoOntologyCoreNamespace() + "PrincipalInvestigatorRole";
        }
        if (rangeUri.equals(this.getCoPrincipalInvestigatorURI())) {
            return this.getVivoOntologyCoreNamespace() + "CoPrincipalInvestigatorRole";
        }
        return this.getVivoOntologyCoreNamespace() + "InvestigatorRole";
    }

    private Object getCoPrincipalInvestigatorURI() {
        return this.getVivoOntologyCoreNamespace() + "CoPrincipalInvestigatorRole";
    }

    private String getVivoOntologyCoreNamespace() {
        return "http://vivoweb.org/ontology/core#";
    }

    private Object getPrincipalInvestigatorURI() {
        return this.getVivoOntologyCoreNamespace() + "PrincipalInvestigatorRole";
    }

    public boolean isShowRoleLabelField(VitroRequest vreq) {
        return true;
    }

    public String getRoleToGrantPredicate(VitroRequest vreq) {
        ObjectProperty predicate = ModelUtils.getPropertyForRoleInClass(this.getGrantType(), vreq.getWebappDaoFactory());
        return predicate.getURI();
    }

    public String getGrantToRolePredicate(VitroRequest vreq) {
        ObjectProperty predicate = ModelUtils.getPropertyForRoleInClass(this.getGrantType(), vreq.getWebappDaoFactory());
        return predicate.getURIInverse();
    }

    public String getGrantType() {
        return "http://vivoweb.org/ontology/core#Grant";
    }

    public String getDefaultgrantToRolePredicate() {
        return "http://vivoweb.org/ontology/core#relates";
    }

    public String getDefaultroleToGrantPredicate() {
        return "http://purl.obolibrary.org/obo/BFO_0000054";
    }

    public List<String> getPossibleRoleToGrantPredicates() {
        return ModelUtils.getPossiblePropertiesForRole();
    }

    public List<String> getPossibleGrantToRolePredicates() {
        return ModelUtils.getPossibleInversePropertiesForRole();
    }

    public String getVivoCoreNamespace() {
        return "http://vivoweb.org/ontology/core#";
    }

    public String getRoleToIntervalURI() {
        return this.getVivoCoreNamespace() + "dateTimeInterval";
    }

    public String getIntervalTypeURI() {
        return this.getVivoCoreNamespace() + "DateTimeInterval";
    }

    public String getIntervalToStartURI() {
        return this.getVivoCoreNamespace() + "start";
    }

    public String getIntervalToEndURI() {
        return this.getVivoCoreNamespace() + "end";
    }

    public String getStartYearPredURI() {
        return this.getVivoCoreNamespace() + "startYear";
    }

    public String getEndYearPredURI() {
        return this.getVivoCoreNamespace() + "endYear";
    }

    public String getDateTimeValueTypeURI() {
        return this.getVivoCoreNamespace() + "DateTimeValue";
    }

    public String getDateTimePrecisionURI() {
        return this.getVivoCoreNamespace() + "dateTimePrecision";
    }

    public String getDateTimeValueURI() {
        return this.getVivoCoreNamespace() + "dateTime";
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, String> formSpecificData = new HashMap<String, String>();
        formSpecificData.put("editMode", this.getEditMode(vreq).name().toLowerCase());
        formSpecificData.put("rangeUri", this.getRangeUri(vreq));
        formSpecificData.put("sparqlForAcFilter", this.getSparqlForAcFilter(vreq));
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    public String getSparqlForAcFilter(VitroRequest vreq) {
        String subject = EditConfigurationUtils.getSubjectUri((VitroRequest)vreq);
        String predicate = EditConfigurationUtils.getPredicateUri((VitroRequest)vreq);
        String query = "PREFIX core:<" + this.getVivoCoreNamespace() + "> " + "SELECT ?grantUri WHERE { " + "<" + subject + "> <" + predicate + "> ?grantRole ." + "?grantRole <" + this.getRoleToGrantPredicate(vreq) + "> ?grantUri . }";
        return query;
    }

    private String getRangeUri(VitroRequest vreq) {
        String rangeUri = vreq.getParameter("rangeUri");
        return rangeUri;
    }

    public static enum RoleActivityOptionTypes {
        VCLASSGROUP,
        CHILD_VCLASSES,
        HARDCODED_LITERALS;

    }
}

