/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.vocabulary.XSD;

public class PersonHasPreferredTitleGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    private Log log = LogFactory.getLog(PersonHasPreferredTitleGenerator.class);
    static final String n3ForNewPhone = "?person <http://purl.obolibrary.org/obo/ARG_2000028>  ?individualVcard . \n?individualVcard a <http://www.w3.org/2006/vcard/ns#Individual> . \n?individualVcard <http://purl.obolibrary.org/obo/ARG_2000029> ?person . \n?individualVcard <http://www.w3.org/2006/vcard/ns#hasTitle> ?title . \n?title a <http://www.w3.org/2006/vcard/ns#Title> . ";
    static final String preferredTitleAssertion = "?title <http://www.w3.org/2006/vcard/ns#title> ?preferredTitle .";
    static final String individualVcardQuery = "SELECT ?existingIndividualVcard WHERE { \n?person <http://purl.obolibrary.org/obo/ARG_2000028>  ?existingIndividualVcard . \n}";
    static final String preferredTitleQuery = "SELECT ?existingPreferredTitle WHERE {\n?title <http://www.w3.org/2006/vcard/ns#title> ?existingPreferredTitle . }";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        String titleUri = this.getTitleUri(vreq);
        conf.setTemplate("personHasPreferredTitle.ftl");
        conf.setVarNameForSubject("person");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("individualVcard");
        conf.setN3Required(Arrays.asList(n3ForNewPhone));
        conf.setN3Optional(Arrays.asList(preferredTitleAssertion));
        conf.addNewResource("title", "");
        conf.addNewResource("individualVcard", "");
        conf.setLiteralsOnForm(Arrays.asList("preferredTitle"));
        conf.addSparqlForExistingLiteral("preferredTitle", preferredTitleQuery);
        conf.addSparqlForAdditionalUrisInScope("individualVcard", individualVcardQuery);
        if (conf.isUpdate()) {
            HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
            urisInScope.put("title", Arrays.asList(titleUri));
            conf.addUrisInScope(urisInScope);
        }
        conf.addField(new FieldVTwo().setName("preferredTitle").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasPreferredTitleGenerator.list((Object[])new Object[]{"nonempty"})));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        this.prepare(vreq, conf);
        return conf;
    }

    private String getTitleUri(VitroRequest vreq) {
        String titleUri = vreq.getParameter("titleUri");
        return titleUri;
    }
}

