/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.BaseEditSubmissionPreprocessorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.json.JacksonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

public class AddAssociatedConceptsPreprocessor
extends BaseEditSubmissionPreprocessorVTwo {
    protected static final Log log = LogFactory.getLog((String)AddAssociatedConceptsPreprocessor.class.getName());
    protected OntModel ontModel = null;
    protected WebappDaoFactory wdf = null;
    private static String conceptNodeBase = "conceptNode";
    private static String sourceBase = "conceptSource";
    private static String labelBase = "conceptLabel";
    private static String conceptSemanticTypeLabelBase = "conceptSemanticTypeLabel";
    private static String conceptSemanticTypeURIBase = "conceptSemanticTypeURI";
    private static String conceptBroaderURIBase = "conceptBroaderURI";
    private static String conceptNarrowerURIBase = "conceptNarrowerURI";
    private HashMap<String, String> labelVarToUriVarHash = new HashMap();
    private HashMap<String, List<String>> conceptSemanticTypeURIVarToValueMap = new HashMap();
    private static String conceptNodeValues = null;
    private static String conceptLabelValues = null;
    private static String conceptSourceValues = null;
    private static String conceptSemanticTypeLabelValues = null;
    private static String conceptSemanticTypeURIValues = null;
    private static List<String> conceptBroaderURIValues = null;
    private static List<String> conceptNarrowerURIValues = null;
    private static MultiValueEditSubmission submission = null;
    private static String SKOSBroaderURI = "http://www.w3.org/2004/02/skos/core#broader";
    private static String SKOSNarrowerURI = "http://www.w3.org/2004/02/skos/core#narrower";
    private static String SKOSConceptType = "http://www.w3.org/2004/02/skos/core#Concept";

    public AddAssociatedConceptsPreprocessor(EditConfigurationVTwo editConfig) {
        super(editConfig);
    }

    public void preprocess(MultiValueEditSubmission inputSubmission, VitroRequest vreq) {
        submission = inputSubmission;
        this.wdf = vreq.getWebappDaoFactory();
        this.ontModel = ModelAccess.on((HttpServletRequest)vreq).getOntModel(new ModelAccess.LanguageOption[0]);
        this.copySubmissionValues();
        if (conceptNodeValues != null) {
            String[] conceptNodes = this.convertDelimitedStringToArray(conceptNodeValues);
            int numberConcepts = conceptNodes.length;
            this.processConceptSemanticValues();
            this.getExistingConceptRelationships();
            if (numberConcepts > 1) {
                this.processConceptNodes(numberConcepts);
            }
        } else {
            log.error((Object)"No concept nodes were added from the service");
        }
    }

    private void copySubmissionValues() {
        conceptLabelValues = this.getConceptLabelValues();
        conceptNodeValues = this.getConceptNodeValues();
        conceptSourceValues = this.getConceptSourceValues();
        conceptBroaderURIValues = this.getConceptBroaderURIValues();
        conceptNarrowerURIValues = this.getConceptNarrowerURIValues();
        log.debug((Object)("concept label values are " + conceptLabelValues));
    }

    private void getExistingConceptRelationships() {
        List<String> existingNarrowerURIs = this.getExistingNarrowerURIs(conceptNarrowerURIValues);
        List<String> existingBroaderURIs = this.getExistingBroaderURIs(conceptBroaderURIValues);
        Map urisFromForm = submission.getUrisFromForm();
        if (existingNarrowerURIs.size() > 0) {
            urisFromForm.put("conceptNarrowerURI", existingNarrowerURIs);
        } else {
            urisFromForm.remove("conceptNarrowerURI");
        }
        conceptNarrowerURIValues = existingNarrowerURIs;
        if (existingBroaderURIs.size() > 0) {
            urisFromForm.put("conceptBroaderURI", existingBroaderURIs);
        } else {
            urisFromForm.remove("conceptBroaderURI");
        }
        conceptBroaderURIValues = existingBroaderURIs;
    }

    private List<String> getConceptNarrowerURIValues() {
        return this.getJSONFormURIValues("conceptNarrowerURI");
    }

    private List<String> getConceptBroaderURIValues() {
        return this.getJSONFormURIValues("conceptBroaderURI");
    }

    private List<String> getJSONFormURIValues(String varName) {
        JsonNode json;
        String jsonString;
        Map urisFromForm = submission.getUrisFromForm();
        List uris = (List)urisFromForm.get(varName);
        if (uris.size() > 0 && (jsonString = (String)uris.get(0)) != null && !jsonString.isEmpty() && (json = JacksonUtils.parseJson((String)jsonString)).isArray()) {
            ArrayNode jsonArray = (ArrayNode)JacksonUtils.parseJson((String)jsonString);
            return this.convertJsonArrayToList(jsonArray);
        }
        return uris;
    }

    private List<String> convertJsonArrayToList(ArrayNode jsonArray) {
        ArrayList<String> stringList = new ArrayList<String>();
        int len = jsonArray.size();
        int i = 0;
        for (i = 0; i < len; ++i) {
            stringList.add(jsonArray.get(i).asText());
        }
        return stringList;
    }

    private List<String> getExistingBroaderURIs(List<String> broaderURIs) {
        if (broaderURIs == null) {
            return new ArrayList<String>();
        }
        List<String> existingBroaderURIs = this.getExistingURIs(broaderURIs);
        return existingBroaderURIs;
    }

    private List<String> getExistingNarrowerURIs(List<String> narrowerURIs) {
        if (narrowerURIs == null) {
            return new ArrayList<String>();
        }
        List<String> existingNarrowerURIs = this.getExistingURIs(narrowerURIs);
        return existingNarrowerURIs;
    }

    private List<String> getExistingURIs(List<String> uris) {
        ArrayList<String> existingURIs = new ArrayList<String>();
        for (String uri : uris) {
            if (uri.indexOf(",") != -1) {
                String[] uriSet;
                ArrayList<String> existingURISet = new ArrayList<String>();
                for (String u : uriSet = uri.split(",")) {
                    if (u == null || u.isEmpty() || !this.wdf.hasExistingURI(u)) continue;
                    existingURISet.add(u);
                }
                if (existingURISet.size() > 0) {
                    existingURIs.add(StringUtils.join(existingURISet, (String)","));
                    continue;
                }
                existingURIs.add("");
                continue;
            }
            if (uri != null && !uri.isEmpty() && this.wdf.hasExistingURI(uri)) {
                existingURIs.add(uri);
                continue;
            }
            existingURIs.add("");
        }
        return existingURIs;
    }

    private void processConceptSemanticValues() {
        conceptSemanticTypeLabelValues = this.getConceptSemanticTypeLabelValues();
        conceptSemanticTypeURIValues = this.getConceptSemanticTypeURIValues();
    }

    private void processConceptNodes(int numberConcepts) {
        this.addNewResources(numberConcepts);
        this.addN3Required(numberConcepts);
        this.addN3Optional(numberConcepts);
        this.addLiteralsAndUrisOnForm(numberConcepts);
        this.addFields(numberConcepts);
        this.addInputsToSubmission(numberConcepts);
    }

    private void addNewResources(int numberConcepts) {
        this.addConceptSemanticTypeURIResources(numberConcepts);
    }

    private void addConceptSemanticTypeURIResources(int numberConcepts) {
        HashSet<String> urisToAdd = new HashSet<String>();
        String[] conceptSemanticTypeLabels = this.convertDelimitedStringToArray(conceptSemanticTypeLabelValues);
        if (conceptSemanticTypeLabels != null && conceptSemanticTypeLabels.length <= numberConcepts) {
            for (int i = 0; i < numberConcepts; ++i) {
                String newResourceName;
                int suffix = i + 1;
                String conceptSemanticTypeLabelVar = conceptSemanticTypeLabelBase + suffix;
                if (!this.labelVarToUriVarHash.containsKey(conceptSemanticTypeLabelVar) || urisToAdd.contains(newResourceName = this.labelVarToUriVarHash.get(conceptSemanticTypeLabelVar))) continue;
                urisToAdd.add(newResourceName);
                this.editConfiguration.addNewResource(newResourceName, null);
            }
        } else if (conceptSemanticTypeLabels != null && conceptSemanticTypeLabels.length > numberConcepts) {
            log.error((Object)"Number of concept semantic type labels is greater than number of concepts");
        } else {
            log.error((Object)"Concept semantic type labels returned are null");
        }
    }

    private void addInputsToSubmission(int numberConcepts) {
        this.addConceptNodeInputs(numberConcepts);
        this.addConceptSourceInputs(numberConcepts);
        this.addConceptLabelInputs(numberConcepts);
        this.addConceptSemanticTypeLabelAndURIInputs(numberConcepts);
        this.addConceptBroaderURIInputs(numberConcepts);
        this.addConceptNarrowerURIInputs(numberConcepts);
    }

    private void addConceptNodeInputs(int numberConcepts) {
        String[] conceptNodes = this.convertDelimitedStringToArray(conceptNodeValues);
        if (conceptNodes != null && conceptNodes.length == numberConcepts) {
            for (int i = 0; i < numberConcepts; ++i) {
                int suffix = i + 1;
                String conceptInputName = conceptNodeBase + suffix;
                String[] nodeValues = new String[]{conceptNodes[i]};
                submission.addUriToForm(this.editConfiguration, conceptInputName, nodeValues);
            }
        } else if (conceptNodes != null && conceptNodes.length != numberConcepts) {
            log.error((Object)"Number of concept nodes did not match the number of concepts to be added");
        } else {
            log.error((Object)"Concept nodes returned were null");
        }
    }

    private void addConceptSourceInputs(int numberConcepts) {
        String[] conceptSources = this.convertDelimitedStringToArray(conceptSourceValues);
        if (conceptSources != null && conceptSources.length == numberConcepts) {
            for (int i = 0; i < numberConcepts; ++i) {
                int suffix = i + 1;
                String conceptInputName = sourceBase + suffix;
                String[] sourceValues = new String[]{conceptSources[i]};
                submission.addUriToForm(this.editConfiguration, conceptInputName, sourceValues);
            }
        } else if (conceptSources != null && conceptSources.length != numberConcepts) {
            log.error((Object)"Number of concept nodes did not match the number of concepts to be added");
        } else {
            log.error((Object)"Concept nodes returned were null");
        }
    }

    private void addConceptLabelInputs(int numberConcepts) {
        String[] labels = this.convertDelimitedStringToArray(conceptLabelValues);
        if (labels != null && labels.length == numberConcepts) {
            for (int i = 0; i < numberConcepts; ++i) {
                int suffix = i + 1;
                String labelInputName = labelBase + suffix;
                String[] labelValues = new String[]{labels[i]};
                FieldVTwo labelField = this.editConfiguration.getField(labelInputName);
                if (labelField != null) {
                    submission.addLiteralToForm(this.editConfiguration, labelField, labelInputName, labelValues);
                    continue;
                }
                log.error((Object)("Corresponding field for " + labelInputName + " was not added to edit configuration"));
            }
        } else if (labels != null && labels.length != numberConcepts) {
            log.error((Object)"Number of concept labels did not match the number of concepts to be added");
        } else {
            log.error((Object)"Concept labels returned were null");
        }
    }

    private void addConceptSemanticTypeLabelAndURIInputs(int numberConcepts) {
        String[] labels = this.convertDelimitedStringToArray(conceptSemanticTypeLabelValues);
        HashSet<String> uniqueLabelValues = new HashSet<String>();
        if (labels != null && labels.length == numberConcepts) {
            for (int i = 0; i < numberConcepts; ++i) {
                String thisLabel = labels[i];
                int suffix = i + 1;
                String labelInputName = conceptSemanticTypeLabelBase + suffix;
                String[] labelValues = new String[]{thisLabel};
                FieldVTwo labelField = this.editConfiguration.getField(labelInputName);
                if (labelField != null) {
                    submission.addLiteralToForm(this.editConfiguration, labelField, labelInputName, labelValues);
                    if (uniqueLabelValues.contains(thisLabel)) continue;
                    uniqueLabelValues.add(thisLabel);
                    this.addConceptSemanticTypeURIInputForLabel(labelInputName, suffix);
                    continue;
                }
                log.error((Object)("Corresponding field for " + labelInputName + " was not added to edit configuration"));
            }
        } else if (labels != null && labels.length != numberConcepts) {
            log.error((Object)"Number of concept semantic type labels did not match the number of concepts to be added");
        } else {
            log.error((Object)"Concept labels returned were null");
        }
    }

    private void addConceptSemanticTypeURIInputForLabel(String conceptSemanticTypeLabel, int suffix) {
        String uriInputName = this.getConceptSemanticTypeURIFieldName(conceptSemanticTypeLabel, suffix);
        if (this.conceptSemanticTypeURIVarToValueMap.containsKey(uriInputName)) {
            List<String> uriVals = this.conceptSemanticTypeURIVarToValueMap.get(uriInputName);
            String[] uriValuesArray = uriVals.toArray(new String[uriVals.size()]);
            submission.addUriToForm(this.editConfiguration, uriInputName, uriValuesArray);
        }
    }

    private void addConceptBroaderURIInputs(int numberConcepts) {
        if (conceptBroaderURIValues.size() > 0) {
            if (conceptBroaderURIValues.size() <= numberConcepts) {
                for (int i = 0; i < numberConcepts; ++i) {
                    int suffix = i + 1;
                    String conceptBroaderURIInputName = conceptBroaderURIBase + suffix;
                    String broaderURIs = conceptBroaderURIValues.get(i);
                    if (broaderURIs == null || broaderURIs.isEmpty()) continue;
                    String[] broaderURISet = new String[1];
                    if (broaderURIs.indexOf(",") != -1) {
                        broaderURISet = broaderURIs.split(",");
                    } else {
                        broaderURISet[0] = broaderURIs;
                    }
                    submission.addUriToForm(this.editConfiguration, conceptBroaderURIInputName, broaderURISet);
                }
            }
        }
    }

    private void addConceptNarrowerURIInputs(int numberConcepts) {
        if (conceptNarrowerURIValues.size() > 0) {
            if (conceptNarrowerURIValues.size() <= numberConcepts) {
                for (int i = 0; i < numberConcepts; ++i) {
                    int suffix = i + 1;
                    String conceptNarrowerURIInputName = conceptNarrowerURIBase + suffix;
                    String narrowerURIs = conceptNarrowerURIValues.get(i);
                    if (narrowerURIs == null || narrowerURIs.isEmpty()) continue;
                    String[] narrowerURISet = new String[1];
                    if (narrowerURIs.indexOf(",") != -1) {
                        narrowerURISet = narrowerURIs.split(",");
                    } else {
                        narrowerURISet[0] = narrowerURIs;
                    }
                    submission.addUriToForm(this.editConfiguration, conceptNarrowerURIInputName, narrowerURISet);
                }
            }
        }
    }

    private void addFields(int numberConcepts) {
        this.editConfiguration.setFields(new HashMap());
        HashSet<String> conceptSemanticTypeUris = new HashSet<String>();
        for (int index = 1; index <= numberConcepts; ++index) {
            int suffix = index;
            String conceptNode = conceptNodeBase + suffix;
            String label = labelBase + suffix;
            String source = sourceBase + suffix;
            String conceptSemanticTypeLabel = conceptSemanticTypeLabelBase + suffix;
            String conceptSemanticTypeURI = this.getConceptSemanticTypeURIFieldName(conceptSemanticTypeLabel, suffix);
            String conceptBroaderURI = conceptBroaderURIBase + suffix;
            String conceptNarrowerURI = conceptNarrowerURIBase + suffix;
            this.addConceptNodeField(conceptNode);
            this.addLabelField(label);
            this.addSourceField(source);
            this.addConceptSemanticTypeLabelField(conceptSemanticTypeLabel);
            if (!conceptSemanticTypeUris.contains(conceptSemanticTypeURI)) {
                conceptSemanticTypeUris.add(conceptSemanticTypeURI);
                this.addConceptSemanticTypeURIField(conceptSemanticTypeURI);
            }
            this.addConceptBroaderURIField(conceptBroaderURI);
            this.addConceptNarrowerURIField(conceptNarrowerURI);
        }
    }

    private void addConceptNodeField(String conceptNode) {
        ArrayList<String> validators = new ArrayList<String>();
        validators.add("nonempty");
        this.editConfiguration.addField(new FieldVTwo().setName(conceptNode).setValidators(validators));
    }

    private void addLabelField(String label) {
        this.editConfiguration.addField(new FieldVTwo().setName(label).setRangeDatatypeUri(XSD.xstring.toString()));
    }

    private void addSourceField(String source) {
        this.editConfiguration.addField(new FieldVTwo().setName(source));
    }

    private void addConceptSemanticTypeLabelField(String label) {
        if (label != null) {
            this.editConfiguration.addField(new FieldVTwo().setName(label).setRangeDatatypeUri(XSD.xstring.toString()));
        }
    }

    private void addConceptSemanticTypeURIField(String conceptSemanticTypeURI) {
        if (conceptSemanticTypeURI != null) {
            this.editConfiguration.addField(new FieldVTwo().setName(conceptSemanticTypeURI));
        }
    }

    private void addConceptNarrowerURIField(String conceptNarrowerURI) {
        this.editConfiguration.addField(new FieldVTwo().setName(conceptNarrowerURI));
    }

    private void addConceptBroaderURIField(String conceptBroaderURI) {
        this.editConfiguration.addField(new FieldVTwo().setName(conceptBroaderURI));
    }

    private void addLiteralsAndUrisOnForm(int numberTerms) {
        ArrayList<String> urisOnForm = new ArrayList<String>();
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        HashSet<String> conceptSemanticTypeURIs = new HashSet<String>();
        for (int index = 1; index <= numberTerms; ++index) {
            int suffix = index;
            String conceptNode = conceptNodeBase + suffix;
            String label = labelBase + suffix;
            String source = sourceBase + suffix;
            String conceptSemanticTypeLabel = conceptSemanticTypeLabelBase + suffix;
            String conceptSemanticTypeURI = this.getConceptSemanticTypeURIFieldName(conceptSemanticTypeLabel, suffix);
            String conceptBroaderURI = conceptBroaderURIBase + suffix;
            String conceptNarrowerURI = conceptNarrowerURIBase + suffix;
            urisOnForm.add(conceptNode);
            urisOnForm.add(source);
            if (!conceptSemanticTypeURIs.contains(conceptSemanticTypeURI)) {
                conceptSemanticTypeURIs.add(conceptSemanticTypeURI);
                urisOnForm.add(conceptSemanticTypeURI);
            }
            urisOnForm.add(conceptBroaderURI);
            urisOnForm.add(conceptNarrowerURI);
            literalsOnForm.add(label);
            literalsOnForm.add(conceptSemanticTypeLabel);
        }
        this.editConfiguration.setUrisOnform(urisOnForm);
        this.editConfiguration.setLiteralsOnForm(literalsOnForm);
    }

    private void addN3Required(int numberConcepts) {
        ArrayList<String> n3Required = new ArrayList<String>();
        String nodeBase = "?" + conceptNodeBase;
        String prefixStr = "@prefix core: <http://vivoweb.org/ontology/core#> .";
        int index = 1;
        while (index <= numberConcepts) {
            int suffix = index++;
            String node = nodeBase + suffix;
            String n3String = prefixStr;
            n3String = n3String + "?subject ?predicate " + node + " . \n" + node + " <" + RDF.type.getURI() + "> <" + SKOSConceptType + "> .";
            n3Required.add(n3String);
        }
        this.editConfiguration.setN3Required(n3Required);
    }

    private void addN3Optional(int numberConcepts) {
        ArrayList<String> n3Optional = new ArrayList<String>();
        String nodeBase = "?" + conceptNodeBase;
        String labelVar = "?" + labelBase;
        String sourceVar = "?" + sourceBase;
        String conceptSemanticTypeLabelVar = "?" + conceptSemanticTypeLabelBase;
        String conceptBroaderURIVar = "?" + conceptBroaderURIBase;
        String conceptNarrowerURIVar = "?" + conceptNarrowerURIBase;
        String prefixStr = "@prefix core: <http://vivoweb.org/ontology/core#> .";
        int index = 1;
        while (index <= numberConcepts) {
            int suffix = index++;
            String node = nodeBase + suffix;
            String label = labelVar + suffix;
            String source = sourceVar + suffix;
            String conceptSemanticTypeLabel = conceptSemanticTypeLabelVar + suffix;
            String conceptSemanticTypeURI = this.getConceptSemanticTypeURIVar(conceptSemanticTypeLabelBase + suffix, suffix);
            String conceptBroaderURI = conceptBroaderURIVar + suffix;
            String conceptNarrowerURI = conceptNarrowerURIVar + suffix;
            String n3String = prefixStr;
            n3String = n3String + node + " <" + RDFS.label.getURI() + "> " + label + " .\n" + node + " <" + RDFS.isDefinedBy.getURI() + "> " + source + " .";
            String n3ConceptTypeString = prefixStr;
            n3ConceptTypeString = n3ConceptTypeString + node + " <" + RDF.type.getURI() + "> " + conceptSemanticTypeURI + " ." + conceptSemanticTypeURI + " <" + RDFS.label.getURI() + "> " + conceptSemanticTypeLabel + " .\n" + conceptSemanticTypeURI + " <" + RDFS.subClassOf.getURI() + "> <http://www.w3.org/2004/02/skos/core#Concept> .\n";
            String n3ConceptBroaderURI = prefixStr + node + " <" + SKOSNarrowerURI + "> " + conceptNarrowerURI + " ." + conceptNarrowerURI + " <" + SKOSBroaderURI + "> " + node + " .";
            String n3ConceptNarrowerURI = prefixStr + node + " <" + SKOSBroaderURI + "> " + conceptBroaderURI + " ." + conceptBroaderURI + " <" + SKOSNarrowerURI + "> " + node + " .";
            n3Optional.add(n3String);
            n3Optional.add(n3ConceptTypeString);
            n3Optional.add(n3ConceptBroaderURI);
            n3Optional.add(n3ConceptNarrowerURI);
        }
        this.editConfiguration.setN3Optional(n3Optional);
    }

    private String getConceptSemanticTypeURIVar(String labelVar, int suffix) {
        return "?" + this.getConceptSemanticTypeURIFieldName(labelVar, suffix);
    }

    private String getConceptSemanticTypeURIFieldName(String labelVar, int suffix) {
        if (this.labelVarToUriVarHash.containsKey(labelVar)) {
            return this.labelVarToUriVarHash.get(labelVar);
        }
        return conceptSemanticTypeURIBase + suffix;
    }

    private String[] convertDelimitedStringToArray(String inputString) {
        String[] inputArray = new String[1];
        if (inputString.indexOf(",") != -1) {
            inputArray = inputString.split(",");
        } else {
            inputArray[0] = inputString;
        }
        return inputArray;
    }

    private String getConceptNodeValues() {
        Map urisFromForm = submission.getUrisFromForm();
        List conceptNodes = (List)urisFromForm.get("conceptNode");
        return (String)this.getFirstElement(conceptNodes);
    }

    private String getConceptSourceValues() {
        Map urisFromForm = submission.getUrisFromForm();
        return (String)this.getFirstElement((List)urisFromForm.get("conceptSource"));
    }

    private String getConceptLabelValues() {
        Map literalsFromForm = submission.getLiteralsFromForm();
        Map transformed = EditConfigurationUtils.transformLiteralMap((Map)literalsFromForm);
        return (String)this.getFirstElement((List)transformed.get("conceptLabel"));
    }

    private String getConceptSemanticTypeLabelValues() {
        Map literalsFromForm = submission.getLiteralsFromForm();
        Map transformed = EditConfigurationUtils.transformLiteralMap((Map)literalsFromForm);
        String label = (String)this.getFirstElement((List)transformed.get("conceptSemanticTypeLabel"));
        if (label == null) {
            label = "";
        }
        return label;
    }

    private String getConceptSemanticTypeURIValues() {
        String pseudoInputString = "";
        if (conceptSemanticTypeLabelValues != null && !conceptSemanticTypeLabelValues.isEmpty()) {
            String[] conceptSemanticTypeLabels = this.convertDelimitedStringToArray(conceptSemanticTypeLabelValues);
            HashMap labelValueToVarSuffix = new HashMap();
            int numberLabels = conceptSemanticTypeLabels.length;
            if (numberLabels == 1) {
                String label = conceptSemanticTypeLabels[0];
                String uri = this.getURIForSemanticTypeLabel(label);
                if (uri != "") {
                    String[] urisToAdd = new String[]{uri};
                    pseudoInputString = uri;
                    log.debug((Object)("uris to add" + uri));
                    submission.addUriToForm(this.editConfiguration, "conceptSemanticTypeURI", urisToAdd);
                }
            } else if (numberLabels > 1) {
                for (int i = 0; i < numberLabels; ++i) {
                    int suffix = i + 1;
                    String label = conceptSemanticTypeLabels[i];
                    String labelVar = conceptSemanticTypeLabelBase + suffix;
                    Integer thisSuffix = new Integer(suffix);
                    if (!labelValueToVarSuffix.containsKey(label)) {
                        labelValueToVarSuffix.put(label, new ArrayList());
                        ((List)labelValueToVarSuffix.get(label)).add(thisSuffix);
                    } else {
                        List suffixList = (List)labelValueToVarSuffix.get(label);
                        if (suffixList != null && suffixList.size() > 0) {
                            thisSuffix = (Integer)suffixList.get(0);
                        }
                    }
                    String uriVar = conceptSemanticTypeURIBase + thisSuffix;
                    this.labelVarToUriVarHash.put(labelVar, uriVar);
                    String uri = this.getURIForSemanticTypeLabel(label);
                    if (uri != "" && !this.conceptSemanticTypeURIVarToValueMap.containsKey(uriVar)) {
                        this.conceptSemanticTypeURIVarToValueMap.put(uriVar, new ArrayList());
                        this.conceptSemanticTypeURIVarToValueMap.get(uriVar).add(uri);
                    }
                    if (i != 0) {
                        pseudoInputString = pseudoInputString + ",";
                    }
                    pseudoInputString = pseudoInputString + uri;
                }
                String[] urisToAdd = new String[]{pseudoInputString};
                log.debug((Object)("uris to add" + pseudoInputString));
                submission.addUriToForm(this.editConfiguration, "conceptSemanticTypeURI", urisToAdd);
            }
        }
        return pseudoInputString;
    }

    private String getURIForSemanticTypeLabel(String label) {
        String existingURI = this.getExistingSemanticTypeURI(label);
        if (existingURI != null) {
            return existingURI;
        }
        return "";
    }

    private String getExistingSemanticTypeURI(String label) {
        String queryStr = "SELECT ?semanticType WHERE { ?semanticType <" + RDF.type.getURI() + "> <" + OWL.Class.getURI() + "> . " + "?semanticType <" + RDFS.label.getURI() + "> \"" + label + "\"^^<http://www.w3.org/2001/XMLSchema#string>  . }";
        try (QueryExecution qe = null;){
            Query query = QueryFactory.create((String)queryStr);
            qe = QueryExecutionFactory.create((Query)query, (Model)this.ontModel);
            ResultSet results = null;
            results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                if (qs.get("semanticType") == null) continue;
                Resource semanticTypeURI = qs.getResource("semanticType");
                log.debug((Object)("Semantic Type URI returned " + semanticTypeURI.getURI()));
                String string = semanticTypeURI.getURI();
                return string;
            }
        }
        return null;
    }

    private Object getFirstElement(List inputList) {
        if (inputList == null || inputList.size() == 0) {
            return null;
        }
        return inputList.get(0);
    }
}

