/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.servlet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.cornell.mannlib.semservices.bo.Concept;
import edu.cornell.mannlib.semservices.bo.ConceptInfo;
import edu.cornell.mannlib.semservices.bo.SemanticServicesError;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.utils.ConceptSearchService.ConceptSearchServiceUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConceptSearchServlet
extends VitroHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConceptSearchServlet.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
        VitroRequest vreq = new VitroRequest(req);
        try {
            ServletContext ctx = vreq.getSession().getServletContext();
            ConceptInfo conceptInfo = new ConceptInfo();
            conceptInfo.setSemanticServicesError(null);
            List<Concept> results = null;
            try {
                results = ConceptSearchServiceUtils.getSearchResults(ctx, vreq);
            }
            catch (Exception ex) {
                SemanticServicesError semanticServicesError = new SemanticServicesError("Exception encountered ", ex.getMessage(), "fatal");
                log.error((Object)"An error occurred retrieving search results", (Throwable)ex);
                conceptInfo.setSemanticServicesError(semanticServicesError);
            }
            conceptInfo.setConceptList(results);
            String json = this.renderJson(conceptInfo);
            json = StringUtils.replaceChars((String)json, (String)"\r\t\n", (String)"");
            PrintWriter writer = resp.getWriter();
            resp.setContentType("application/json");
            writer.write(json);
            writer.close();
        }
        catch (Exception ex) {
            log.warn((Object)ex, (Throwable)ex);
        }
    }

    protected String renderJson(ConceptInfo conceptInfo) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)conceptInfo);
        }
        catch (JsonProcessingException e) {
            log.error((Object)"An error occurred in rendering conceptInfo as json ", (Throwable)e);
            return null;
        }
    }
}

