/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.coprincipalinvestigator;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.visualization.collaborationutils.CoInvestigationData;
import edu.cornell.mannlib.vitro.webapp.visualization.collaborationutils.CollaborationData;
import edu.cornell.mannlib.vitro.webapp.visualization.collaborationutils.CollaboratorComparator;
import edu.cornell.mannlib.vitro.webapp.visualization.constants.QueryConstants;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Activity;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Collaboration;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Collaborator;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.QueryRunner;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UniqueIDGenerator;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.RDFNode;

public class CoPIGrantCountQueryRunner
implements QueryRunner<CollaborationData> {
    private static final int MAX_PI_PER_GRANT_ALLOWED = 100;
    protected static final Syntax SYNTAX = Syntax.syntaxARQ;
    private String egoURI;
    private RDFService rdfService;
    private VitroRequest vitroRequest;
    private Log log = LogFactory.getLog((String)CoPIGrantCountQueryRunner.class.getName());
    private long before;
    private long after;
    private static final String SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_ROLE_DATE_TIME = "OPTIONAL {\t\t\t?Role core:dateTimeInterval ?dateTimeIntervalValue . ?dateTimeIntervalValue core:start ?startDate . ?startDate core:dateTime ?startDateTimeValue . } . ";
    private static final String SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_GRANT_DATE_TIME = "OPTIONAL {\t\t\t?Grant core:dateTimeInterval ?dateTimeIntervalValueForGrant . ?dateTimeIntervalValueForGrant core:start ?startDateForGrant . ?startDateForGrant core:dateTime ?startDateTimeValueForGrant . }";
    private static final Map<String, CollaborationDataCacheEntry> collaborationDataCache = new ConcurrentHashMap<String, CollaborationDataCacheEntry>();

    public CoPIGrantCountQueryRunner(String egoURI, VitroRequest vreq, Log log) {
        this.egoURI = egoURI;
        this.rdfService = vreq.getRDFService();
        this.vitroRequest = vreq;
    }

    private String generateEgoCoPIquery(String queryURI) {
        String sparqlQuery = QueryConstants.getSparqlPrefixQuery() + "SELECT " + "\t\t(str(<" + queryURI + ">) as ?" + "PILit" + ") " + "\t\t(str(?PILabel) as ?" + "PILabelLit" + ") " + "\t\t(str(?Grant) as ?" + "grantLit" + ") " + " \t(str(?startDateTimeValue) as ?grantStartDateLit) " + " \t(str(?startDateTimeValueForGrant) as ?grantStartDateForGrantLit) " + "\t\t(str(?CoPI) as ?" + "coPILit" + ") " + "\t\t(str(?CoPILabel) as ?" + "coPILabelLit" + ") " + "WHERE " + "{ " + "<" + queryURI + "> rdfs:label ?PILabel . " + "{ " + "<" + queryURI + "> <http://purl.obolibrary.org/obo/RO_0000053> ?Role . " + "?Role rdf:type core:CoPrincipalInvestigatorRole . " + "?Role core:relatedBy ?Grant . " + "?Grant rdf:type core:Grant . " + "?Grant core:relates ?RelatedRole . " + "?RelatedRole rdf:type core:PrincipalInvestigatorRole . " + "?RelatedRole <http://purl.obolibrary.org/obo/RO_0000052> ?CoPI . " + "?CoPI rdf:type foaf:Person .\t" + "?CoPI rdfs:label ?CoPILabel .\t" + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_ROLE_DATE_TIME + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_GRANT_DATE_TIME + "} " + "UNION " + "{ " + "<" + queryURI + "> <http://purl.obolibrary.org/obo/RO_0000053> ?Role . " + "?Role rdf:type core:CoPrincipalInvestigatorRole . " + "?Role core:relatedBy ?Grant . " + "?Grant rdf:type core:Grant . " + "?Grant core:relates ?RelatedRole . " + "?RelatedRole rdf:type core:InvestigatorRole . " + "?RelatedRole <http://purl.obolibrary.org/obo/RO_0000052> ?CoPI . " + "?CoPI rdf:type foaf:Person .\t" + "?CoPI rdfs:label ?CoPILabel .\t" + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_ROLE_DATE_TIME + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_GRANT_DATE_TIME + "} " + "UNION " + "{ " + "<" + queryURI + "> <http://purl.obolibrary.org/obo/RO_0000053> ?Role . " + "?Role rdf:type core:CoPrincipalInvestigatorRole . " + "?Role core:relatedBy ?Grant . " + "?Grant rdf:type core:Grant . " + "?Grant core:relates ?RelatedRole . " + "?RelatedRole rdf:type core:CoPrincipalInvestigatorRole  . " + "?RelatedRole <http://purl.obolibrary.org/obo/RO_0000052> ?CoPI . " + "?CoPI rdf:type foaf:Person .\t" + "?CoPI rdfs:label ?CoPILabel .\t" + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_ROLE_DATE_TIME + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_GRANT_DATE_TIME + "} " + "UNION " + "{ " + "<" + queryURI + "> <http://purl.obolibrary.org/obo/RO_0000053> ?Role . " + "?Role rdf:type core:PrincipalInvestigatorRole . " + "?Role core:relatedBy ?Grant . " + "?Grant rdf:type core:Grant . " + "?Grant core:relates ?RelatedRole . " + "?RelatedRole rdf:type core:PrincipalInvestigatorRole  . " + "?RelatedRole <http://purl.obolibrary.org/obo/RO_0000052> ?CoPI . " + "?CoPI rdf:type foaf:Person .\t" + "?CoPI rdfs:label ?CoPILabel .\t" + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_ROLE_DATE_TIME + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_GRANT_DATE_TIME + "} " + "UNION " + "{ " + "<" + queryURI + "> <http://purl.obolibrary.org/obo/RO_0000053> ?Role . " + "?Role rdf:type core:PrincipalInvestigatorRole . " + "?Role core:relatedBy ?Grant . " + "?Grant rdf:type core:Grant . " + "?Grant core:relates ?RelatedRole . " + "?RelatedRole rdf:type core:InvestigatorRole  . " + "?RelatedRole <http://purl.obolibrary.org/obo/RO_0000052> ?CoPI . " + "?CoPI rdf:type foaf:Person .\t" + "?CoPI rdfs:label ?CoPILabel .\t" + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_ROLE_DATE_TIME + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_GRANT_DATE_TIME + "} " + "UNION " + "{ " + "<" + queryURI + "> <http://purl.obolibrary.org/obo/RO_0000053> ?Role . " + "?Role rdf:type core:PrincipalInvestigatorRole . " + "?Role core:relatedBy ?Grant . " + "?Grant rdf:type core:Grant . " + "?Grant core:relates ?RelatedRole . " + "?RelatedRole rdf:type core:CoPrincipalInvestigatorRole . " + "?RelatedRole <http://purl.obolibrary.org/obo/RO_0000052> ?CoPI . " + "?CoPI rdf:type foaf:Person .\t" + "?CoPI rdfs:label ?CoPILabel .\t" + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_ROLE_DATE_TIME + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_GRANT_DATE_TIME + "} " + "UNION " + "{ " + "<" + queryURI + "> <http://purl.obolibrary.org/obo/RO_0000053> ?Role . " + "?Role rdf:type core:InvestigatorRole . " + "?Role core:relatedBy ?Grant . " + "?Grant rdf:type core:Grant . " + "?Grant core:relates ?RelatedRole . " + "?RelatedRole rdf:type core:InvestigatorRole  . " + "?RelatedRole <http://purl.obolibrary.org/obo/RO_0000052> ?CoPI . " + "?CoPI rdf:type foaf:Person .\t" + "?CoPI rdfs:label ?CoPILabel .\t" + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_ROLE_DATE_TIME + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_GRANT_DATE_TIME + "} " + "UNION " + "{ " + "<" + queryURI + "> <http://purl.obolibrary.org/obo/RO_0000053> ?Role . " + "?Role rdf:type core:InvestigatorRole . " + "?Role core:relatedBy ?Grant . " + "?Grant rdf:type core:Grant . " + "?Grant core:relates ?RelatedRole . " + "?RelatedRole rdf:type core:CoPrincipalInvestigatorRole  . " + "?RelatedRole <http://purl.obolibrary.org/obo/RO_0000052> ?CoPI . " + "?CoPI rdf:type foaf:Person .\t" + "?CoPI rdfs:label ?CoPILabel .\t" + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_ROLE_DATE_TIME + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_GRANT_DATE_TIME + "} " + "UNION " + "{ " + "<" + queryURI + "> <http://purl.obolibrary.org/obo/RO_0000053> ?Role . " + "?Role rdf:type core:InvestigatorRole . " + "?Role core:relatedBy ?Grant . " + "?Grant rdf:type core:Grant . " + "?Grant core:relates ?RelatedRole . " + "?RelatedRole rdf:type core:PrincipalInvestigatorRole . " + "?RelatedRole <http://purl.obolibrary.org/obo/RO_0000052> ?CoPI . " + "?CoPI rdf:type foaf:Person .\t" + "?CoPI rdfs:label ?CoPILabel .\t" + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_ROLE_DATE_TIME + SPARQL_QUERY_COMMON_OPTIONAL_BLOCK_FOR_GRANT_DATE_TIME + "} " + "} ";
        return sparqlQuery;
    }

    @Override
    public CoInvestigationData getQueryResult() throws MalformedQueryParametersException {
        CoInvestigationData data = this.getCachedData(this.egoURI);
        if (data != null) {
            return data;
        }
        return this.getQueryResultAndCache();
    }

    private CoInvestigationData getCachedData(String egoURI) {
        CollaborationDataCacheEntry entry = collaborationDataCache.get(egoURI);
        if (entry != null && !entry.hasExpired()) {
            entry.accessTime = new Date().getTime();
            this.expireCache();
            return entry.data;
        }
        return null;
    }

    private synchronized CoInvestigationData getQueryResultAndCache() throws MalformedQueryParametersException {
        CoInvestigationData data = this.getCachedData(this.egoURI);
        if (data != null) {
            return data;
        }
        if (StringUtils.isNotBlank((CharSequence)this.egoURI)) {
            IRIFactory iRIFactory = IRIFactory.jenaImplementation();
            IRI iri = iRIFactory.create(this.egoURI);
            if (iri.hasViolation(false)) {
                String errorMsg = ((Violation)iri.violations(false).next()).getShortMessage();
                this.log.error((Object)("Ego Co-PI Vis Query " + errorMsg));
                throw new MalformedQueryParametersException("URI provided for an individual is malformed.");
            }
        } else {
            throw new MalformedQueryParametersException("URI parameter is either null or empty.");
        }
        this.before = System.currentTimeMillis();
        try {
            QueryResultConsumer consumer = new QueryResultConsumer();
            this.rdfService.sparqlSelectQuery(this.generateEgoCoPIquery(this.egoURI), (ResultSetConsumer)consumer);
            if (consumer.egoNode == null) {
                consumer.egoNode = this.makeEgoNode();
            }
            data = consumer.getData();
        }
        catch (RDFServiceException e) {
            this.log.error((Object)"Unable to execute query", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.after = System.currentTimeMillis();
        this.log.debug((Object)("Time taken to execute the SELECT queries is in milliseconds: " + (this.after - this.before)));
        CollaborationDataCacheEntry newEntry = new CollaborationDataCacheEntry();
        newEntry.uri = this.egoURI;
        newEntry.data = data;
        newEntry.creationTime = newEntry.accessTime = new Date().getTime();
        this.expireCache();
        collaborationDataCache.put(this.egoURI, newEntry);
        return data;
    }

    private Collaborator makeEgoNode() {
        Collaborator collab = new Collaborator(this.egoURI, new UniqueIDGenerator());
        collab.setCollaboratorName(UtilityFunctions.getIndividualLabelFromDAO(this.vitroRequest, this.egoURI));
        return collab;
    }

    private synchronized void expireCache() {
        for (String key : collaborationDataCache.keySet()) {
            CollaborationDataCacheEntry entry = collaborationDataCache.get(key);
            if (entry == null || !entry.hasExpired()) continue;
            collaborationDataCache.remove(key);
        }
    }

    private static class QueryResultConsumer
    extends ResultSetConsumer {
        Set<Collaborator> nodes = new HashSet<Collaborator>();
        Map<String, Activity> grantURLToVO = new HashMap<String, Activity>();
        Map<String, Set<Collaborator>> grantURLToCoPIs = new HashMap<String, Set<Collaborator>>();
        Map<String, Collaborator> nodeURLToVO = new HashMap<String, Collaborator>();
        Map<String, Collaboration> edgeUniqueIdentifierToVO = new HashMap<String, Collaboration>();
        Collaborator egoNode = null;
        Set<Collaboration> edges = new HashSet<Collaboration>();
        private UniqueIDGenerator nodeIDGenerator = new UniqueIDGenerator();
        private UniqueIDGenerator edgeIDGenerator = new UniqueIDGenerator();
        private Log log = LogFactory.getLog((String)CoPIGrantCountQueryRunner.class.getName());

        private QueryResultConsumer() {
        }

        protected void processQuerySolution(QuerySolution qs) {
            Set<Object> coPIsForCurrentGrant;
            Collaborator coPINode;
            Activity grant;
            RDFNode egoPIURLNode = qs.get("PILit");
            if (this.nodeURLToVO.containsKey(egoPIURLNode.toString())) {
                this.egoNode = this.nodeURLToVO.get(egoPIURLNode.toString());
            } else {
                this.egoNode = new Collaborator(egoPIURLNode.toString(), this.nodeIDGenerator);
                this.nodes.add(this.egoNode);
                this.nodeURLToVO.put(egoPIURLNode.toString(), this.egoNode);
                RDFNode authorLabelNode = qs.get("PILabelLit");
                if (authorLabelNode != null) {
                    this.egoNode.setCollaboratorName(authorLabelNode.toString());
                }
            }
            this.log.debug((Object)("PI: " + this.egoNode.getIndividualLabel()));
            RDFNode grantNode = qs.get("grantLit");
            if (this.grantURLToVO.containsKey(grantNode.toString())) {
                grant = this.grantURLToVO.get(grantNode.toString());
            } else {
                grant = this.createGrantVO(qs, grantNode.toString());
                this.grantURLToVO.put(grantNode.toString(), grant);
            }
            this.egoNode.addActivity(grant);
            this.log.debug((Object)("Adding grant: " + grant.getIndividualLabel()));
            if (qs.get("PILit").toString().equalsIgnoreCase(qs.get("coPILit").toString())) {
                return;
            }
            RDFNode coPIURLNode = qs.get("coPILit");
            if (this.nodeURLToVO.containsKey(coPIURLNode.toString())) {
                coPINode = this.nodeURLToVO.get(coPIURLNode.toString());
            } else {
                coPINode = new Collaborator(coPIURLNode.toString(), this.nodeIDGenerator);
                this.nodes.add(coPINode);
                this.nodeURLToVO.put(coPIURLNode.toString(), coPINode);
                RDFNode coPILabelNode = qs.get("coPILabelLit");
                if (coPILabelNode != null) {
                    coPINode.setCollaboratorName(coPILabelNode.toString());
                }
            }
            this.log.debug((Object)("Adding CO-PI: " + coPINode.getIndividualLabel()));
            coPINode.addActivity(grant);
            if (this.grantURLToCoPIs.containsKey(grant.getActivityURI())) {
                coPIsForCurrentGrant = this.grantURLToCoPIs.get(grant.getActivityURI());
            } else {
                coPIsForCurrentGrant = new HashSet();
                this.grantURLToCoPIs.put(grant.getActivityURI(), coPIsForCurrentGrant);
            }
            coPIsForCurrentGrant.add(coPINode);
            this.log.debug((Object)("Co-PI for current grant : " + coPINode.getIndividualLabel()));
            Collaboration egoCoPIEdge = this.getExistingEdge(this.egoNode, coPINode, this.edgeUniqueIdentifierToVO);
            if (egoCoPIEdge != null) {
                egoCoPIEdge.addActivity(grant);
            } else {
                egoCoPIEdge = new Collaboration(this.egoNode, coPINode, grant, this.edgeIDGenerator);
                this.edges.add(egoCoPIEdge);
                this.edgeUniqueIdentifierToVO.put(this.getEdgeUniqueIdentifier(this.egoNode.getCollaboratorID(), coPINode.getCollaboratorID()), egoCoPIEdge);
            }
        }

        protected void endProcessing() {
            super.endProcessing();
            this.removeLowQualityNodesAndEdges(this.nodes, this.grantURLToVO, this.grantURLToCoPIs, this.edges);
            this.createCoPIEdges(this.grantURLToVO, this.grantURLToCoPIs, this.edges, this.edgeUniqueIdentifierToVO);
        }

        public CoInvestigationData getData() {
            return new CoInvestigationData(this.egoNode, this.nodes, this.edges, this.grantURLToVO);
        }

        private void createCoPIEdges(Map<String, Activity> grantURLToVO, Map<String, Set<Collaborator>> grantURLToCoPIs, Set<Collaboration> edges, Map<String, Collaboration> edgeUniqueIdentifierToVO) {
            for (Map.Entry<String, Set<Collaborator>> currentGrantEntry : grantURLToCoPIs.entrySet()) {
                if (currentGrantEntry.getValue().size() <= 1 || currentGrantEntry.getValue().size() > 100) continue;
                HashSet<Collaboration> newlyAddedEdges = new HashSet<Collaboration>();
                ArrayList coPINodes = new ArrayList(currentGrantEntry.getValue());
                Collections.sort(coPINodes, new CollaboratorComparator());
                int numOfCoPIs = coPINodes.size();
                for (int ii = 0; ii < numOfCoPIs - 1; ++ii) {
                    for (int jj = ii + 1; jj < numOfCoPIs; ++jj) {
                        Collaborator coPI1 = (Collaborator)coPINodes.get(ii);
                        Collaborator coPI2 = (Collaborator)coPINodes.get(jj);
                        Collaboration coPI1_2Edge = this.getExistingEdge(coPI1, coPI2, edgeUniqueIdentifierToVO);
                        Activity currentGrant = grantURLToVO.get(currentGrantEntry.getKey());
                        if (coPI1_2Edge != null) {
                            coPI1_2Edge.addActivity(currentGrant);
                            continue;
                        }
                        coPI1_2Edge = new Collaboration(coPI1, coPI2, currentGrant, this.edgeIDGenerator);
                        newlyAddedEdges.add(coPI1_2Edge);
                        edgeUniqueIdentifierToVO.put(this.getEdgeUniqueIdentifier(coPI1.getCollaboratorID(), coPI2.getCollaboratorID()), coPI1_2Edge);
                    }
                }
                edges.addAll(newlyAddedEdges);
            }
        }

        private void removeLowQualityNodesAndEdges(Set<Collaborator> nodes, Map<String, Activity> grantURLToVO, Map<String, Set<Collaborator>> grantURLToCoPIs, Set<Collaboration> edges) {
            HashSet<Collaborator> nodesToBeRemoved = new HashSet<Collaborator>();
            for (Map.Entry<String, Set<Collaborator>> currentGrantEntry : grantURLToCoPIs.entrySet()) {
                if (currentGrantEntry.getValue().size() <= 100) continue;
                Activity currentGrant = grantURLToVO.get(currentGrantEntry.getKey());
                HashSet<Collaboration> edgesToBeRemoved = new HashSet<Collaboration>();
                for (Collaboration currentEdge : edges) {
                    Set<Activity> currentCollaboratorGrants = currentEdge.getCollaborationActivities();
                    if (!currentCollaboratorGrants.contains(currentGrant)) continue;
                    currentCollaboratorGrants.remove(currentGrant);
                    if (!currentCollaboratorGrants.isEmpty()) continue;
                    edgesToBeRemoved.add(currentEdge);
                }
                edges.removeAll(edgesToBeRemoved);
                for (Collaborator currentCoPI : currentGrantEntry.getValue()) {
                    currentCoPI.getCollaboratorActivities().remove(currentGrant);
                    if (!currentCoPI.getCollaboratorActivities().isEmpty()) continue;
                    nodesToBeRemoved.add(currentCoPI);
                }
            }
            nodes.removeAll(nodesToBeRemoved);
        }

        private Activity createGrantVO(QuerySolution solution, String grantURL) {
            Activity grant = new Activity(grantURL);
            RDFNode grantStartYear = solution.get("grantStartDateLit");
            if (grantStartYear != null) {
                grant.setActivityDate(grantStartYear.toString());
            } else {
                grantStartYear = solution.get("grantStartDateForGrantLit");
                if (grantStartYear != null) {
                    grant.setActivityDate(grantStartYear.toString());
                }
            }
            return grant;
        }

        private Collaboration getExistingEdge(Collaborator collaboratingNode1, Collaborator collaboratingNode2, Map<String, Collaboration> edgeUniqueIdentifierToVO) {
            String edgeUniqueIdentifier = this.getEdgeUniqueIdentifier(collaboratingNode1.getCollaboratorID(), collaboratingNode2.getCollaboratorID());
            return edgeUniqueIdentifierToVO.get(edgeUniqueIdentifier);
        }

        private String getEdgeUniqueIdentifier(int nodeID1, int nodeID2) {
            String separator = "*";
            if (nodeID1 < nodeID2) {
                return nodeID1 + separator + nodeID2;
            }
            return nodeID2 + separator + nodeID1;
        }
    }

    private static class CollaborationDataCacheEntry {
        String uri;
        CoInvestigationData data;
        long creationTime;
        long accessTime;

        private CollaborationDataCacheEntry() {
        }

        boolean hasExpired() {
            long now = new Date().getTime();
            if (this.creationTime < now - 300000L && this.accessTime < now - 3000L) {
                return true;
            }
            return this.accessTime < now - 30000L;
        }
    }
}

