/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.temporalgraph;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Entity;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.GenericQueryMap;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.GenericQueryRunner;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;

public class OrganizationUtilityFunctions {
    public static String getHighestLevelOrganizationURI(ResultSet resultSet, Map<String, String> fieldLabelToOutputFieldLabel) {
        GenericQueryMap queryResult = new GenericQueryMap();
        while (resultSet.hasNext()) {
            Literal numberOfChildrenNode;
            QuerySolution solution = resultSet.nextSolution();
            RDFNode organizationNode = solution.get(fieldLabelToOutputFieldLabel.get("organization"));
            if (organizationNode != null) {
                queryResult.addEntry(fieldLabelToOutputFieldLabel.get("organization"), organizationNode.toString());
                return organizationNode.toString();
            }
            RDFNode organizationLabelNode = solution.get(fieldLabelToOutputFieldLabel.get("organizationLabel"));
            if (organizationLabelNode != null) {
                queryResult.addEntry(fieldLabelToOutputFieldLabel.get("organizationLabel"), organizationLabelNode.toString());
            }
            if ((numberOfChildrenNode = solution.getLiteral("numOfChildren")) == null) continue;
            queryResult.addEntry("numOfChildren", String.valueOf(numberOfChildrenNode.asLiteral().getInt()));
        }
        return "";
    }

    public static String getHighestLevelOrganizationURI(Log log, Dataset dataset) throws MalformedQueryParametersException {
        HashMap<String, String> fieldLabelToOutputFieldLabel = new HashMap<String, String>();
        fieldLabelToOutputFieldLabel.put("organization", "organizationLit");
        fieldLabelToOutputFieldLabel.put("organizationLabel", "organizationLabelLit");
        String aggregationRules = "(count(?organization) AS ?numOfChildren)";
        String whereClause = "?organization rdf:type foaf:Organization ; rdfs:label ?organizationLabel . \nOPTIONAL { ?organization <http://purl.obolibrary.org/obo/BFO_0000051> ?subOrg . \n           ?subOrg rdf:type foaf:Organization } . \nOPTIONAL { ?organization <http://purl.obolibrary.org/obo/BFO_0000050> ?parent . \n               ?parent rdf:type foaf:Organization } . \nFILTER ( !bound(?parent) ). \n";
        String groupOrderClause = "GROUP BY ?organization ?organizationLabel \nORDER BY DESC(?numOfChildren)\nLIMIT 1\n";
        GenericQueryRunner highestLevelOrganizationQueryHandler = new GenericQueryRunner(fieldLabelToOutputFieldLabel, aggregationRules, whereClause, groupOrderClause, dataset);
        String highestLevelOrgURI = OrganizationUtilityFunctions.getHighestLevelOrganizationURI((ResultSet)highestLevelOrganizationQueryHandler.getQueryResult(), fieldLabelToOutputFieldLabel);
        return highestLevelOrgURI;
    }

    public static String getEntityLabelFromDAO(VitroRequest vitroRequest, String entityURI) {
        IndividualDao iDao = vitroRequest.getWebappDaoFactory().getIndividualDao();
        Individual ind = iDao.getIndividualByURI(entityURI);
        String organizationLabel = "Unknown Organization";
        if (ind != null) {
            organizationLabel = ind.getName();
        }
        return organizationLabel;
    }

    public static String getStaffProvidedOrComputedHighestLevelOrganization(Log log, Dataset dataset, VitroRequest vitroRequest) throws MalformedQueryParametersException {
        IRIFactory iRIFactory;
        IRI iri;
        String staffProvidedHighestLevelOrganization = ConfigurationProperties.getBean((ServletRequest)vitroRequest).getProperty("visualization.topLevelOrg");
        if (StringUtils.isNotBlank((CharSequence)staffProvidedHighestLevelOrganization) && !(iri = (iRIFactory = IRIFactory.jenaImplementation()).create(staffProvidedHighestLevelOrganization)).hasViolation(false)) {
            return staffProvidedHighestLevelOrganization;
        }
        return OrganizationUtilityFunctions.getHighestLevelOrganizationURI(log, dataset);
    }

    public static Entity mergeEntityIfShareSameURI(Entity entityA, Entity entityB) {
        if (StringUtils.equalsIgnoreCase((CharSequence)entityA.getEntityURI(), (CharSequence)entityB.getEntityURI())) {
            Entity mergedEntity = new Entity(entityA.getEntityURI());
            if (StringUtils.isNotBlank((CharSequence)entityA.getEntityLabel())) {
                mergedEntity.setEntityLabel(entityA.getEntityLabel());
            } else if (StringUtils.isNotBlank((CharSequence)entityB.getEntityLabel())) {
                mergedEntity.setEntityLabel(entityB.getEntityLabel());
            }
            mergedEntity.addSubEntitities(entityA.getSubEntities());
            mergedEntity.addSubEntitities(entityB.getSubEntities());
            mergedEntity.addParents(entityA.getParents());
            mergedEntity.addParents(entityB.getParents());
            return mergedEntity;
        }
        return null;
    }
}

