/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.visutils;

import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.visualization.constants.QueryConstants;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.GenericQueryMap;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.QueryRunner;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.RDFNode;

public class AllPropertiesQueryRunner
implements QueryRunner<GenericQueryMap> {
    protected static final Syntax SYNTAX = Syntax.syntaxARQ;
    private String filterRule;
    private String individualURI;
    private RDFService rdfService;
    private Log log = LogFactory.getLog((String)AllPropertiesQueryRunner.class.getName());

    public AllPropertiesQueryRunner(String individualURI, String filterRule, RDFService rdfService, Log log) {
        this.individualURI = individualURI;
        this.filterRule = filterRule;
        this.rdfService = rdfService;
        this.log = log;
    }

    private String generateGenericSparqlQuery(String queryURI, String filterRule) {
        String filterClause = StringUtils.isNotBlank((CharSequence)filterRule) ? "FILTER ( " + filterRule + " ) . " : "";
        String sparqlQuery = QueryConstants.getSparqlPrefixQuery() + "SELECT " + "\t\t(str(?predicate) as ?" + "predicateLit" + ") " + "\t\t(str(?object) as ?" + "objectLit" + ") " + "WHERE { {" + "<" + queryURI + "> ?predicate ?object.  }" + "UNION {<" + queryURI + ">  <http://purl.obolibrary.org/obo/ARG_2000028> ?vCard . " + "?vCard <http://www.w3.org/2006/vcard/ns#hasTitle> ?vTitle . " + "?vTitle ?predicate ?object . }" + filterClause + "}";
        this.log.debug((Object)("sparqlQuery = " + sparqlQuery.toString()));
        return sparqlQuery;
    }

    @Override
    public GenericQueryMap getQueryResult() throws MalformedQueryParametersException {
        if (StringUtils.isNotBlank((CharSequence)this.individualURI)) {
            IRIFactory iRIFactory = IRIFactory.jenaImplementation();
            IRI iri = iRIFactory.create(this.individualURI);
            if (iri.hasViolation(false)) {
                String errorMsg = ((Violation)iri.violations(false).next()).getShortMessage();
                this.log.error((Object)("Generic Query " + errorMsg));
                throw new MalformedQueryParametersException("URI provided for an individual is malformed.");
            }
        } else {
            throw new MalformedQueryParametersException("URI parameter is either null or empty.");
        }
        CreateJavaVOConsumer consumer = new CreateJavaVOConsumer();
        try {
            this.rdfService.sparqlSelectQuery(this.generateGenericSparqlQuery(this.individualURI, this.filterRule), (ResultSetConsumer)consumer);
        }
        catch (RDFServiceException e) {
            this.log.error((Object)"Unable to execute query", (Throwable)e);
            throw new MalformedQueryParametersException((Exception)((Object)e));
        }
        return consumer.getMap();
    }

    private class CreateJavaVOConsumer
    extends ResultSetConsumer {
        GenericQueryMap queryResult = new GenericQueryMap();

        private CreateJavaVOConsumer() {
        }

        protected void processQuerySolution(QuerySolution qs) {
            RDFNode predicateNode = qs.get("predicateLit");
            RDFNode objectNode = qs.get("objectLit");
            if (predicateNode != null && objectNode != null) {
                this.queryResult.addEntry(predicateNode.toString(), objectNode.toString());
            }
        }

        public GenericQueryMap getMap() {
            return this.queryResult;
        }
    }
}

