/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.searchresult;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.searchresult.IndividualSearchResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;

public class VIVOIndividualSearchResult
extends IndividualSearchResult {
    private static final Log log = LogFactory.getLog(VIVOIndividualSearchResult.class);
    private static String VCARD_DATA_QUERY = "PREFIX obo: <http://purl.obolibrary.org/obo/> \nPREFIX vcard: <http://www.w3.org/2006/vcard/ns#>  \nSELECT DISTINCT ?email ?title  \nWHERE {  \n    ?subject obo:ARG_2000028 ?vIndividual .  \n    OPTIONAL { ?vIndividual vcard:hasEmail ?vEmail . \n               ?vEmail vcard:email ?email . \n    } \n    OPTIONAL { ?vIndividual vcard:hasTitle ?vTitle . \n               ?vTitle vcard:title ?title . \n    } \n} ";
    private String email = "";
    private String title = "";

    public VIVOIndividualSearchResult(Individual individual, VitroRequest vreq) {
        super(individual, vreq);
        log.debug((Object)"Called Individual Search Result");
        this.findVcardInfo();
    }

    private void findVcardInfo() {
        String queryStr = QueryUtils.subUriForQueryVar((String)VCARD_DATA_QUERY, (String)"subject", (String)this.individual.getURI());
        log.debug((Object)("queryStr = " + queryStr));
        try {
            ResultSet results = QueryUtils.getQueryResults((String)queryStr, (VitroRequest)this.vreq);
            while (results.hasNext()) {
                String em;
                QuerySolution soln = results.nextSolution();
                String t = QueryUtils.nodeToString((RDFNode)soln.get("title"));
                if (StringUtils.isNotBlank((CharSequence)t)) {
                    this.title = t;
                }
                if (!StringUtils.isNotBlank((CharSequence)(em = QueryUtils.nodeToString((RDFNode)soln.get("email"))))) continue;
                this.email = em;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public String getPreferredTitle() {
        return this.title;
    }

    public String getEmail() {
        return this.email;
    }

    public static void register() {
        IndividualSearchResult.registerResultClass(VIVOIndividualSearchResult.class);
    }
}

