/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.orcid.controller;

import edu.cornell.mannlib.orcidclient.orcidmessage.ExternalIdentifier;
import edu.cornell.mannlib.orcidclient.orcidmessage.ExternalIdentifiers;
import edu.cornell.mannlib.orcidclient.orcidmessage.OrcidBio;
import edu.cornell.mannlib.orcidclient.orcidmessage.OrcidId;
import edu.cornell.mannlib.orcidclient.orcidmessage.OrcidMessage;
import edu.cornell.mannlib.orcidclient.orcidmessage.OrcidProfile;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidIntegrationController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class OrcidConfirmationState {
    private static final Log log = LogFactory.getLog(OrcidConfirmationState.class);
    private static final String ATTRIBUTE_NAME = OrcidConfirmationState.class.getName();
    private static final Set<Progress> requiresMessage = EnumSet.of(Progress.GOT_PROFILE, Progress.ADDED_ID);
    private Progress progress;
    private String individualUri;
    private Set<String> existingOrcids;
    private OrcidMessage profile;
    private String profilePageUrl;

    OrcidConfirmationState() {
    }

    static OrcidConfirmationState fetch(HttpServletRequest req) {
        HttpSession session = req.getSession();
        Object o = session.getAttribute(ATTRIBUTE_NAME);
        if (o instanceof OrcidConfirmationState) {
            return (OrcidConfirmationState)o;
        }
        OrcidConfirmationState ocs = new OrcidConfirmationState();
        session.setAttribute(ATTRIBUTE_NAME, (Object)ocs);
        return ocs;
    }

    public void reset(String uri, String profileUrl) {
        this.progress = Progress.START;
        this.individualUri = uri;
        this.existingOrcids = Collections.emptySet();
        this.profile = null;
        this.profilePageUrl = profileUrl;
    }

    public void setExistingOrcids(Set<String> existing) {
        this.existingOrcids = new HashSet<String>(existing);
    }

    public void progress(Progress p, OrcidMessage ... messages) {
        this.progress = p;
        if (requiresMessage.contains((Object)p)) {
            if (messages.length != 1) {
                throw new IllegalStateException("Progress to " + (Object)((Object)p) + " requires an OrcidMessage");
            }
            this.profile = messages[0];
        } else if (messages.length != 0) {
            throw new IllegalStateException("Progress to " + (Object)((Object)p) + " does not accept an OrcidMessage");
        }
    }

    public String getProgress() {
        return this.progress.toString();
    }

    public String getProgressUrl() {
        switch (this.progress) {
            case START: {
                return UrlBuilder.getUrl((String)OrcidIntegrationController.PATH_AUTH_AUTHENTICATE);
            }
            case GOT_PROFILE: {
                return UrlBuilder.getUrl((String)OrcidIntegrationController.PATH_AUTH_EXTERNAL_ID);
            }
        }
        return null;
    }

    public String getIndividualUri() {
        return this.individualUri;
    }

    public String getProfilePageUrl() {
        return this.profilePageUrl;
    }

    public String getOrcid() {
        return this.getElementFromOrcidIdentifier("path");
    }

    public String getOrcidUri() {
        return this.getElementFromOrcidIdentifier("uri");
    }

    public ExternalIdentifier getVivoId() {
        for (ExternalIdentifier id : this.getExternalIds()) {
            if (!this.individualUri.equals(id.getExternalIdUrl().getValue())) continue;
            return id;
        }
        return null;
    }

    public List<ExternalIdentifier> getExternalIds() {
        OrcidProfile orcidProfile = this.getOrcidProfile();
        if (orcidProfile == null) {
            return Collections.emptyList();
        }
        OrcidBio bio = orcidProfile.getOrcidBio();
        if (bio == null) {
            return Collections.emptyList();
        }
        ExternalIdentifiers identifiers = bio.getExternalIdentifiers();
        if (identifiers == null) {
            return Collections.emptyList();
        }
        List list = identifiers.getExternalIdentifier();
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    private String getElementFromOrcidIdentifier(String elementName) {
        OrcidProfile orcidProfile = this.getOrcidProfile();
        if (orcidProfile == null) {
            return "";
        }
        OrcidId id = orcidProfile.getOrcidIdentifier();
        if (id == null) {
            log.warn((Object)"There is no ORCID Identifier in the profile.");
            return "";
        }
        List idElements = id.getContent();
        if (idElements != null) {
            for (JAXBElement idElement : idElements) {
                String value;
                QName name = idElement.getName();
                if (name == null || !elementName.equals(name.getLocalPart()) || (value = (String)idElement.getValue()) == null) continue;
                return value;
            }
        }
        log.warn((Object)("Didn't find the element '' in the ORCID Identifier: " + idElements));
        return "";
    }

    private OrcidProfile getOrcidProfile() {
        if (this.profile == null) {
            return null;
        }
        OrcidProfile orcidProfile = this.profile.getOrcidProfile();
        if (orcidProfile == null) {
            return null;
        }
        return orcidProfile;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("progress", this.progress.toString());
        map.put("individualUri", this.individualUri);
        map.put("profilePage", this.profilePageUrl);
        map.put("orcid", this.getOrcid());
        map.put("orcidUri", this.getOrcidUri());
        map.put("hasVivoId", this.getVivoId() == null);
        map.put("externalIds", this.formatExternalIds());
        map.put("existingOrcids", this.existingOrcids);
        String progressUrl = this.getProgressUrl();
        if (progressUrl == null) {
            map.put("progressUrl", "");
        } else {
            map.put("progressUrl", progressUrl);
        }
        return map;
    }

    private List<Map<String, String>> formatExternalIds() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (ExternalIdentifier id : this.getExternalIds()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("commonName", id.getExternalIdCommonName().getContent());
            map.put("reference", id.getExternalIdReference().getContent());
            map.put("uri", id.getExternalIdUrl().getValue());
            list.add(map);
        }
        return list;
    }

    public static enum Progress {
        START,
        DENIED_AUTHENTICATE,
        FAILED_AUTHENTICATE,
        GOT_PROFILE,
        ID_ALREADY_PRESENT,
        DENIED_ID,
        FAILED_ID,
        ADDED_ID;

    }
}

