/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.ConceptSearchService;

import edu.cornell.mannlib.semservices.bo.Concept;
import edu.cornell.mannlib.semservices.service.ExternalConceptService;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.utils.ConceptSearchService.VocabSourceDescription;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConceptSearchServiceUtils {
    private static final Log log = LogFactory.getLog(ConceptSearchServiceUtils.class);
    private static final String UMLSVocabSource = "http://link.informatics.stonybrook.edu/umls";
    private static final String AgrovocVocabSource = "http://aims.fao.org/aos/agrovoc/agrovocScheme";
    private static final String GemetVocabSource = "http://www.eionet.europa.eu/gemet/gemetThesaurus";
    private static final String LCSHVocabSource = "http://id.loc.gov/authorities/subjects";

    public static String getConceptSearchServiceClassName(String searchServiceName) {
        HashMap<String, String> map = ConceptSearchServiceUtils.getMapping();
        if (map.containsKey(searchServiceName)) {
            return map.get(searchServiceName);
        }
        return null;
    }

    public static HashMap<String, VocabSourceDescription> getVocabSources() {
        HashMap<String, VocabSourceDescription> map = new HashMap<String, VocabSourceDescription>();
        map.put(UMLSVocabSource, new VocabSourceDescription("UMLS", UMLSVocabSource, "http://www.nlm.nih.gov/research/umls/", "Unified Medical Language System"));
        map.put(AgrovocVocabSource, new VocabSourceDescription("AGROVOC", AgrovocVocabSource, "http://www.fao.org/agrovoc/", "Agricultural Vocabulary"));
        map.put(GemetVocabSource, new VocabSourceDescription("GEMET", GemetVocabSource, "http://www.eionet.europa.eu/gemet", "GEneral Multilingual Environmental Thesaurus"));
        map.put(LCSHVocabSource, new VocabSourceDescription("LCSH", LCSHVocabSource, "http://id.loc.gov/authorities/subjects/", "Library of Congress Subject Headings"));
        return map;
    }

    private static HashMap<String, String> getMapping() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(UMLSVocabSource, "edu.cornell.mannlib.semservices.service.impl.UMLSService");
        map.put(AgrovocVocabSource, "edu.cornell.mannlib.semservices.service.impl.AgrovocService");
        map.put(GemetVocabSource, "edu.cornell.mannlib.semservices.service.impl.GemetService");
        map.put(LCSHVocabSource, "edu.cornell.mannlib.semservices.service.impl.LCSHService");
        return map;
    }

    public static List<Concept> getSearchResults(ServletContext context, VitroRequest vreq) throws Exception {
        String searchServiceName = ConceptSearchServiceUtils.getSearchServiceUri(vreq);
        String searchServiceClassName = ConceptSearchServiceUtils.getConceptSearchServiceClassName(searchServiceName);
        ExternalConceptService conceptServiceClass = null;
        Object object = null;
        try {
            Class<?> classDefinition = Class.forName(searchServiceClassName);
            object = classDefinition.newInstance();
            conceptServiceClass = object;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            System.out.println(e);
        }
        if (conceptServiceClass == null) {
            log.error((Object)("could not find Concept Search Class for " + searchServiceName));
            return null;
        }
        String searchTerm = ConceptSearchServiceUtils.getSearchTerm(vreq);
        List conceptResults = conceptServiceClass.getConcepts(searchTerm);
        return conceptResults;
    }

    private static String getSearchServiceUri(VitroRequest vreq) {
        return vreq.getParameter("source");
    }

    private static String getSearchTerm(VitroRequest vreq) {
        return vreq.getParameter("searchTerm");
    }
}

