/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.annotation.WebServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;

@WebServlet(name="ManageGrantsForIndividualController", urlPatterns={"/manageGrants"})
public class ManageGrantsForIndividualController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog((String)ManageGrantsForIndividualController.class.getName());
    private static final String TEMPLATE_NAME = "manageGrantsForIndividual.ftl";
    private static String GRANT_QUERY = "PREFIX core: <http://vivoweb.org/ontology/core#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT DISTINCT ?subclass ?role (str(?label2) as ?label) ?activity ?hideThis WHERE { \n    ?subject <http://purl.obolibrary.org/obo/RO_0000053> ?role . \n    ?role a core:ResearcherRole . \n    ?role vitro:mostSpecificType ?subclass \n    OPTIONAL { \n        ?subject <http://purl.obolibrary.org/obo/RO_0000053> ?role . \n        ?role a core:ResearcherRole . \n        ?role core:relatedBy ?activity . \n        ?activity a core:Grant . \n        ?activity rdfs:label ?label2 . \n    } \n    OPTIONAL { \n        ?subject <http://purl.obolibrary.org/obo/RO_0000053> ?role . \n        ?role a core:ResearcherRole . \n        ?role <http://purl.obolibrary.org/obo/BFO_0000054> ?activity . \n        ?activity a core:Project . \n        ?activity rdfs:label ?label2 . \n    } \n    OPTIONAL { ?role core:hideFromDisplay ?hideThis } \n} ORDER BY ?subclass ?label2";

    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.DO_FRONT_END_EDITING.ACTION;
    }

    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        String subjectUri = vreq.getParameter("subjectUri");
        body.put("subjectUri", subjectUri);
        HashMap<String, List<Map<String, String>>> grants = this.getGrants(subjectUri, vreq);
        if (log.isDebugEnabled()) {
            log.debug((Object)("grants = " + grants));
        }
        body.put("grants", grants);
        List<String> allSubclasses = this.getAllSubclasses(grants);
        body.put("allSubclasses", allSubclasses);
        Individual subject = vreq.getWebappDaoFactory().getIndividualDao().getIndividualByURI(subjectUri);
        if (subject != null && subject.getName() != null) {
            body.put("subjectName", subject.getName());
        } else {
            body.put("subjectName", null);
        }
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    HashMap<String, List<Map<String, String>>> getGrants(String subjectUri, VitroRequest vreq) {
        VClassDao vcDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getVClassDao();
        String queryStr = QueryUtils.subUriForQueryVar((String)GRANT_QUERY, (String)"subject", (String)subjectUri);
        log.debug((Object)("queryStr = " + queryStr));
        HashMap<String, List<Map<String, String>>> subclassToGrants = new HashMap<String, List<Map<String, String>>>();
        try {
            ResultSet results = QueryUtils.getQueryResults((String)queryStr, (VitroRequest)vreq);
            while (results.hasNext()) {
                String subclass;
                QuerySolution soln = results.nextSolution();
                RDFNode subclassUri = soln.get("subclass");
                if (subclassUri == null) continue;
                String subclassUriStr = soln.get("subclass").toString();
                VClass vClass = vcDao.getVClassByURI(subclassUriStr);
                String string = subclass = vClass.getName() == null ? subclassUriStr : vClass.getName();
                if (!subclassToGrants.containsKey(subclass)) {
                    subclassToGrants.put(subclass, new ArrayList());
                }
                List<Map<String, String>> grantsList = subclassToGrants.get(subclass);
                grantsList.add(QueryUtils.querySolutionToStringValueMap((QuerySolution)soln));
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return subclassToGrants;
    }

    private List<String> getAllSubclasses(HashMap<String, List<Map<String, String>>> grants) {
        ArrayList<String> allSubclasses = new ArrayList<String>(grants.keySet());
        Collections.sort(allSubclasses);
        return allSubclasses;
    }
}

