/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing;

import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Literal;

public class PersonHasPublicationValidator
implements N3ValidatorVTwo {
    private Log log = LogFactory.getLog(PersonHasPublicationValidator.class);
    private static String MISSING_FIRST_NAME_ERROR = "You must enter a value in the First Name field.";
    private static String MISSING_LAST_NAME_ERROR = "You must enter a value in the Last Name field.";
    private static String MALFORMED_LAST_NAME_ERROR = "The last name field may not contain a comma. Please enter first name in First Name field.";

    public Map<String, String> validate(EditConfigurationVTwo editConfig, MultiValueEditSubmission editSub) {
        Map urisFromForm = editSub.getUrisFromForm();
        Map literalsFromForm = editSub.getLiteralsFromForm();
        HashMap<String, String> errors = new HashMap<String, String>();
        List firstNameList = (List)literalsFromForm.get("firstName");
        Literal firstName = null;
        if (firstNameList != null && firstNameList.size() > 0) {
            firstName = (Literal)firstNameList.get(0);
        }
        if (firstName != null && firstName.getLexicalForm() != null && "".equals(firstName.getLexicalForm())) {
            firstName = null;
        }
        List lastNameList = (List)literalsFromForm.get("lastName");
        Literal lastName = null;
        if (lastNameList != null && lastNameList.size() > 0) {
            lastName = (Literal)lastNameList.get(0);
        }
        String lastNameValue = "";
        if (lastName != null && "".equals(lastNameValue = lastName.getLexicalForm())) {
            lastName = null;
        }
        if (lastName == null && firstName != null) {
            errors.put("lastName", MISSING_LAST_NAME_ERROR);
        } else if (firstName == null && lastName != null) {
            errors.put("firstName", MISSING_FIRST_NAME_ERROR);
        } else if (lastNameValue.contains(",")) {
            errors.put("lastName", MALFORMED_LAST_NAME_ERROR);
        } else {
            return null;
        }
        return errors.size() != 0 ? errors : null;
    }

    private Object getFirstElement(List checkList) {
        if (checkList == null || checkList.size() == 0) {
            return null;
        }
        return checkList.get(0);
    }
}

