/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VitroVocabulary;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.AutocompleteRequiredInputValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeIntervalValidationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeWithPrecisionVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditElementVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.ChildVClassesWithParent;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import java.util.Arrays;
import javax.servlet.http.HttpSession;
import org.apache.jena.vocabulary.XSD;

public class AddPresenterRoleToPersonGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    static final String presentationClass = "http://vivoweb.org/ontology/core#Presentation";
    static final String roleClass = "http://vivoweb.org/ontology/core#PresenterRole";
    static final String conferenceClass = "http://purl.org/ontology/bibo/Conference";
    static final String hasRolePred = "http://purl.obolibrary.org/obo/RO_0000053";
    static final String roleOfPred = "http://purl.obolibrary.org/obo/RO_0000052";
    static final String roleRealizedInPred = "http://purl.obolibrary.org/obo/BFO_0000054";
    static final String realizedRolePred = "http://purl.obolibrary.org/obo/BFO_0000055";
    static final String includesEventPred = "http://purl.obolibrary.org/obo/BFO_0000051";
    static final String eventWithinPred = "http://purl.obolibrary.org/obo/BFO_0000050";
    static final String roleToInterval = "http://vivoweb.org/ontology/core#dateTimeInterval";
    static final String intervalType = "http://vivoweb.org/ontology/core#DateTimeInterval";
    static final String intervalToStart = "http://vivoweb.org/ontology/core#start";
    static final String intervalToEnd = "http://vivoweb.org/ontology/core#end";
    static final String dateTimeValueType = "http://vivoweb.org/ontology/core#DateTimeValue";
    static final String dateTimeValue = "http://vivoweb.org/ontology/core#dateTime";
    static final String dateTimePrecision = "http://vivoweb.org/ontology/core#dateTimePrecision";
    static final String n3ForNewRole = "@prefix core: <http://vivoweb.org/ontology/core#> . \n?person <http://purl.obolibrary.org/obo/RO_0000053>  ?role . \n?role a  <http://vivoweb.org/ontology/core#PresenterRole> . \n?role <http://purl.obolibrary.org/obo/RO_0000052> ?person . ";
    static final String n3ForRoleLabelAssertion = "?role <http://www.w3.org/2000/01/rdf-schema#label> ?roleLabel . ";
    static final String n3ForNewPresentation = "?role <http://purl.obolibrary.org/obo/BFO_0000054> ?presentation . \n?presentation <http://purl.obolibrary.org/obo/BFO_0000055> ?role . \n?presentation <http://www.w3.org/2000/01/rdf-schema#label> ?presentationLabel . \n?presentation a ?presentationType .";
    static final String n3ForExistingPresentation = "?role <http://purl.obolibrary.org/obo/BFO_0000054> ?existingPresentation . \n?existingPresentation <http://purl.obolibrary.org/obo/BFO_0000055> ?role . \n?existingPresentation a ?presentationType .";
    static final String n3ForNewConferenceNewPres = "?presentation <http://purl.obolibrary.org/obo/BFO_0000050> ?newConference . \n?newConference <http://purl.obolibrary.org/obo/BFO_0000051> ?presentation . \n?newConference a <http://purl.org/ontology/bibo/Conference> . \n?newConference <http://www.w3.org/2000/01/rdf-schema#label> ?conferenceLabel .";
    static final String n3ForNewConferenceExistingPres = "?existingPresentation <http://purl.obolibrary.org/obo/BFO_0000050> ?newConference . \n?newConference <http://purl.obolibrary.org/obo/BFO_0000051> ?existingPresentation . \n?newConference a <http://purl.org/ontology/bibo/Conference> . \n?newConference <http://www.w3.org/2000/01/rdf-schema#label> ?conferenceLabel .";
    static final String n3ForExistingConferenceNewPres = "?existingConference <http://purl.obolibrary.org/obo/BFO_0000051> ?presentation . \n?presentation <http://purl.obolibrary.org/obo/BFO_0000050> ?existingConference . \n?presentation <http://www.w3.org/2000/01/rdf-schema#label> ?presentationLabel . ";
    static final String n3ForExistingConferenceExistingPres = "?existingConference <http://purl.obolibrary.org/obo/BFO_0000051> ?existingPresentation . \n?existingPresentation <http://purl.obolibrary.org/obo/BFO_0000050> ?existingConference . ";
    static final String n3ForStart = "?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode . \n?startNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n?startNode  <http://vivoweb.org/ontology/core#dateTime> ?startField-value . \n?startNode  <http://vivoweb.org/ontology/core#dateTimePrecision> ?startField-precision . \n";
    static final String n3ForEnd = "?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode . \n?endNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n?endNode  <http://vivoweb.org/ontology/core#dateTime> ?endField-value . \n?endNode  <http://vivoweb.org/ontology/core#dateTimePrecision> ?endField-precision . \n";
    static final String roleLabelQuery = "SELECT ?existingRoleLabel WHERE { \n?role <http://www.w3.org/2000/01/rdf-schema#label> ?existingRoleLabel . }";
    static final String presentationQuery = "SELECT ?existingPresentation WHERE { \n?role <http://purl.obolibrary.org/obo/BFO_0000054> ?existingPresentation . }";
    static final String presentationLabelQuery = "SELECT ?existingPresentationLabel WHERE { \n?role <http://purl.obolibrary.org/obo/BFO_0000054> ?existingPresentation . ?existingPresentation <http://www.w3.org/2000/01/rdf-schema#label> ?existingPresentationLabel . }";
    static final String presentationTypeQuery = "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?existingPresentationType WHERE { \n?role <http://purl.obolibrary.org/obo/BFO_0000054> ?existingPresentation . ?existingPresentation vitro:mostSpecificType ?existingPresentationType . }";
    static final String existingConferenceQuery = "SELECT ?existingConference WHERE { \n?role <http://purl.obolibrary.org/obo/BFO_0000054> ?existingPresentation . ?existingPresentation <http://purl.obolibrary.org/obo/BFO_0000050> ?existingConference . }";
    static final String conferenceLabelQuery = "SELECT ?existingConferenceLabel WHERE { \n?role <http://purl.obolibrary.org/obo/BFO_0000054> ?existingPresentation . ?existingPresentation <http://purl.obolibrary.org/obo/BFO_0000050> ?existingConference . \n?existingConference <http://www.w3.org/2000/01/rdf-schema#label> ?existingConferenceLabel . }";
    static final String existingStartDateQuery = "SELECT ?existingDateStart WHERE { \n  ?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode . \n  ?startNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?startNode <http://vivoweb.org/ontology/core#dateTime> ?existingDateStart . }";
    static final String existingEndDateQuery = "SELECT ?existingEndDate WHERE { \n  ?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n   ?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode . \n  ?endNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?endNode <http://vivoweb.org/ontology/core#dateTime> ?existingEndDate . }";
    static final String existingIntervalNodeQuery = "SELECT ?existingIntervalNode WHERE { \n  ?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?existingIntervalNode . \n  ?existingIntervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . }";
    static final String existingStartNodeQuery = "SELECT ?existingStartNode WHERE { \n  ?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#start> ?existingStartNode . \n  ?existingStartNode a <http://vivoweb.org/ontology/core#DateTimeValue> . }   ";
    static final String existingEndNodeQuery = "SELECT ?existingEndNode WHERE { \n  ?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#end> ?existingEndNode . \n  ?existingEndNode a <http://vivoweb.org/ontology/core#DateTimeValue> .} ";
    static final String existingStartPrecisionQuery = "SELECT ?existingStartPrecision WHERE { \n  ?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode . \n  ?startNode a  <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?startNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?existingStartPrecision . }";
    static final String existingEndPrecisionQuery = "SELECT ?existingEndPrecision WHERE { \n  ?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode . \n  ?endNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?endNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?existingEndPrecision . }";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        conf.setTemplate("addPresenterRoleToPerson.ftl");
        conf.setVarNameForSubject("person");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("role");
        conf.setN3Required(Arrays.asList(n3ForNewRole));
        conf.setN3Optional(Arrays.asList(n3ForRoleLabelAssertion, n3ForNewPresentation, n3ForExistingPresentation, n3ForNewConferenceNewPres, n3ForNewConferenceExistingPres, n3ForExistingConferenceNewPres, n3ForExistingConferenceExistingPres, n3ForStart, n3ForEnd));
        conf.addNewResource("presentation", "");
        conf.addNewResource("newConference", "");
        conf.addNewResource("role", "");
        conf.addNewResource("intervalNode", "");
        conf.addNewResource("startNode", "");
        conf.addNewResource("endNode", "");
        conf.setUrisOnform(Arrays.asList("existingPresentation", "existingConference", "presentationType"));
        conf.setLiteralsOnForm(Arrays.asList("presentationLabel", "presentationLabelDisplay", "conferenceLabel", "conferenceLabelDisplay", "roleLabel"));
        conf.addSparqlForExistingLiteral("presentationLabel", presentationLabelQuery);
        conf.addSparqlForExistingLiteral("conferenceLabel", conferenceLabelQuery);
        conf.addSparqlForExistingLiteral("roleLabel", roleLabelQuery);
        conf.addSparqlForExistingUris("existingPresentation", presentationQuery);
        conf.addSparqlForExistingUris("existingConference", existingConferenceQuery);
        conf.addSparqlForExistingUris("presentationType", presentationTypeQuery);
        conf.addSparqlForExistingLiteral("startField-value", existingStartDateQuery);
        conf.addSparqlForExistingLiteral("endField-value", existingEndDateQuery);
        conf.addSparqlForExistingUris("intervalNode", existingIntervalNodeQuery);
        conf.addSparqlForExistingUris("startNode", existingStartNodeQuery);
        conf.addSparqlForExistingUris("endNode", existingEndNodeQuery);
        conf.addSparqlForExistingUris("startField-precision", existingStartPrecisionQuery);
        conf.addSparqlForExistingUris("endField-precision", existingEndPrecisionQuery);
        conf.addField(new FieldVTwo().setName("existingPresentation"));
        conf.addField(new FieldVTwo().setName("presentationLabelDisplay").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(AddPresenterRoleToPersonGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("presentationLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(AddPresenterRoleToPersonGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("presentationType").setValidators(AddPresenterRoleToPersonGenerator.list((Object[])new Object[]{"nonempty"})).setOptions((FieldOptions)new ChildVClassesWithParent(presentationClass)));
        conf.addField(new FieldVTwo().setName("roleLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(AddPresenterRoleToPersonGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("existingConference"));
        conf.addField(new FieldVTwo().setName("conferenceLabel").setRangeDatatypeUri(XSD.xstring.toString()));
        conf.addField(new FieldVTwo().setName("conferenceLabelDisplay").setRangeDatatypeUri(XSD.xstring.toString()));
        conf.addField(new FieldVTwo().setName("startField").setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(null, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri())));
        conf.addField(new FieldVTwo().setName("endField").setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(null, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri())));
        conf.addValidator((N3ValidatorVTwo)new DateTimeIntervalValidationVTwo("startField", "endField"));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        conf.addValidator((N3ValidatorVTwo)new AutocompleteRequiredInputValidator("existingPresentation", "presentationLabel"));
        this.prepare(vreq, conf);
        return conf;
    }
}

