/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.AutocompleteObjectPropertyFormGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.DefaultDataPropertyFormGenerator;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutocompleteDataPropertyFormGenerator
extends DefaultDataPropertyFormGenerator {
    private Log log = LogFactory.getLog(AutocompleteObjectPropertyFormGenerator.class);
    private String dataPropertyTemplate = "autoCompleteDataPropForm.ftl";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo ec = super.getEditConfiguration(vreq, session);
        this.addFormSpecificData(ec, vreq);
        return ec;
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, String> formSpecificData = new HashMap<String, String>();
        formSpecificData.put("sparqlForAcFilter", this.getSparqlForAcFilter(vreq));
        editConfiguration.setTemplate(this.dataPropertyTemplate);
        formSpecificData.put("editMode", this.getEditMode(vreq));
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    public String getSparqlForAcFilter(VitroRequest vreq) {
        String subject = EditConfigurationUtils.getSubjectUri((VitroRequest)vreq);
        String predicate = EditConfigurationUtils.getPredicateUri((VitroRequest)vreq);
        String query = "SELECT ?dataLiteral WHERE { <" + subject + "> <" + predicate + "> ?dataLiteral .} ";
        return query;
    }

    public String getEditMode(VitroRequest vreq) {
        if (this.isUpdate(vreq)) {
            return "edit";
        }
        return "add";
    }

    private boolean isUpdate(VitroRequest vreq) {
        Integer dataHash = EditConfigurationUtils.getDataHash((VitroRequest)vreq);
        return dataHash != null;
    }
}

