/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VitroVocabulary;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.FirstAndLastNameValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeIntervalValidationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeWithPrecisionVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditElementVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.ChildVClassesWithParent;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.IndividualsViaVClassOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.utils.FrontEndEditingUtils;
import edu.cornell.mannlib.vitro.webapp.utils.generators.EditModeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.apache.jena.vocabulary.XSD;

public class OrganizationForTrainingGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    static final String n3ForNewEdTraining = "@prefix core: <http://vivoweb.org/ontology/core#> .\n?organization <http://purl.obolibrary.org/obo/RO_0000056>  ?edTraining .\n?edTraining  a core:EducationalProcess .\n?edTraining <http://purl.obolibrary.org/obo/RO_0000057> ?organization .";
    static final String trainingTypeAssertion = "?edTraining a ?trainingType .";
    static final String n3ForAwardedDegree = "@prefix core: <http://vivoweb.org/ontology/core#> .\n?edTraining <http://purl.obolibrary.org/obo/RO_0002234> ?awardedDegree . \n?awardedDegree <http://purl.obolibrary.org/obo/RO_0002353> ?edTraining . \n?awardedDegree <http://vivoweb.org/ontology/core#assignedBy> ?organization . \n?organization <http://vivoweb.org/ontology/core#assigns> ?awardedDegree . \n?awardedDegree <http://www.w3.org/2000/01/rdf-schema#label> ?awardedDegreeLabel . \n?awardedDegree <http://vivoweb.org/ontology/core#relates> ?degreeType .\n?degreeType <http://vivoweb.org/ontology/core#relatedBy> ?awardedDegree . \n?awardedDegree a core:AwardedDegree .";
    static final String n3ForNewPerson = "?edTraining <http://purl.obolibrary.org/obo/RO_0000057> ?newPerson . \n?newPerson <http://purl.obolibrary.org/obo/RO_0000056> ?edTraining . \n?newPerson a <http://xmlns.com/foaf/0.1/Person> . \n?newPerson <http://www.w3.org/2000/01/rdf-schema#label> ?personLabel . ";
    static final String n3ForExistingPerson = "?edTraining <http://purl.obolibrary.org/obo/RO_0000057> ?existingPerson . \n?existingPerson <http://purl.obolibrary.org/obo/RO_0000056> ?edTraining . \n ";
    static final String n3ForNewPersonAwardedDegree = "?awardedDegree <http://vivoweb.org/ontology/core#relates> ?newPerson . \n?newPerson <http://vivoweb.org/ontology/core#releatedBy> ?awardedDegree . \n?newPerson a <http://xmlns.com/foaf/0.1/Person> . \n?awardedDegree <http://www.w3.org/2000/01/rdf-schema#label> ?awardedDegreeLabel . \n?newPerson <http://www.w3.org/2000/01/rdf-schema#label> ?personLabel . ";
    static final String firstNameAssertion = "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n?newPerson <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardPerson . \n?vcardPerson <http://purl.obolibrary.org/obo/ARG_2000029>  ?newPerson . \n?vcardPerson a <http://www.w3.org/2006/vcard/ns#Individual> . \n?vcardPerson vcard:hasName  ?vcardName . \n?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n?vcardName vcard:givenName ?firstName .";
    static final String lastNameAssertion = "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n?newPerson <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardPerson . \n?vcardPerson <http://purl.obolibrary.org/obo/ARG_2000029>  ?newPerson . \n?vcardPerson a <http://www.w3.org/2006/vcard/ns#Individual> . \n?vcardPerson vcard:hasName  ?vcardName . \n?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n?vcardName vcard:familyName ?lastName .";
    static final String n3ForExistingPersonAwardedDegree = "?awardedDegree <http://vivoweb.org/ontology/core#relates> ?existingPerson . \n?existingPerson <http://vivoweb.org/ontology/core#relatedBy> ?awardedDegree . \n?awardedDegree <http://www.w3.org/2000/01/rdf-schema#label> ?awardedDegreeLabel . \n?existingPerson a <http://xmlns.com/foaf/0.1/Person> . ";
    static final String majorFieldAssertion = "?edTraining <http://vivoweb.org/ontology/core#majorField> ?majorField .";
    static final String n3ForStart = "?edTraining      <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode  <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode .\n?startNode  <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .\n?startNode  <http://vivoweb.org/ontology/core#dateTime> ?startField-value .\n?startNode  <http://vivoweb.org/ontology/core#dateTimePrecision> ?startField-precision .";
    static final String n3ForEnd = "?edTraining      <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n?intervalNode  <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode .\n?endNode  <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .\n?endNode  <http://vivoweb.org/ontology/core#dateTime> ?endField-value .\n?endNode  <http://vivoweb.org/ontology/core#dateTimePrecision> ?endField-precision .";
    static final String deptAssertion = "?edTraining <http://vivoweb.org/ontology/core#departmentOrSchool> ?dept .";
    static final String infoAssertion = "?edTraining <http://vivoweb.org/ontology/core#supplementalInformation> ?info .";
    static final String existingAwardedDegreeQuery = "SELECT ?existingAwardedDegree WHERE {\n?edTraining <http://purl.obolibrary.org/obo/RO_0002234> ?existingAwardedDegree . }\n";
    static final String existingAwardedDegreeLabelQuery = "SELECT ?existingAwardedDegreeLabel WHERE {\n?edTraining <http://purl.obolibrary.org/obo/RO_0002234> ?existingAwardedDegree . \n?existingAwardedDegree <http://www.w3.org/2000/01/rdf-schema#label> ?existingAwardedDegreeLabel }\n";
    static final String existingPersonQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>   \nSELECT ?existingPerson WHERE {\n?edTraining <http://purl.obolibrary.org/obo/RO_0000057> ?existingPerson . \n?existingPerson <http://purl.obolibrary.org/obo/RO_0000056> ?edTraining . \n?existingPerson a <http://xmlns.com/foaf/0.1/Person> . \n  }";
    static final String personLabelQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>   \nSELECT ?existingPersonLabel WHERE {\n?edTraining <http://purl.obolibrary.org/obo/RO_0000057> ?existingPerson . \n?existingPerson <http://purl.obolibrary.org/obo/RO_0000056> ?edTraining .\n?existingPerson <http://www.w3.org/2000/01/rdf-schema#label> ?existingPersonLabel .\n?existingPerson a <http://xmlns.com/foaf/0.1/Person> . \n  }";
    static final String trainingTypeQuery = "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?existingTrainingType WHERE { \n  ?edTraining vitro:mostSpecificType ?existingTrainingType .  }";
    static final String degreeTypeQuery = "PREFIX core: <http://vivoweb.org/ontology/core#> \nSELECT ?existingDegreeType WHERE {\n?edTraining <http://purl.obolibrary.org/obo/RO_0002234> ?existingAwardedDegree . \n?existingAwardedDegree a core:AwardedDegree . \n?existingAwardedDegree core:relates ?existingDegreeType .  \n?existingDegreeType a core:AcademicDegree }";
    static final String majorFieldQuery = "SELECT ?existingMajorField WHERE {\n?edTraining <http://vivoweb.org/ontology/core#majorField> ?existingMajorField . }";
    static final String deptQuery = "SELECT ?existingDept WHERE {\n?edTraining <http://vivoweb.org/ontology/core#departmentOrSchool> ?existingDept . }";
    static final String infoQuery = "SELECT ?existingInfo WHERE {\n?edTraining <http://vivoweb.org/ontology/core#supplementalInformation> ?existingInfo . }";
    static final String existingIntervalNodeQuery = "SELECT ?existingIntervalNode WHERE {\n?edTraining <http://vivoweb.org/ontology/core#dateTimeInterval> ?existingIntervalNode .\n?existingIntervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> . }";
    static final String existingStartNodeQuery = "SELECT ?existingStartNode WHERE {\n?edTraining <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#start> ?existingStartNode . \n?existingStartNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .}";
    static final String existingStartDateQuery = "SELECT ?existingDateStart WHERE {\n?edTraining <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode .\n?startNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .\n?startNode <http://vivoweb.org/ontology/core#dateTime> ?existingDateStart . }";
    static final String existingStartPrecisionQuery = "SELECT ?existingStartPrecision WHERE {\n?edTraining <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode .\n?startNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> . \n?startNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?existingStartPrecision . }";
    static final String existingEndNodeQuery = "SELECT ?existingEndNode WHERE { \n?edTraining <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#end> ?existingEndNode . \n?existingEndNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .}";
    static final String existingEndDateQuery = "SELECT ?existingEndDate WHERE {\n?edTraining <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode .\n?endNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .\n?endNode <http://vivoweb.org/ontology/core#dateTime> ?existingEndDate . }";
    static final String existingEndPrecisionQuery = "SELECT ?existingEndPrecision WHERE {\n?edTraining <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode .\n?endNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .\n?endNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?existingEndPrecision . }";
    static final String inverseTrainingAtPersonQuery = "PREFIX owl:  <http://www.w3.person/2002/07/owl#> SELECT ?inverseTrainingAtPerson     WHERE { ?inverseTrainingAtPerson owl:inverseOf <http://vivoweb.org/ontology/core#relates> . } ";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        conf.setTemplate("organizationForTraining.ftl");
        conf.setVarNameForSubject("organization");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("edTraining");
        conf.setN3Required(Arrays.asList(n3ForNewEdTraining, trainingTypeAssertion));
        conf.setN3Optional(Arrays.asList(majorFieldAssertion, n3ForAwardedDegree, n3ForNewPerson, n3ForExistingPerson, n3ForNewPersonAwardedDegree, n3ForExistingPersonAwardedDegree, deptAssertion, infoAssertion, n3ForStart, n3ForEnd, firstNameAssertion, lastNameAssertion));
        conf.addNewResource("edTraining", "");
        conf.addNewResource("awardedDegree", "");
        conf.addNewResource("newPerson", "");
        conf.addNewResource("intervalNode", "");
        conf.addNewResource("startNode", "");
        conf.addNewResource("endNode", "");
        conf.addNewResource("vcardPerson", "");
        conf.addNewResource("vcardName", "");
        conf.setUrisOnform(Arrays.asList("existingPerson", "degreeType", "trainingType"));
        conf.setLiteralsOnForm(Arrays.asList("personLabel", "personLabelDisplay", "awardedDegreeLabel", "majorField", "dept", "info", "firstName", "lastName"));
        conf.addSparqlForExistingLiteral("personLabel", personLabelQuery);
        conf.addSparqlForExistingLiteral("majorField", majorFieldQuery);
        conf.addSparqlForExistingLiteral("dept", deptQuery);
        conf.addSparqlForExistingLiteral("info", infoQuery);
        conf.addSparqlForExistingLiteral("startField-value", existingStartDateQuery);
        conf.addSparqlForExistingLiteral("endField-value", existingEndDateQuery);
        conf.addSparqlForExistingUris("awardedDegree", existingAwardedDegreeQuery);
        conf.addSparqlForExistingUris("existingPerson", existingPersonQuery);
        conf.addSparqlForExistingUris("trainingType", trainingTypeQuery);
        conf.addSparqlForExistingUris("degreeType", degreeTypeQuery);
        conf.addSparqlForExistingUris("intervalNode", existingIntervalNodeQuery);
        conf.addSparqlForExistingUris("startNode", existingStartNodeQuery);
        conf.addSparqlForExistingUris("endNode", existingEndNodeQuery);
        conf.addSparqlForExistingUris("startField-precision", existingStartPrecisionQuery);
        conf.addSparqlForExistingUris("endField-precision", existingEndPrecisionQuery);
        conf.addSparqlForAdditionalUrisInScope("inverseTrainingAtPerson", inverseTrainingAtPersonQuery);
        conf.addField(new FieldVTwo().setName("degreeType").setOptions((FieldOptions)new IndividualsViaVClassOptions(new String[]{"http://vivoweb.org/ontology/core#AcademicDegree"})));
        conf.addField(new FieldVTwo().setName("majorField").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(OrganizationForTrainingGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("existingPerson"));
        conf.addField(new FieldVTwo().setName("awardedDegree"));
        conf.addField(new FieldVTwo().setName("personLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(OrganizationForTrainingGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("awardedDegreeLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(OrganizationForTrainingGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("existingAwardedDegreeLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(OrganizationForTrainingGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("personLabelDisplay").setRangeDatatypeUri(XSD.xstring.toString()));
        conf.addField(new FieldVTwo().setName("firstName").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(OrganizationForTrainingGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("lastName").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(OrganizationForTrainingGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("trainingType").setValidators(OrganizationForTrainingGenerator.list((Object[])new Object[]{"nonempty"})).setOptions((FieldOptions)new ChildVClassesWithParent("http://vivoweb.org/ontology/core#EducationalProcess")));
        conf.addField(new FieldVTwo().setName("dept").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(OrganizationForTrainingGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("info").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(OrganizationForTrainingGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        FieldVTwo startField = new FieldVTwo().setName("startField");
        conf.addField(startField.setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(startField, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri())));
        FieldVTwo endField = new FieldVTwo().setName("endField");
        conf.addField(endField.setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(endField, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri())));
        conf.addValidator((N3ValidatorVTwo)new DateTimeIntervalValidationVTwo("startField", "endField"));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        conf.addValidator((N3ValidatorVTwo)new FirstAndLastNameValidator("existingPerson"));
        this.addFormSpecificData(conf, vreq);
        this.prepare(vreq, conf);
        return conf;
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, String> formSpecificData = new HashMap<String, String>();
        formSpecificData.put("editMode", this.getEditMode(vreq).name().toLowerCase());
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    public FrontEndEditingUtils.EditMode getEditMode(VitroRequest vreq) {
        ArrayList<String> predicates = new ArrayList<String>();
        predicates.add("http://vivoweb.org/ontology/core#relates");
        return EditModeUtils.getEditMode((VitroRequest)vreq, predicates);
    }
}

