/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VitroVocabulary;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.FirstAndLastNameValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeIntervalValidationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeWithPrecisionVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditElementVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.ChildVClassesWithParent;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.IndividualsViaVClassOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.apache.jena.vocabulary.XSD;

public class PersonHasAdviseeRelationshipGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    static final String advisingRelClass = "http://vivoweb.org/ontology/core#AdvisingRelationship";
    static final String subjAreaClass = "http://www.w3.org/2004/02/skos/core#Concept";
    static final String degreeClass = "http://vivoweb.org/ontology/core#AcademicDegree";
    static final String advisorClass = "http://xmlns.com/foaf/0.1/Person";
    static final String advisorRoleClass = "http://vivoweb.org/ontology/core#AdvisorRole";
    static final String adviseeRoleClass = "http://vivoweb.org/ontology/core#AdviseeRole";
    static final String advisingRelToInterval = "http://vivoweb.org/ontology/core#dateTimeInterval";
    static final String intervalType = "http://vivoweb.org/ontology/core#DateTimeInterval";
    static final String intervalToStart = "http://vivoweb.org/ontology/core#start";
    static final String intervalToEnd = "http://vivoweb.org/ontology/core#end";
    static final String dateTimeValueType = "http://vivoweb.org/ontology/core#DateTimeValue";
    static final String dateTimeValue = "http://vivoweb.org/ontology/core#dateTime";
    static final String dateTimePrecision = "http://vivoweb.org/ontology/core#dateTimePrecision";
    static final String n3ForNewAdvisingRelationship = "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n\n?person <http://vivoweb.org/ontology/core#relatedBy>  ?advisingRelationship . \n?advisingRelationship a  <http://vivoweb.org/ontology/core#AdvisingRelationship> . \n?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?person . \n?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n?adviseeRole a  <http://vivoweb.org/ontology/core#AdviseeRole> . \n?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n?person <http://purl.obolibrary.org/obo/RO_0000053>  ?adviseeRole . \n?adviseeRole <http://purl.obolibrary.org/obo/RO_0000052>  ?person . ";
    static final String advisingRelLabelAssertion = "?advisingRelationship <http://www.w3.org/2000/01/rdf-schema#label> ?advisingRelLabel .";
    static final String advisingRelTypeAssertion = "?advisingRelationship a ?advisingRelType .";
    static final String n3ForNewAdvisorAssertion = "?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?newAdvisor . \n?newAdvisor <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n?newAdvisor <http://www.w3.org/2000/01/rdf-schema#label> ?advisorLabel . \n?newAdvisor a <http://xmlns.com/foaf/0.1/Person>  . \n?newAdvisor <http://purl.obolibrary.org/obo/RO_0000053>  ?advisorRole . \n?advisorRole <http://purl.obolibrary.org/obo/RO_0000052>  ?newAdvisor . \n?advisorRole a  <http://vivoweb.org/ontology/core#AdvisorRole> . \n?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?advisorRole . \n?advisorRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . ";
    static final String n3ForExistingAdvisorAssertion = "?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?existingAdvisor . \n?existingAdvisor <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n?existingAdvisor <http://purl.obolibrary.org/obo/RO_0000053>  ?advisorRole . \n?advisorRole <http://purl.obolibrary.org/obo/RO_0000052>  ?existingAdvisor . \n?advisorRole a  <http://vivoweb.org/ontology/core#AdvisorRole> . \n?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?advisorRole . \n?advisorRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . ";
    static final String firstNameAssertion = "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n?newAdvisor <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardAdvisor . \n?vcardAdvisor <http://purl.obolibrary.org/obo/ARG_2000029>  ?newAdvisor . \n?vcardAdvisor a <http://www.w3.org/2006/vcard/ns#Individual> . \n?vcardAdvisor vcard:hasName  ?vcardName . \n?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n?vcardName vcard:givenName ?firstName .";
    static final String lastNameAssertion = "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n?newAdvisor <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardAdvisor . \n?vcardAdvisor <http://purl.obolibrary.org/obo/ARG_2000029>  ?newAdvisor . \n?vcardAdvisor a <http://www.w3.org/2006/vcard/ns#Individual> . \n?vcardAdvisor vcard:hasName  ?vcardName . \n?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n?vcardName vcard:familyName ?lastName .";
    static final String degreeAssertion = "?advisingRelationship <http://vivoweb.org/ontology/core#degreeCandidacy> ?degree . \n ";
    static final String n3ForExistingSubjAreaAssertion = "?advisingRelationship <http://vivoweb.org/ontology/core#hasSubjectArea> ?existingSubjArea . \n?existingSubjArea <http://vivoweb.org/ontology/core#subjectAreaOf> ?advisingRelationship . ";
    static final String n3ForNewSubjAreaAssertion = "?advisingRelationship <http://vivoweb.org/ontology/core#hasSubjectArea> ?newSubjArea . \n?newSubjArea <http://vivoweb.org/ontology/core#subjectAreaOf> ?advisingRelationship . \n?newSubjArea <http://www.w3.org/2000/01/rdf-schema#label> ?subjAreaLabel . \n?newSubjArea a <http://www.w3.org/2004/02/skos/core#Concept> . ";
    static final String n3ForStart = "?advisingRelationship <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode . \n?startNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n?startNode  <http://vivoweb.org/ontology/core#dateTime> ?startField-value . \n?startNode  <http://vivoweb.org/ontology/core#dateTimePrecision> ?startField-precision . \n";
    static final String n3ForEnd = "?advisingRelationship <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode . \n?endNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n?endNode  <http://vivoweb.org/ontology/core#dateTime> ?endField-value . \n?endNode  <http://vivoweb.org/ontology/core#dateTimePrecision> ?endField-precision . \n";
    static final String existingAdvisingRelQuery = "SELECT ?advisingRelationship WHERE { \n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n}";
    static final String advisingRelTypeQuery = "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?advisingRelType WHERE { \n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n ?advisingRelationship vitro:mostSpecificType ?advisingRelType . \n}";
    static final String advisingRelLabelQuery = "SELECT ?existingAdvisingRelLabel WHERE { \n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n ?advisingRelationship <http://www.w3.org/2000/01/rdf-schema#label> ?existingAdvisingRelLabel . \n}";
    static final String advisorQuery = "SELECT ?existingAdvisor WHERE { \n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?existingAdvisor . \n ?existingAdvisor <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?existingAdvisor a <http://xmlns.com/foaf/0.1/Person>  . \n ?existingAdvisor <http://purl.obolibrary.org/obo/RO_0000053> ?existingAdvisorRole . \n ?existingAdvisorRole a <http://vivoweb.org/ontology/core#AdvisorRole>  . \n}";
    static final String advisorLabelQuery = "SELECT ?existingAdvisorLabel WHERE { \n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?existingAdvisor . \n ?existingAdvisor <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?existingAdvisor a <http://xmlns.com/foaf/0.1/Person>  . \n ?existingAdvisor <http://www.w3.org/2000/01/rdf-schema#label> ?existingAdvisorLabel . \n ?existingAdvisor <http://purl.obolibrary.org/obo/RO_0000053> ?existingAdvisorRole . \n ?existingAdvisorRole a <http://vivoweb.org/ontology/core#AdvisorRole>  . \n}";
    static final String existingAdvisorRoleQuery = "SELECT ?existingAdvisorRole WHERE { \n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?existingAdvisorRole . \n ?existingAdvisorRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?existingAdvisorRole a  <http://vivoweb.org/ontology/core#AdvisorRole> . \n}";
    static final String subjAreaQuery = "SELECT ?existingSubjArea WHERE { \n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n ?advisingRelationship <http://vivoweb.org/ontology/core#hasSubjectArea> ?existingSubjArea . \n ?existingSubjArea a <http://www.w3.org/2004/02/skos/core#Concept>  . \n ?existingSubjArea <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#mostSpecificType> ?type \n}";
    static final String subjAreaLabelQuery = "SELECT ?existingSubjAreaLabel WHERE { \n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n ?advisingRelationship <http://vivoweb.org/ontology/core#hasSubjectArea> ?existingSubjArea . \n ?existingSubjArea a <http://www.w3.org/2004/02/skos/core#Concept>  . \n ?existingSubjArea <http://www.w3.org/2000/01/rdf-schema#label> ?existingSubjAreaLabel . \n ?existingSubjArea <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#mostSpecificType> ?type \n}";
    static final String degreeQuery = "SELECT ?existingDegree WHERE {\n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n ?advisingRelationship <http://vivoweb.org/ontology/core#degreeCandidacy> ?existingDegree . \n ?existingDegree a  <http://vivoweb.org/ontology/core#AcademicDegree> . \n}";
    static final String existingStartDateQuery = "SELECT ?existingDateStart WHERE { \n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n  ?advisingRelationship <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode . \n  ?startNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?startNode <http://vivoweb.org/ontology/core#dateTime> ?existingDateStart . }";
    static final String existingEndDateQuery = "SELECT ?existingEndDate WHERE { \n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n  ?advisingRelationship <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n   ?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode . \n  ?endNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?endNode <http://vivoweb.org/ontology/core#dateTime> ?existingEndDate . }";
    static final String existingIntervalNodeQuery = "SELECT ?existingIntervalNode WHERE { \n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n  ?advisingRelationship <http://vivoweb.org/ontology/core#dateTimeInterval> ?existingIntervalNode . \n  ?existingIntervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . }";
    static final String existingStartNodeQuery = "SELECT ?existingStartNode WHERE { \n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n  ?advisingRelationship <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#start> ?existingStartNode . \n  ?existingStartNode a <http://vivoweb.org/ontology/core#DateTimeValue> .}   ";
    static final String existingEndNodeQuery = "SELECT ?existingEndNode WHERE { \n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n  ?advisingRelationship <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#end> ?existingEndNode . \n  ?existingEndNode a <http://vivoweb.org/ontology/core#DateTimeValue> } ";
    static final String existingStartPrecisionQuery = "SELECT ?existingStartPrecision WHERE { \n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n  ?advisingRelationship <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode . \n  ?startNode a  <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?startNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?existingStartPrecision . }";
    static final String existingEndPrecisionQuery = "SELECT ?existingEndPrecision WHERE { \n ?adviseeRole <http://vivoweb.org/ontology/core#relatedBy> ?advisingRelationship . \n ?advisingRelationship <http://vivoweb.org/ontology/core#relates> ?adviseeRole . \n  ?advisingRelationship <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode . \n  ?endNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?endNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?existingEndPrecision . }";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        conf.setTemplate("personHasAdviseeRelationship.ftl");
        conf.setVarNameForSubject("person");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("adviseeRole");
        conf.setN3Required(Arrays.asList(n3ForNewAdvisingRelationship, advisingRelLabelAssertion, advisingRelTypeAssertion));
        conf.setN3Optional(Arrays.asList(n3ForNewAdvisorAssertion, n3ForExistingAdvisorAssertion, degreeAssertion, firstNameAssertion, lastNameAssertion, n3ForExistingSubjAreaAssertion, n3ForNewSubjAreaAssertion, n3ForStart, n3ForEnd));
        conf.addNewResource("advisingRelationship", "");
        conf.addNewResource("newAdvisor", "");
        conf.addNewResource("vcardAdvisor", "");
        conf.addNewResource("vcardName", "");
        conf.addNewResource("adviseeRole", "");
        conf.addNewResource("advisorRole", "");
        conf.addNewResource("newSubjArea", "");
        conf.addNewResource("intervalNode", "");
        conf.addNewResource("startNode", "");
        conf.addNewResource("endNode", "");
        conf.setUrisOnform(Arrays.asList("advisingRelType", "existingSubjArea", "degree", "existingAdvisor"));
        conf.setLiteralsOnForm(Arrays.asList("advisingRelLabel", "subjAreaLabel", "advisorLabel", "firstName", "lastName", "subjAreaLabelDisplay", "advisorLabelDisplay"));
        conf.addSparqlForExistingLiteral("advisingRelLabel", advisingRelLabelQuery);
        conf.addSparqlForExistingLiteral("advisorLabel", advisorLabelQuery);
        conf.addSparqlForExistingLiteral("subjAreaLabel", subjAreaLabelQuery);
        conf.addSparqlForExistingLiteral("startField-value", existingStartDateQuery);
        conf.addSparqlForExistingLiteral("endField-value", existingEndDateQuery);
        conf.addSparqlForExistingUris("advisingRelType", advisingRelTypeQuery);
        conf.addSparqlForExistingUris("advisingRelationship", existingAdvisingRelQuery);
        conf.addSparqlForExistingUris("advisorRole", existingAdvisorRoleQuery);
        conf.addSparqlForExistingUris("existingSubjArea", subjAreaQuery);
        conf.addSparqlForExistingUris("existingAdvisor", advisorQuery);
        conf.addSparqlForExistingUris("degree", degreeQuery);
        conf.addSparqlForExistingUris("intervalNode", existingIntervalNodeQuery);
        conf.addSparqlForExistingUris("startNode", existingStartNodeQuery);
        conf.addSparqlForExistingUris("endNode", existingEndNodeQuery);
        conf.addSparqlForExistingUris("startField-precision", existingStartPrecisionQuery);
        conf.addSparqlForExistingUris("endField-precision", existingEndPrecisionQuery);
        conf.addField(new FieldVTwo().setName("advisingRelType").setValidators(PersonHasAdviseeRelationshipGenerator.list((Object[])new Object[]{"nonempty"})).setOptions((FieldOptions)new ChildVClassesWithParent(advisingRelClass)));
        conf.addField(new FieldVTwo().setName("advisingRelLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasAdviseeRelationshipGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("firstName").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasAdviseeRelationshipGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("lastName").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasAdviseeRelationshipGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("existingSubjArea"));
        conf.addField(new FieldVTwo().setName("subjAreaLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasAdviseeRelationshipGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("degree").setOptions((FieldOptions)new IndividualsViaVClassOptions(new String[]{degreeClass})));
        conf.addField(new FieldVTwo().setName("existingAdvisor"));
        conf.addField(new FieldVTwo().setName("advisorLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasAdviseeRelationshipGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("subjAreaLabelDisplay").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasAdviseeRelationshipGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("advisorLabelDisplay").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasAdviseeRelationshipGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("startField").setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(null, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri())));
        conf.addField(new FieldVTwo().setName("endField").setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(null, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri())));
        conf.addValidator((N3ValidatorVTwo)new DateTimeIntervalValidationVTwo("startField", "endField"));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        conf.addValidator((N3ValidatorVTwo)new FirstAndLastNameValidator("existingAdvisor"));
        this.addFormSpecificData(conf, vreq);
        this.prepare(vreq, conf);
        return conf;
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, String> formSpecificData = new HashMap<String, String>();
        formSpecificData.put("sparqlForAcFilter", this.getSparqlForAcFilter(vreq));
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    public String getSparqlForAcFilter(VitroRequest vreq) {
        String subject = EditConfigurationUtils.getSubjectUri((VitroRequest)vreq);
        String predicate = EditConfigurationUtils.getPredicateUri((VitroRequest)vreq);
        String query = "SELECT ?objectVar WHERE { <" + subject + "> <" + predicate + "> ?objectVar .} ";
        return query;
    }
}

