/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.BaseEditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.ManageLabelsForIndividualGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.ManageLabelsForPersonGenerator;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VIVOManageLabelsGenerator
extends BaseEditConfigurationGenerator
implements EditConfigurationGenerator {
    public static Log log = LogFactory.getLog(ManageLabelsForIndividualGenerator.class);

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo e = null;
        String subjectUri = EditConfigurationUtils.getSubjectUri((VitroRequest)vreq);
        e = this.isPersonType(subjectUri, vreq) ? new ManageLabelsForPersonGenerator().getEditConfiguration(vreq, session) : new ManageLabelsForIndividualGenerator().getEditConfiguration(vreq, session);
        return e;
    }

    public boolean isPersonType(String subjectUri, VitroRequest vreq) {
        Boolean isPersonType = Boolean.FALSE;
        String foafPersonType = this.getFOAFPersonClassURI();
        List<VClass> vclasses = this.getVClasses(subjectUri, vreq);
        if (vclasses != null) {
            for (VClass v : vclasses) {
                String typeUri = v.getURI();
                if (!foafPersonType.equals(typeUri)) continue;
                isPersonType = Boolean.TRUE;
                break;
            }
        }
        return isPersonType;
    }

    public String getFOAFPersonClassURI() {
        return "http://xmlns.com/foaf/0.1/Person";
    }

    public List<VClass> getVClasses(String subjectUri, VitroRequest vreq) {
        Individual subject = EditConfigurationUtils.getIndividual((VitroRequest)vreq, (String)subjectUri);
        return subject.getVClasses();
    }
}

